/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.xml;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import net.jxta.impl.xml.XmlParser;

public class BinaryXmlGenerator {
    static final int INTERN = 1;
    static final int START_TAG = 2;
    static final int ATTRIBUTE_NAME = 3;
    static final int ATTRIBUTE_VALUE = 4;
    static final int CHARS = 5;
    static final int END_TAG = 6;
    static final int END_DOCUMENT = 7;
    XmlParser parser = new XmlParser();

    public void generate(InputStream inputStream, OutputStream outputStream, AtomTable atomTable, byte[] byArray) throws IOException, XmlParser.Exception {
        XmlParser.parse(inputStream, byArray, new ParserCallback(atomTable, outputStream));
        outputStream.write(7);
    }

    int emitInstruction(DataOutputStream dataOutputStream, AtomTable atomTable, int n, byte[] byArray, int n2, int n3) throws IOException {
        String string = new String(byArray, n2, n3);
        int n4 = atomTable.getId(string);
        if (n4 == -1) {
            n4 = atomTable.intern(string);
            dataOutputStream.write(1);
            dataOutputStream.writeInt(n4);
            dataOutputStream.writeInt(n3);
            dataOutputStream.write(byArray, n2, n3);
        }
        dataOutputStream.write(n);
        dataOutputStream.writeInt(n4);
        return n4;
    }

    class ParserCallback
    implements XmlParser.ParserCallback {
        AtomTable atomTable;
        DataOutputStream out;
        int curTagId;

        ParserCallback(AtomTable atomTable, OutputStream outputStream) {
            this.atomTable = atomTable;
            this.out = new DataOutputStream(outputStream);
        }

        public void startTag(byte[] byArray, int n, int n2) throws XmlParser.Exception {
            try {
                this.curTagId = BinaryXmlGenerator.this.emitInstruction(this.out, this.atomTable, 2, byArray, n, n2);
            }
            catch (IOException iOException) {
                throw new XmlParser.Exception("IOException writing binary data.", iOException);
            }
        }

        public void attribute(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws XmlParser.Exception {
            try {
                BinaryXmlGenerator.this.emitInstruction(this.out, this.atomTable, 3, byArray, n, n2);
                BinaryXmlGenerator.this.emitInstruction(this.out, this.atomTable, 4, byArray2, n3, n4);
            }
            catch (IOException iOException) {
                throw new XmlParser.Exception("IOException writing binary data.", iOException);
            }
        }

        public void chars(byte[] byArray, int n, int n2) throws XmlParser.Exception {
            int n3 = n;
            while (n3 < n + n2) {
                if (!Character.isWhitespace((char)byArray[n3])) break;
                ++n3;
            }
            int n4 = n3;
            n3 = n + n2;
            while (n3 >= n4) {
                if (!Character.isWhitespace((char)byArray[n3])) break;
                --n3;
            }
            int n5 = n3 - n4;
            try {
                this.out.write(5);
                this.out.writeInt(n5);
                this.out.write(byArray, n4, n5);
            }
            catch (IOException iOException) {
                throw new XmlParser.Exception("IOException writing binary data.", iOException);
            }
        }

        public void endTag(byte[] byArray, int n, int n2) throws XmlParser.Exception {
            try {
                this.out.write(6);
                this.out.writeInt(this.curTagId);
            }
            catch (IOException iOException) {
                throw new XmlParser.Exception("IOException writing binary data.", iOException);
            }
        }
    }

    public static class AtomTable {
        HashMap table = new HashMap();
        int nextId = 0;
        int maxAtoms;
        int maxSize;
        int size;

        public AtomTable(int n, int n2) {
            this.maxAtoms = n;
            this.maxSize = n2;
        }

        int getId(String string) {
            Integer n = (Integer)this.table.get(string);
            return n == null ? -1 : n;
        }

        int intern(String string) {
            if (this.nextId == this.maxAtoms) {
                this.nextId = 0;
            }
            if ((this.size += string.length()) > this.maxSize) {
                this.nextId = 0;
            }
            int n = this.nextId++;
            this.table.put(string, new Integer(n));
            return n;
        }
    }
}

