/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;

public class Base64 {
    private Base64() {
    }

    public static byte[] decodeBase64(String string) throws IOException {
        char c;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StringReader stringReader = new StringReader(string);
        while ((c = Base64.getBase64Char(stringReader)) != '\u0000') {
            char c2 = Base64.getBase64Char(stringReader);
            if (c2 == '\u0000') {
                throw new IOException("binary data not a multiple of four bytes");
            }
            char c3 = Base64.getBase64Char(stringReader);
            if (c3 == '\u0000') {
                throw new IOException("binary data not a multiple of four bytes");
            }
            char c4 = Base64.getBase64Char(stringReader);
            if (c4 == '\u0000') {
                throw new IOException("binary data not a multiple of four bytes");
            }
            if (c == '=') {
                throw new IOException("'=' found in first position of base64 data");
            }
            if (c2 == '=') {
                throw new IOException("'=' found in second position of base64 data");
            }
            int n = 3;
            if (c3 == '=') {
                n = 1;
                c4 = 'A';
                c3 = 'A';
            } else if (c4 == '=') {
                n = 2;
                c4 = 'A';
            }
            int n2 = (Base64.decodeSixBits(c) << 18) + (Base64.decodeSixBits(c2) << 12) + (Base64.decodeSixBits(c3) << 6) + Base64.decodeSixBits(c4);
            int n3 = n2 >> 16 & 0xFF;
            int n4 = n2 >> 8 & 0xFF;
            int n5 = n2 & 0xFF;
            byteArrayOutputStream.write(n3);
            if (n >= 2) {
                byteArrayOutputStream.write(n4);
            }
            if (n != 3) continue;
            byteArrayOutputStream.write(n5);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static char getBase64Char(StringReader stringReader) throws IOException {
        char c;
        do {
            int n;
            if ((n = stringReader.read()) == -1) {
                return '\u0000';
            }
            c = (char)n;
            if ('A' <= c && c <= 'Z') {
                return c;
            }
            if ('a' <= c && c <= 'z') {
                return c;
            }
            if ('0' <= c && c <= '9') {
                return c;
            }
            if (c == '+') {
                return c;
            }
            if (c != '/') continue;
            return c;
        } while (c != '=');
        return c;
    }

    public static String encodeBase64(byte[] byArray) {
        int n;
        int n2;
        int n3 = 0;
        StringWriter stringWriter = new StringWriter();
        int n4 = byArray.length / 3 * 3;
        int n5 = 0;
        while (n5 < n4) {
            n2 = (byArray[n5] << 16) + ((byArray[n5 + 1] & 0xFF) << 8) + (byArray[n5 + 2] & 0xFF);
            n = n2 >> 18 & 0x3F;
            stringWriter.write(Base64.encodeSixBits(n));
            n = n2 >> 12 & 0x3F;
            stringWriter.write(Base64.encodeSixBits(n));
            n = n2 >> 6 & 0x3F;
            stringWriter.write(Base64.encodeSixBits(n));
            n = n2 >> 0 & 0x3F;
            stringWriter.write(Base64.encodeSixBits(n));
            if ((n3 += 4) >= 76) {
                stringWriter.write("\r\n");
                n3 = 0;
            }
            n5 += 3;
        }
        switch (byArray.length - n4) {
            case 0: {
                break;
            }
            case 1: {
                n2 = byArray[n4] << 16;
                n = n2 >> 18 & 0x3F;
                stringWriter.write(Base64.encodeSixBits(n));
                n = n2 >> 12 & 0x3F;
                stringWriter.write(Base64.encodeSixBits(n));
                stringWriter.write(61);
                stringWriter.write(61);
                break;
            }
            case 2: {
                n2 = (byArray[n4] << 16) + ((byArray[n4 + 1] & 0xFF) << 8);
                n = n2 >> 18 & 0x3F;
                stringWriter.write(Base64.encodeSixBits(n));
                n = n2 >> 12 & 0x3F;
                stringWriter.write(Base64.encodeSixBits(n));
                n = n2 >> 6 & 0x3F;
                stringWriter.write(Base64.encodeSixBits(n));
                stringWriter.write(61);
            }
        }
        stringWriter.write("\r\n");
        return stringWriter.toString();
    }

    private static char encodeSixBits(int n) {
        int n2 = n <= 25 ? (int)(65 + n) : (n <= 51 ? (int)(97 + n - 26) : (n <= 61 ? (int)((char)(48 + n - 52)) : (n == 62 ? 43 : 47)));
        return (char)n2;
    }

    private static int decodeSixBits(char c) {
        int n = 'A' <= c && c <= 'Z' ? c - 65 : ('a' <= c && c <= 'z' ? c - 97 + 26 : ('0' <= c && c <= '9' ? c - 48 + 52 : (c == '+' ? 62 : 63)));
        return n;
    }

    public static void main(String[] stringArray) {
        byte[] byArray = new byte[200];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)n;
            ++n;
        }
        System.out.println(Base64.encodeBase64(byArray));
    }
}

