/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.pipe;

import java.io.IOException;
import java.net.URL;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.pipe.PipeResolver;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.OutputPipe;
import net.jxta.protocol.PipeAdvertisement;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class SecureOutputPipe
implements OutputPipe {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$pipe$SecureOutputPipe == null ? (class$net$jxta$impl$pipe$SecureOutputPipe = SecureOutputPipe.class$("net.jxta.impl.pipe.SecureOutputPipe")) : class$net$jxta$impl$pipe$SecureOutputPipe).getName());
    private String pipeId = null;
    private PeerGroup myGroup = null;
    private EndpointService endpoint = null;
    private PipeResolver myPipeResolver = null;
    private EndpointAddress destAddress = null;
    private EndpointMessenger destMessenger = null;
    private String peer = null;
    private static final long RetryDelay = 5000L;
    private boolean closed = false;
    private PipeAdvertisement pAdv = null;
    static /* synthetic */ Class class$net$jxta$impl$pipe$SecureOutputPipe;

    private EndpointAddress mkAddress(String string, String string2) {
        try {
            PeerID peerID = (PeerID)IDFactory.fromURL(new URL(string));
            String string3 = "jxtatls://" + peerID.getUniqueValue().toString();
            EndpointAddress endpointAddress = this.endpoint.newEndpointAddress(string3);
            endpointAddress.setServiceName("PipeService");
            endpointAddress.setServiceParameter(string2);
            return endpointAddress;
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.ERROR)) {
                LOG.error((Object)("invalid PeerID string: " + string));
            }
            return null;
        }
    }

    public SecureOutputPipe(PeerGroup peerGroup, PipeResolver pipeResolver, PipeAdvertisement pipeAdvertisement, String string, long l) throws IOException {
        this.myGroup = peerGroup;
        this.endpoint = peerGroup.getEndpointService();
        this.pAdv = pipeAdvertisement;
        ID iD = pipeAdvertisement.getPipeID();
        this.pipeId = iD.toString();
        this.myPipeResolver = pipeResolver;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Constructor for " + iD));
        }
        this.peer = null;
        if (string == null) {
            this.peer = this.myPipeResolver.find(pipeAdvertisement, l, false);
            if (this.peer == null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("Constructor: no macthing InputPipe for " + iD));
                }
                throw new IOException("Constructor: no macthing InputPipe for " + iD);
            }
        } else {
            this.peer = string;
        }
        this.myPipeResolver.sendVerify(this.peer, this.pipeId, "JxtaPropagate");
        this.destMessenger = this.endpoint.getMessenger(this.mkAddress(this.peer, this.pipeId));
        if (this.destMessenger == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Constructor: no EndpointService Messenger for " + iD));
            }
            throw new IOException("Constructor: no EndpointService Messenger for " + iD);
        }
    }

    protected SecureOutputPipe(PeerGroup peerGroup, PipeResolver pipeResolver, PipeAdvertisement pipeAdvertisement, String string) throws IOException {
        this.myGroup = peerGroup;
        this.endpoint = peerGroup.getEndpointService();
        this.pAdv = pipeAdvertisement;
        ID iD = pipeAdvertisement.getPipeID();
        this.pipeId = iD.toString();
        this.peer = string;
        this.myPipeResolver = pipeResolver;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Constructor for " + iD));
        }
        this.destMessenger = this.endpoint.getMessenger(this.mkAddress(string, this.pipeId));
        if (this.destMessenger == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Constructor: no EndpointService Messenger for " + iD));
            }
            throw new IOException("Constructor: no EndpointService Messenger for " + iD);
        }
    }

    public void send(Message message) throws IOException {
        String string;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"send");
        }
        if ((string = this.myPipeResolver.findLocal(this.pipeId)) == null) {
            string = this.myPipeResolver.find(this.pAdv, 5000L, true);
            if (this.peer == null) {
                throw new IOException("null dest peer");
            }
        }
        if (!string.equals(this.peer)) {
            this.peer = string;
            this.destMessenger.close();
            this.destMessenger = this.endpoint.getMessenger(this.mkAddress(this.peer, this.pipeId));
            if (this.destMessenger == null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("sendMessage: no EndpointService Messenger for " + this.pipeId));
                }
                throw new IOException("sendMessage: no EndpointService Messenger for " + this.pipeId);
            }
        }
        this.destMessenger.sendMessage(message);
    }

    public synchronized void close() {
        this.destMessenger.close();
        this.closed = true;
    }

    protected void finalize() throws Throwable {
        if (!this.closed) {
            this.close();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

