/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.pipe;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import net.jxta.document.Advertisement;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.pipe.InputPipeImpl;
import net.jxta.impl.pipe.NonBlockingOutputPipe;
import net.jxta.impl.pipe.PipeResolver;
import net.jxta.impl.pipe.PipeServiceInterface;
import net.jxta.impl.pipe.SecureInputPipeImpl;
import net.jxta.impl.pipe.SecureOutputPipe;
import net.jxta.impl.pipe.WirePipe;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.OutputPipeEvent;
import net.jxta.pipe.OutputPipeListener;
import net.jxta.pipe.PipeID;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.service.Service;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class PipeServiceImpl
implements PipeService {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$pipe$PipeServiceImpl == null ? (class$net$jxta$impl$pipe$PipeServiceImpl = PipeServiceImpl.class$("net.jxta.impl.pipe.PipeServiceImpl")) : class$net$jxta$impl$pipe$PipeServiceImpl).getName());
    private static Hashtable queueTable = null;
    private PeerGroup myGroup = null;
    private EndpointService endpoint = null;
    private PipeResolver pipeResolver = null;
    private ModuleImplAdvertisement implAdvertisement = null;
    private Hashtable listeners = new Hashtable();
    private Hashtable wirePipes = new Hashtable();
    static /* synthetic */ Class class$net$jxta$impl$pipe$PipeServiceImpl;

    public Service getInterface() {
        return new PipeServiceInterface(this);
    }

    public Advertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    public int startApp(String[] stringArray) {
        this.pipeResolver = new PipeResolver(this.myGroup);
        return 0;
    }

    public void stopApp() {
        if (this.pipeResolver == null) {
            return;
        }
        this.pipeResolver.stop();
        this.pipeResolver = null;
    }

    public void init(PeerGroup peerGroup, ID iD, Advertisement advertisement) {
        this.implAdvertisement = (ModuleImplAdvertisement)advertisement;
        this.myGroup = peerGroup;
        queueTable = new Hashtable();
        this.endpoint = this.myGroup.getEndpointService();
    }

    public InputPipe createInputPipe(PipeAdvertisement pipeAdvertisement) throws IOException {
        InputPipe inputPipe = null;
        String string = pipeAdvertisement.getType();
        PipeID pipeID = (PipeID)pipeAdvertisement.getPipeID().clone();
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("createInputPipe: " + pipeID.toString()));
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("           type: " + string));
        }
        if (string.equals("JxtaUnicast")) {
            if (this.pipeResolver == null) {
                throw new IOException("PipeResolver not ready");
            }
            inputPipe = new InputPipeImpl(this.myGroup, this.pipeResolver, pipeID);
        } else if (string.equals("JxtaUnicastSecure")) {
            if (this.pipeResolver == null) {
                throw new IOException("PipeResolver not ready");
            }
            inputPipe = new SecureInputPipeImpl(this.myGroup, this.pipeResolver, pipeID);
        } else if (string.equals("JxtaPropagate")) {
            WirePipe wirePipe = this.createWirePipe(pipeAdvertisement);
            if (wirePipe == null) {
                throw new IOException("Invalid propagate pipe");
            }
            inputPipe = wirePipe.createInputPipe();
        } else {
            throw new IOException("unknown pipe type");
        }
        return inputPipe;
    }

    public InputPipe createInputPipe(PipeAdvertisement pipeAdvertisement, PipeMsgListener pipeMsgListener) throws IOException {
        String string = pipeAdvertisement.getType();
        PipeID pipeID = (PipeID)pipeAdvertisement.getPipeID().clone();
        InputPipe inputPipe = null;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("createInputPipe: " + pipeID.toString()));
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("           type: " + string));
        }
        if (string.equals("JxtaUnicast")) {
            if (this.pipeResolver == null) {
                throw new IOException("PipeResolver not ready");
            }
            inputPipe = new InputPipeImpl(this.myGroup, this.pipeResolver, pipeID, pipeMsgListener);
        } else if (string.equals("JxtaUnicastSecure")) {
            if (this.pipeResolver == null) {
                throw new IOException("PipeResolver not ready");
            }
            inputPipe = new SecureInputPipeImpl(this.myGroup, this.pipeResolver, pipeID, pipeMsgListener);
        } else if (string.equals("JxtaPropagate")) {
            WirePipe wirePipe = this.createWirePipe(pipeAdvertisement);
            if (wirePipe == null) {
                throw new IOException("Invalid propagate pipe");
            }
            inputPipe = wirePipe.createInputPipe(pipeMsgListener);
        } else {
            throw new IOException("unknown pipe type");
        }
        return inputPipe;
    }

    public OutputPipe createOutputPipe(PipeAdvertisement pipeAdvertisement, int n, long l) throws IOException {
        return this.createOutputPipe(pipeAdvertisement, l);
    }

    public OutputPipe createOutputPipe(PipeAdvertisement pipeAdvertisement, long l) throws IOException {
        if (this.pipeResolver == null) {
            throw new IOException("PipeResolver not ready");
        }
        PipeID pipeID = (PipeID)pipeAdvertisement.getPipeID().clone();
        String string = pipeAdvertisement.getType();
        if (string == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"No type - use UnicastType as default");
            }
            string = "JxtaUnicast";
        }
        OutputPipe outputPipe = null;
        if (string.equals("JxtaUnicast")) {
            outputPipe = new NonBlockingOutputPipe(this.myGroup, this.pipeResolver, pipeAdvertisement, null, l);
        } else if (string.equals("JxtaUnicastSecure")) {
            outputPipe = new SecureOutputPipe(this.myGroup, this.pipeResolver, pipeAdvertisement, null, l);
        } else if (string.equals("JxtaPropagate")) {
            WirePipe wirePipe = this.createWirePipe(pipeAdvertisement);
            if (wirePipe == null) {
                throw new IOException("Invalid propagate pipe");
            }
            outputPipe = wirePipe.createOutputPipe(l);
        } else {
            throw new IOException("unknown pipe type");
        }
        return outputPipe;
    }

    public OutputPipe createOutputPipe(PipeAdvertisement pipeAdvertisement, int n, Enumeration enumeration, long l) throws IOException {
        return this.createOutputPipe(pipeAdvertisement, enumeration, l);
    }

    public OutputPipe createOutputPipe(PipeAdvertisement pipeAdvertisement, Enumeration enumeration, long l) throws IOException {
        if (this.pipeResolver == null) {
            throw new IOException("PipeResolver not ready");
        }
        PipeID pipeID = (PipeID)pipeAdvertisement.getPipeID().clone();
        String string = pipeAdvertisement.getType();
        if (string == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"No type - use UnicastType as default");
            }
            string = "JxtaUnicast";
        }
        OutputPipe outputPipe = null;
        String string2 = null;
        if (enumeration == null || !enumeration.hasMoreElements()) {
            throw new IOException("null peers");
        }
        try {
            string2 = ((PeerID)enumeration.nextElement()).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string.equals("JxtaUnicast")) {
            outputPipe = new NonBlockingOutputPipe(this.myGroup, this.pipeResolver, pipeAdvertisement, string2, l);
        } else if (string.equals("JxtaUnicastSecure")) {
            outputPipe = new SecureOutputPipe(this.myGroup, this.pipeResolver, pipeAdvertisement, string2, l);
        } else if (string.equals("JxtaPropagate")) {
            WirePipe wirePipe = this.createWirePipe(pipeAdvertisement);
            if (wirePipe == null) {
                throw new IOException("Invalid propagate pipe");
            }
            outputPipe = wirePipe.createOutputPipe(enumeration, l);
        } else {
            throw new IOException("unknown pipe type");
        }
        return outputPipe;
    }

    public void createOutputPipe(PipeAdvertisement pipeAdvertisement, int n, OutputPipeListener outputPipeListener) throws IOException {
        this.createOutputPipe(pipeAdvertisement, outputPipeListener);
    }

    public void createOutputPipe(PipeAdvertisement pipeAdvertisement, OutputPipeListener outputPipeListener) throws IOException {
        if (this.pipeResolver == null) {
            throw new IOException("PipeResolver not ready");
        }
        PipeID pipeID = (PipeID)pipeAdvertisement.getPipeID().clone();
        String string = pipeAdvertisement.getType();
        if (string == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"No type - use UnicastType as default");
            }
            string = "JxtaUnicast";
        }
        if (!string.equals("JxtaUnicast") && !string.equals("JxtaUnicastSecure")) {
            if (string.equals("JxtaPropagate")) {
                throw new IOException("Propagated PipeService do not allow OutputPipe listener");
            }
            throw new IOException("unknown pipe type");
        }
        this.listeners.put(pipeID.toString(), outputPipeListener);
        PipeListener pipeListener = new PipeListener(pipeAdvertisement, this.myGroup.getPeerID());
        this.pipeResolver.addListener(pipeID.toString(), pipeListener);
        this.pipeResolver.find(pipeAdvertisement, 1L, false);
    }

    public Message createMessage() {
        return this.endpoint.newMessage();
    }

    public void addAddresses(PipeAdvertisement pipeAdvertisement, Enumeration enumeration) {
        if (pipeAdvertisement == null || enumeration == null) {
            return;
        }
    }

    public synchronized OutputPipeListener removeOutputPipeListener(String string, OutputPipeListener outputPipeListener) {
        if (this.pipeResolver == null) {
            return null;
        }
        this.pipeResolver.removeListener(string);
        return (OutputPipeListener)this.listeners.remove(outputPipeListener);
    }

    private synchronized WirePipe createWirePipe(PipeAdvertisement pipeAdvertisement) {
        String string = pipeAdvertisement.getPipeID().toString();
        if (this.wirePipes.containsKey(string)) {
            return (WirePipe)this.wirePipes.get(string);
        }
        WirePipe wirePipe = null;
        try {
            wirePipe = new WirePipe(this.myGroup, pipeAdvertisement);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"wrong pipe advertisement");
            }
            return null;
        }
        this.wirePipes.put(string, wirePipe);
        return wirePipe;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class PipeListener
    implements PipeResolver.Listener {
        protected PipeAdvertisement pAdv = null;
        private PeerID localPeerID = null;
        private Category LOG = Category.getInstance((String)(class$net$jxta$impl$pipe$PipeServiceImpl == null ? (class$net$jxta$impl$pipe$PipeServiceImpl = PipeListener.class$("net.jxta.impl.pipe.PipeServiceImpl")) : class$net$jxta$impl$pipe$PipeServiceImpl).getName());
        static /* synthetic */ Class class$net$jxta$impl$pipe$PipeServiceImpl;

        public PipeListener(PipeAdvertisement pipeAdvertisement, PeerID peerID) {
            this.pAdv = pipeAdvertisement;
            this.localPeerID = peerID;
        }

        public void pipeResolverEvent(PipeResolver.Event event) {
            block10: {
                PipeID pipeID = null;
                try {
                    pipeID = (PipeID)IDFactory.fromURL(new URL(event.getPipeID()));
                }
                catch (Exception exception) {
                    if (this.LOG.isEnabledFor(Priority.DEBUG)) {
                        this.LOG.debug((Object)("Malformed pipe id : \n" + event.getPipeID()), (Throwable)exception);
                    }
                    exception.printStackTrace();
                }
                try {
                    String string = event.getPipeID();
                    if (PipeServiceImpl.this.listeners.containsKey(string)) {
                        OutputPipe outputPipe = null;
                        String string2 = this.pAdv.getType();
                        boolean bl = event.getPeerID().equals(this.localPeerID.toString());
                        if (string2.equals("JxtaUnicast") || bl) {
                            outputPipe = new NonBlockingOutputPipe(PipeServiceImpl.this.myGroup, PipeServiceImpl.this.pipeResolver, this.pAdv, event.getPeerID());
                        } else if (string2.equals("JxtaUnicastSecure") || bl) {
                            outputPipe = new SecureOutputPipe(PipeServiceImpl.this.myGroup, PipeServiceImpl.this.pipeResolver, this.pAdv, event.getPeerID());
                        }
                        if (outputPipe != null) {
                            OutputPipeEvent outputPipeEvent = new OutputPipeEvent(this, outputPipe, pipeID.toString(), event.getQueryID());
                            OutputPipeListener outputPipeListener = (OutputPipeListener)PipeServiceImpl.this.listeners.get(string);
                            outputPipeListener.outputPipeEvent(outputPipeEvent);
                        }
                    }
                }
                catch (IOException iOException) {
                    if (!this.LOG.isEnabledFor(Priority.DEBUG)) break block10;
                    this.LOG.debug((Object)"Error creating output pipe :", (Throwable)iOException);
                }
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

