/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.membership;

import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import net.jxta.credential.AuthenticationCredential;
import net.jxta.credential.Credential;
import net.jxta.document.Advertisement;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.exception.PeerGroupException;
import net.jxta.exception.ProtocolNotSupportedException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.membership.Authenticator;
import net.jxta.membership.MembershipService;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.service.Service;

public class NullMembershipService
extends MembershipService {
    private ModuleImplAdvertisement implAdvertisement = null;
    PeerGroup peergroup = null;
    Vector current = null;

    public void init(PeerGroup peerGroup, ID iD, Advertisement advertisement) throws PeerGroupException {
        this.implAdvertisement = (ModuleImplAdvertisement)advertisement;
        this.peergroup = peerGroup;
        this.resign();
    }

    public Service getInterface() {
        return this;
    }

    public int startApp(String[] stringArray) {
        return 0;
    }

    public void stopApp() {
    }

    public PeerGroup getPeerGroup() {
        return this.peergroup;
    }

    public Advertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    public Authenticator apply(AuthenticationCredential authenticationCredential) throws PeerGroupException, ProtocolNotSupportedException {
        String string = authenticationCredential.getMethod();
        if (null != string && !"NullAuthentication".equals(string)) {
            throw new ProtocolNotSupportedException("Authentication method not recognized");
        }
        return new NullAuthenticator(this, authenticationCredential);
    }

    public synchronized Enumeration getCurrentCredentials() throws PeerGroupException {
        return this.current.elements();
    }

    public Enumeration getAuthCredentials() throws PeerGroupException {
        Vector vector = new Vector();
        return vector.elements();
    }

    public synchronized Credential join(Authenticator authenticator) throws PeerGroupException {
        if (!(authenticator instanceof NullAuthenticator)) {
            throw new ClassCastException("This is not my authenticator!");
        }
        if (!authenticator.isReadyForJoin()) {
            throw new PeerGroupException("Not Ready to join!");
        }
        NullCredential nullCredential = new NullCredential(this, ((NullAuthenticator)authenticator).getAuth1Identity());
        this.current.addElement(nullCredential);
        return nullCredential;
    }

    public synchronized void resign() throws PeerGroupException {
        this.current = new Vector();
        this.current.addElement(new NullCredential(this, "nobody"));
    }

    public Credential makeCredential(Element element) throws PeerGroupException, Exception {
        Object object = element.getKey();
        if (!"NullCredential".equals(object)) {
            throw new PeerGroupException("Element does not contain a recognized credential format");
        }
        Enumeration enumeration = element.getChildren("PeerGroupID");
        if (!enumeration.hasMoreElements()) {
            throw new RuntimeException("Missing PeerGroupID Element");
        }
        PeerGroupID peerGroupID = (PeerGroupID)IDFactory.fromURL(new URL((String)((Element)enumeration.nextElement()).getValue()));
        if (enumeration.hasMoreElements()) {
            throw new RuntimeException("Extra PeerGroupID Elements");
        }
        enumeration = element.getChildren("PeerID");
        if (!enumeration.hasMoreElements()) {
            throw new RuntimeException("Missing PeerID Element");
        }
        PeerID peerID = (PeerID)IDFactory.fromURL(new URL((String)((Element)enumeration.nextElement()).getValue()));
        if (enumeration.hasMoreElements()) {
            throw new RuntimeException("Extra PeerID Elements");
        }
        enumeration = element.getChildren("PeerID");
        if (!enumeration.hasMoreElements()) {
            throw new RuntimeException("Missing PeerID Element");
        }
        String string = (String)((Element)enumeration.nextElement()).getValue();
        if (enumeration.hasMoreElements()) {
            throw new RuntimeException("Extra Identity Elements");
        }
        return new NullCredential(this, peerGroupID, peerID, string);
    }

    public class NullAuthenticator
    implements Authenticator {
        MembershipService source;
        AuthenticationCredential application;
        String whoami = "nobody";

        NullAuthenticator(MembershipService membershipService, AuthenticationCredential authenticationCredential) {
            this.source = membershipService;
            this.application = authenticationCredential;
        }

        public MembershipService getSourceService() {
            return this.source;
        }

        public synchronized boolean isReadyForJoin() {
            return true;
        }

        public String getMethodName() {
            return "NullAuthentication";
        }

        public AuthenticationCredential getAuthenticationCredential() {
            return this.application;
        }

        public void setAuth1Identity(String string) {
            this.whoami = string;
        }

        public String getAuth1Identity() {
            return this.whoami;
        }
    }

    class NullCredential
    implements Credential {
        NullMembershipService source;
        String whoami;
        ID peerid;

        protected NullCredential(NullMembershipService nullMembershipService2, String string) {
            this.source = nullMembershipService2;
            this.whoami = string;
            this.peerid = nullMembershipService2.getPeerGroup().getPeerID();
        }

        protected NullCredential(NullMembershipService nullMembershipService2, PeerGroupID peerGroupID, PeerID peerID, String string) throws PeerGroupException {
            this.source = nullMembershipService2;
            if (!nullMembershipService2.getPeerGroup().getPeerGroupID().equals(peerGroupID)) {
                throw new PeerGroupException("Cannot credential for a different peer group.");
            }
            this.whoami = string;
            this.peerid = peerID;
        }

        public MembershipService getSourceService() {
            return this.source;
        }

        public ID getPeerGroupID() {
            return this.source.getPeerGroup().getPeerGroupID();
        }

        public ID getPeerID() {
            return this.peerid;
        }

        public StructuredDocument getDocument(MimeMediaType mimeMediaType) throws Exception {
            StructuredDocument structuredDocument = StructuredDocumentFactory.newStructuredDocument(mimeMediaType, "NullCrendenital");
            Element element = structuredDocument.createElement("PeerGroupID", NullMembershipService.this.peergroup.getPeerGroupID().toString());
            structuredDocument.appendChild(element);
            element = structuredDocument.createElement("PeerID", this.peerid.toString());
            structuredDocument.appendChild(element);
            element = structuredDocument.createElement("Identity", this.whoami);
            structuredDocument.appendChild(element);
            return structuredDocument;
        }

        public String getIdentity() {
            return this.whoami;
        }
    }
}

