/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.index.xpath;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import net.jxta.impl.index.xpath.Expression;

public class XPath {
    public static final int NONE = 0;
    public static final int AXIS = 1;
    public static final int RELATIVE_AXIS = 2;
    public static final int PREDICATE = 3;
    public static final int PREDICATE_LITERAL = 4;
    public static final String TERMINALS = " \t\r\n,.:;";
    int state = 0;
    int tokenStart = 0;
    char[] chars;
    Token first;
    Token last;

    public XPath(String string) {
        this.chars = string.toCharArray();
        this.parse();
    }

    XPath(Token token, Token token2) {
        this.first = new Token(token.type, token.value);
        this.last = token == token2 ? this.first : new Token(token2.type, token2.value);
        Token token3 = this.first;
        Token token4 = token.next;
        token3 = this.first;
        while (token4 != token2) {
            token3.next = new Token(token4.type, token4.value);
            token4 = token4.next;
            token3 = token3.next;
        }
        token3.next = this.last;
    }

    public static void main(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            XPath xPath = new XPath(stringArray[n]);
            System.out.println("Path " + xPath);
            Expression.LogicalExpression logicalExpression = xPath.unroll();
            if (logicalExpression instanceof Expression.Clause) {
                logicalExpression = Expression.toCNF((Expression.Clause)logicalExpression);
            }
            ++n;
        }
    }

    public Token getFirstToken() {
        return this.first;
    }

    String getStart(String string) {
        int n = string.indexOf(61);
        return string.substring(0, n);
    }

    StringTokenizer tokenize(String string) {
        int n = string.indexOf(39);
        int n2 = string.lastIndexOf(39);
        string = string.substring(n + 1, n2);
        return new StringTokenizer(string, TERMINALS);
    }

    public Expression.LogicalExpression unroll() {
        Vector vector = new Vector();
        Token token = null;
        boolean bl = true;
        Token token2 = this.first;
        while (token2 != null) {
            if (token2.type == 3) {
                Expression expression = new Expression(token2.value);
                Expression.LogicalExpression logicalExpression = expression.getRootClause();
                Expression.Clause clause = new Expression.Clause("and");
                if (logicalExpression instanceof Expression.Clause) {
                    Expression.Clause clause2 = (Expression.Clause)logicalExpression;
                    Enumeration enumeration = clause2.getSubexpressions();
                    String string = token2.value;
                    while (enumeration.hasMoreElements()) {
                        Expression.LogicalExpression logicalExpression2;
                        Expression.LogicalExpression logicalExpression3 = (Expression.LogicalExpression)enumeration.nextElement();
                        if (logicalExpression3 instanceof Expression.Clause) {
                            logicalExpression2 = (Expression.Clause)logicalExpression3;
                            Enumeration enumeration2 = ((Expression.Clause)logicalExpression2).getSubexpressions();
                            Expression.Clause clause3 = new Expression.Clause("or");
                            while (enumeration2.hasMoreElements()) {
                                Expression.Literal literal = (Expression.Literal)enumeration2.nextElement();
                                clause3.addSubexpression(this.splitAndAdd(literal, token2));
                            }
                            token2.value = string;
                            token2.type = 4;
                            clause.addSubexpression(clause3);
                            continue;
                        }
                        logicalExpression2 = (Expression.Literal)logicalExpression3;
                        clause.addSubexpression(this.splitAndAdd((Expression.Literal)logicalExpression2, token2));
                    }
                    return Expression.toCNF(clause);
                }
                token2.type = 4;
                return this.splitAndAdd((Expression.Literal)logicalExpression, token2);
            }
            token = token2;
            token2 = token2.next;
        }
        return new Expression.Literal(this);
    }

    Expression.LogicalExpression splitAndAdd(Expression.Literal literal, Token token) {
        String string = (String)literal.getName();
        StringTokenizer stringTokenizer = this.tokenize(string);
        Expression.Clause clause = new Expression.Clause("and");
        String string2 = this.getStart(string);
        while (stringTokenizer.hasMoreElements()) {
            String string3 = (String)stringTokenizer.nextElement();
            token.value = string2 + "='" + string3 + '\'';
            token.type = 4;
            Expression.Clause clause2 = new Expression.Clause("or");
            clause2.addSubexpression(new XPath(this.first, this.last).unroll());
            clause.addSubexpression(clause2);
        }
        return clause;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Token token = this.first;
        while (token != null) {
            stringBuffer.append(token);
            token = token.next;
        }
        return stringBuffer.toString();
    }

    void startToken(int n, int n2) {
        this.state = n;
        this.tokenStart = n2 + 1;
    }

    void endToken(int n, int n2) {
        if (this.tokenStart != -1) {
            Token token = new Token(this.state, new String(this.chars, this.tokenStart, n2 - this.tokenStart));
            if (this.first == null) {
                this.first = this.last = token;
            } else {
                this.last.next = token;
                this.last = token;
            }
            this.state = n;
            this.tokenStart = -1;
        }
    }

    void parse() {
        int n = 0;
        while (n < this.chars.length) {
            switch (this.state) {
                case 0: {
                    if (this.chars[n] == '/') {
                        this.startToken(1, n);
                        break;
                    }
                    throw new IllegalArgumentException("XPath expression must start with a /");
                }
                case 1: {
                    if (this.chars[n] == '/') {
                        if (this.chars[n - 1] == '/') {
                            this.startToken(2, n);
                            break;
                        }
                        this.endToken(1, n);
                        this.startToken(1, n);
                        break;
                    }
                    if (this.chars[n] != '[') break;
                    this.endToken(3, n);
                    this.startToken(3, n);
                    break;
                }
                case 2: {
                    if (this.chars[n] == '/') {
                        this.endToken(1, n);
                        this.startToken(1, n);
                        break;
                    }
                    if (this.chars[n] != '[') break;
                    this.endToken(3, n);
                    this.startToken(3, n);
                    break;
                }
                case 3: {
                    if (this.chars[n] != ']') break;
                    this.endToken(0, n);
                }
            }
            ++n;
        }
        this.endToken(0, this.chars.length);
    }

    public class Token {
        int type;
        String value;
        Token next;

        Token(int n, String string) {
            this.type = n;
            this.value = string;
        }

        public int getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public Token getNext() {
            return this.next;
        }

        public String toString() {
            switch (this.type) {
                case 0: {
                    return this.value;
                }
                case 1: {
                    return "/" + this.value;
                }
                case 2: {
                    return "//" + this.value;
                }
                case 3: 
                case 4: {
                    return "[" + this.value + "]";
                }
            }
            throw new IllegalStateException();
        }
    }
}

