/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.id.UUID;

import java.net.URL;
import net.jxta.id.ID;
import net.jxta.impl.id.UUID.IDBytes;
import net.jxta.impl.id.UUID.IDFormat;
import net.jxta.impl.id.UUID.PeerGroupID;
import net.jxta.impl.id.UUID.UUID;
import net.jxta.impl.id.UUID.UUIDFactory;

public final class PipeID
extends net.jxta.pipe.PipeID {
    static final int groupIdOffset = 0;
    static final int idOffset = 16;
    static final int padOffset = 32;
    static final int padSize = 31;
    protected IDBytes id;

    PipeID() {
        this.id = new IDBytes();
        this.id.bytes[63] = 4;
    }

    PipeID(IDBytes iDBytes) {
        this.id = iDBytes;
    }

    public PipeID(UUID uUID, UUID uUID2) {
        this();
        this.id.longIntoBytes(0, uUID.getMostSignificantBits());
        this.id.longIntoBytes(8, uUID.getLeastSignificantBits());
        this.id.longIntoBytes(16, uUID2.getMostSignificantBits());
        this.id.longIntoBytes(24, uUID2.getLeastSignificantBits());
    }

    public PipeID(PeerGroupID peerGroupID) {
        this(new UUID(peerGroupID.id.bytesIntoLong(0), peerGroupID.id.bytesIntoLong(8)), UUIDFactory.newUUID());
    }

    public PipeID(PeerGroupID peerGroupID, byte[] byArray) {
        this();
        UUID uUID = new UUID(peerGroupID.id.bytesIntoLong(0), peerGroupID.id.bytesIntoLong(8));
        this.id.longIntoBytes(0, uUID.getMostSignificantBits());
        this.id.longIntoBytes(8, uUID.getLeastSignificantBits());
        int n = Math.min(16, byArray.length) - 1;
        while (n >= 0) {
            this.id.bytes[n + 16] = byArray[n];
            --n;
        }
    }

    public Object clone() {
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof String) {
            return object.equals(this.toString());
        }
        if (object instanceof PipeID) {
            return this.id.equals(((PipeID)object).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String getIDFormat() {
        return IDFormat.INSTANTIATOR.getSupportedIDFormat();
    }

    public Object getUniqueValue() {
        return this.getIDFormat() + "-" + (String)this.id.getUniqueValue();
    }

    public URL getURL() {
        return IDFormat.getURL((String)this.getUniqueValue());
    }

    public ID getPeerGroupID() {
        UUID uUID = new UUID(this.id.bytesIntoLong(0), this.id.bytesIntoLong(8));
        PeerGroupID peerGroupID = new PeerGroupID(uUID);
        return IDFormat.translateToWellKnown(peerGroupID);
    }
}

