/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tcp;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.impl.endpoint.tcp.TcpConnection;
import net.jxta.impl.endpoint.tcp.TcpTransport;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class TcpConnectionManager {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$tcp$TcpConnectionManager == null ? (class$net$jxta$impl$endpoint$tcp$TcpConnectionManager = TcpConnectionManager.class$("net.jxta.impl.endpoint.tcp.TcpConnectionManager")) : class$net$jxta$impl$endpoint$tcp$TcpConnectionManager).getName());
    private static final long TcpConnectionGCDelay = 3600000L;
    private Timer TcpConnectionGCTimer = new Timer();
    private TcpTransport proto = null;
    private Hashtable openConnections = new Hashtable();
    static /* synthetic */ Class class$net$jxta$impl$endpoint$tcp$TcpConnectionManager;

    public TcpConnectionManager(TcpTransport tcpTransport) {
        this.proto = tcpTransport;
        this.TcpConnectionGCTimer.scheduleAtFixedRate((TimerTask)new TcpConnectionGCTask(this), 3600000L, 3600000L);
    }

    private synchronized void registerTcpConnection(EndpointAddress endpointAddress, TcpConnection tcpConnection) {
        TcpConnection tcpConnection2;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Register connection to " + endpointAddress.toString()));
        }
        if ((tcpConnection2 = this.openConnections.put(endpointAddress.toString(), tcpConnection)) != null) {
            tcpConnection2.close();
        }
    }

    private synchronized void unregisterTcpConnection(EndpointAddress endpointAddress) {
        TcpConnection tcpConnection = (TcpConnection)this.openConnections.remove(endpointAddress.toString());
        if (tcpConnection != null) {
            tcpConnection.close();
        }
    }

    public synchronized TcpConnection getTcpConnection(EndpointAddress endpointAddress) {
        EndpointAddress endpointAddress2 = (EndpointAddress)endpointAddress.clone();
        endpointAddress2.setServiceName(null);
        endpointAddress2.setServiceParameter(null);
        TcpConnection tcpConnection = null;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Looking connection to " + endpointAddress2.toString()));
        }
        if ((tcpConnection = (TcpConnection)this.openConnections.get(endpointAddress2.toString())) == null) {
            try {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("Creating new connection to " + endpointAddress2.toString()));
                }
                tcpConnection = new TcpConnection(endpointAddress2, this.proto);
                this.registerTcpConnection(endpointAddress2, tcpConnection);
            }
            catch (Exception exception) {
                return null;
            }
        } else if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Reusing existing connection to " + endpointAddress2.toString()));
        }
        tcpConnection.setLastUsed(System.currentTimeMillis());
        return tcpConnection;
    }

    protected void tcpConnectionGC() {
        Enumeration enumeration;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"TcpConnectionGC starts");
        }
        if ((enumeration = this.openConnections.keys()) == null || !enumeration.hasMoreElements()) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"TcpConnectionGC: no connection. Nothing to do.");
            }
            return;
        }
        TcpConnection tcpConnection = null;
        long l = 0L;
        long l2 = 0L;
        String string = null;
        while (enumeration.hasMoreElements()) {
            try {
                string = (String)enumeration.nextElement();
                tcpConnection = (TcpConnection)this.openConnections.get(string);
                TcpConnectionManager tcpConnectionManager = this;
                synchronized (tcpConnectionManager) {
                    if (tcpConnection == null) {
                        continue;
                    }
                    l = tcpConnection.getLastUsed();
                    l2 = System.currentTimeMillis();
                    if (l2 - l >= 3600000L) {
                        tcpConnection.close();
                        this.openConnections.remove(string);
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)("TcpConnectionGC removes unused connection fon to " + string));
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"TcpConnectionGC completed.");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class TcpConnectionGCTask
    extends TimerTask {
        TcpConnectionManager manager = null;

        public TcpConnectionGCTask(TcpConnectionManager tcpConnectionManager2) {
            this.manager = tcpConnectionManager2;
        }

        public void run() {
            this.manager.tcpConnectionGC();
        }
    }
}

