/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Vector;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.Message;
import net.jxta.impl.endpoint.MessageWireFormatFactory;
import net.jxta.impl.endpoint.http.HttpTransport;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class HttpNonBlockingMessenger
implements EndpointMessenger {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$http$HttpNonBlockingMessenger == null ? (class$net$jxta$impl$endpoint$http$HttpNonBlockingMessenger = HttpNonBlockingMessenger.class$("net.jxta.impl.endpoint.http.HttpNonBlockingMessenger")) : class$net$jxta$impl$endpoint$http$HttpNonBlockingMessenger).getName());
    private EndpointAddress srcAddress = null;
    private EndpointAddress dstAddress = null;
    private HttpTransport proto = null;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$http$HttpNonBlockingMessenger;

    public HttpNonBlockingMessenger(EndpointAddress endpointAddress, HttpTransport httpTransport) throws IOException {
        if (endpointAddress == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"destination address is null");
            }
            throw new IllegalArgumentException("destination address is null");
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("   opening a messenger for " + endpointAddress.toString()));
        }
        this.proto = httpTransport;
        this.dstAddress = (EndpointAddress)endpointAddress.clone();
        this.srcAddress = this.proto.getPublicAddress();
    }

    public void sendMessage(Message message) throws IOException {
        Object object;
        int n;
        Object object2;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"sendMessage starts");
        }
        message.setDestinationAddress(this.dstAddress);
        message.setSourceAddress(this.srcAddress);
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            object2 = new ByteArrayOutputStream();
            MessageWireFormatFactory.newMessageWireFormat(new MimeMediaType("text/xml")).writeMessage((OutputStream)object2, message);
            ((ByteArrayOutputStream)object2).close();
            byte[] byArray = ((ByteArrayOutputStream)object2).toByteArray();
            byteArrayInputStream = new ByteArrayInputStream(byArray);
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"HTTP - send - cannot read outgoing message", (Throwable)exception);
            }
            throw new IOException("HTTP - send - cannot read outgoing message");
        }
        object2 = new Vector();
        int n2 = 0;
        while (-1 != (n = byteArrayInputStream.read((byte[])(object = new byte[4096])))) {
            if (0 == n) continue;
            if (n < 4096) {
                byte[] byArray = new byte[n];
                System.arraycopy(object, 0, byArray, 0, n);
                object = byArray;
            }
            n2 += ((byte[])object).length;
            ((Vector)object2).addElement(object);
        }
        try {
            Object object3 = object = (Object)this.dstAddress.getProtocolAddress();
            int n3 = 80;
            int n4 = ((String)object).lastIndexOf(58);
            if (-1 != n4) {
                object3 = ((String)object).substring(0, n4);
                n3 = Integer.parseInt(((String)object).substring(n4 + 1));
            }
            URL uRL = new URL("http", (String)object3, n3, "/snd/");
            this.proto.sendHttpPUT(uRL, ((Vector)object2).elements(), n2);
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"HttpNonBlockingMessenger: cannot send data ", (Throwable)exception);
            }
            throw new IOException("HttpNonBlockingMessenger: cannot send data ");
        }
    }

    public void close() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

