/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.document;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jxta.document.Document;
import net.jxta.document.MimeMediaType;

public class BinaryDocument
implements Document {
    private static final MimeMediaType[] myTypes = new MimeMediaType[]{new MimeMediaType("Application", "Octet-Stream")};
    private byte[] ourBytes = null;

    public static MimeMediaType[] getSupportedMimeTypes() {
        return (MimeMediaType[])myTypes.clone();
    }

    public BinaryDocument(byte[] byArray) {
        this.ourBytes = (byte[])byArray.clone();
    }

    public MimeMediaType getMimeType() {
        return myTypes[0];
    }

    public String getFileExtension() {
        return "bin";
    }

    public InputStream getStream() throws IOException {
        if (null != this.ourBytes) {
            return new ByteArrayInputStream(this.ourBytes);
        }
        return null;
    }

    public void sendToStream(OutputStream outputStream) throws IOException {
        if (null != this.ourBytes) {
            outputStream.write(this.ourBytes);
        }
    }
}

