/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletConfig;
import org.apache.turbine.om.OMTool;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.intake.IntakeService;
import org.apache.turbine.services.intake.model.Group;
import org.apache.turbine.services.intake.transform.XmlToAppData;
import org.apache.turbine.services.intake.xmlmodel.AppData;
import org.apache.turbine.services.intake.xmlmodel.XmlGroup;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.ServletUtils;
import org.apache.turbine.util.TurbineException;
import org.apache.turbine.util.pool.BoundedBuffer;
import org.apache.turbine.util.pool.Recyclable;

public class TurbineIntakeService
extends TurbineBaseService
implements IntakeService {
    private static final int GETTER = 0;
    private static final int SETTER = 1;
    private String[] groupNames;
    private Map groupNameMap;
    private Map groupKeyMap;
    private Map getterMap;
    private Map setterMap;
    private OMTool omTool;
    private AppData appData;
    private HashMap poolRepository = new HashMap();

    public void init(ServletConfig config) throws InitializationException {
        Properties props = this.getProperties();
        String xmlPath = props.getProperty("xml.path");
        String appDataPath = "WEB-INF/appData.ser";
        try {
            xmlPath = ServletUtils.expandRelative(config, xmlPath);
            appDataPath = ServletUtils.expandRelative(config, appDataPath);
            File serialAppData = new File(appDataPath);
            File xmlFile = new File(xmlPath);
            if (serialAppData.exists() && serialAppData.lastModified() > xmlFile.lastModified()) {
                FileInputStream in = new FileInputStream(serialAppData);
                ObjectInputStream p = new ObjectInputStream(in);
                this.appData = (AppData)p.readObject();
                ((InputStream)in).close();
            } else {
                XmlToAppData xmlApp = new XmlToAppData();
                this.appData = xmlApp.parseFile(xmlPath);
                FileOutputStream out = new FileOutputStream(serialAppData);
                ObjectOutputStream p = new ObjectOutputStream(out);
                p.writeObject(this.appData);
                p.flush();
                ((OutputStream)out).close();
            }
            this.groupNames = new String[this.appData.getGroups().size()];
            this.groupKeyMap = new HashMap();
            this.groupNameMap = new HashMap();
            this.getterMap = new HashMap();
            this.setterMap = new HashMap();
            String pkg = this.appData.getBasePackage();
            List glist = this.appData.getGroups();
            int i = glist.size() - 1;
            while (i >= 0) {
                String groupName;
                XmlGroup g = (XmlGroup)glist.get(i);
                this.groupNames[i] = groupName = g.getName();
                this.groupKeyMap.put(groupName, g.getKey());
                this.groupNameMap.put(g.getKey(), groupName);
                List classNames = g.getMapToObjects();
                Iterator iter2 = classNames.iterator();
                while (iter2.hasNext()) {
                    String className = (String)iter2.next();
                    if (this.getterMap.containsKey(className)) continue;
                    this.getterMap.put(className, new HashMap());
                    this.setterMap.put(className, new HashMap());
                }
                --i;
            }
            this.setInit(true);
        }
        catch (Exception e) {
            throw new InitializationException("TurbineIntakeService failed to initialize", e);
        }
    }

    private Method initializeBeanProp(String className, String propName, int getOrSet) throws Exception {
        Method method = null;
        if (className != null && propName != null) {
            PropertyDescriptor[] beanProps = Introspector.getBeanInfo(Class.forName(className)).getPropertyDescriptors();
            boolean noMatch = true;
            int j = beanProps.length - 1;
            while (j >= 0) {
                if (propName.equalsIgnoreCase(beanProps[j].getName())) {
                    switch (getOrSet) {
                        case 0: {
                            method = beanProps[j].getReadMethod();
                            ((HashMap)this.getterMap.get(className)).put(propName, method);
                            break;
                        }
                        case 1: {
                            method = beanProps[j].getWriteMethod();
                            ((HashMap)this.setterMap.get(className)).put(propName, method);
                        }
                    }
                    noMatch = false;
                    break;
                }
                --j;
            }
            if (noMatch) {
                Log.error("Property, " + propName + " for class, " + className + " could not be found.");
            }
        }
        return method;
    }

    public Group getGroup(String groupName) throws TurbineException {
        Group instance = (Group)this.pollInstance(groupName);
        if (instance == null) {
            try {
                instance = new Group(this.appData.getGroup(groupName));
            }
            catch (Exception e) {
                throw new TurbineException(e);
            }
        }
        return instance;
    }

    public boolean releaseGroup(Group instance) {
        if (instance != null) {
            HashMap repository = this.poolRepository;
            String name = instance.getIntakeGroupName();
            PoolBuffer pool = (PoolBuffer)repository.get(name);
            if (pool == null) {
                pool = new PoolBuffer(instance.getPoolCapacity());
                repository = (HashMap)repository.clone();
                repository.put(name, pool);
                this.poolRepository = repository;
            }
            return pool.offer(instance);
        }
        return false;
    }

    public int getCapacity(String name) {
        int capacity = 1024;
        PoolBuffer pool = (PoolBuffer)this.poolRepository.get(name);
        if (pool == null) {
            try {
                capacity = Integer.parseInt(this.appData.getGroup(name).getPoolCapacity());
            }
            catch (NumberFormatException nfe) {}
        } else {
            capacity = pool.capacity();
        }
        return capacity;
    }

    public void setCapacity(String name, int capacity) {
        HashMap<String, PoolBuffer> repository = this.poolRepository;
        repository = repository != null ? (HashMap)repository.clone() : new HashMap<String, PoolBuffer>();
        repository.put(name, new PoolBuffer(capacity));
        this.poolRepository = repository;
    }

    public int getSize(String name) {
        PoolBuffer pool = (PoolBuffer)this.poolRepository.get(name);
        return pool != null ? pool.size() : 0;
    }

    public void clearPool(String name) {
        throw new Error("Not implemented");
    }

    public void clearPool() {
        throw new Error("Not implemented");
    }

    private Object pollInstance(String groupName) throws TurbineException {
        PoolBuffer pool = (PoolBuffer)this.poolRepository.get(groupName);
        return pool != null ? pool.poll() : null;
    }

    public String[] getGroupNames() {
        return this.groupNames;
    }

    public String getGroupKey(String groupName) {
        return (String)this.groupKeyMap.get(groupName);
    }

    public String getGroupName(String groupKey) {
        return (String)this.groupNameMap.get(groupKey);
    }

    public Method getFieldSetter(String className, String propName) {
        Map settersForClassName = (Map)this.setterMap.get(className);
        Method method = (Method)settersForClassName.get(propName);
        if (method == null) {
            Map map = this.setterMap;
            synchronized (map) {
                try {
                    method = this.initializeBeanProp(className, propName, 1);
                }
                catch (Exception e) {
                    Log.error(e);
                }
            }
        }
        return method;
    }

    public Method getFieldGetter(String className, String propName) {
        Map gettersForClassName = (Map)this.getterMap.get(className);
        Method method = (Method)gettersForClassName.get(propName);
        if (method == null) {
            Map map = this.getterMap;
            synchronized (map) {
                try {
                    method = this.initializeBeanProp(className, propName, 0);
                }
                catch (Exception e) {
                    Log.error(e);
                }
            }
        }
        return method;
    }

    private class PoolBuffer {
        private BoundedBuffer pool;
        private HashMap recyclers;

        public Group poll() throws TurbineException {
            Group instance = (Group)this.pool.poll();
            if (instance != null && instance instanceof Recyclable) {
                try {
                    instance.recycle();
                }
                catch (Exception x) {
                    throw new TurbineException("Recycling failed for " + instance.getClass().getName(), x);
                }
            }
            return instance;
        }

        public boolean offer(Group instance) {
            try {
                instance.dispose();
            }
            catch (Exception x) {
                return false;
            }
            return this.pool.offer(instance);
        }

        public int capacity() {
            return this.pool.capacity();
        }

        public int size() {
            return this.pool.size();
        }

        public PoolBuffer(int capacity) {
            this.pool = new BoundedBuffer(capacity);
        }
    }
}

