/*
 * Decompiled with CFR 0.152.
 */
package tyrex.naming;

import java.security.AccessController;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.NotContextException;
import javax.naming.spi.InitialContextFactory;
import tyrex.naming.MemoryBinding;
import tyrex.naming.MemoryContext;
import tyrex.naming.NamingPermission;

public final class MemoryContextFactory
implements InitialContextFactory {
    private static final MemoryBinding _root = new MemoryBinding();

    static synchronized MemoryBinding getBindings(String string) throws NamingException {
        try {
            AccessController.checkPermission(NamingPermission.Shared);
        }
        catch (SecurityException securityException) {
            throw new NoPermissionException("Caller has no permission to reset environment naming context");
        }
        CompositeName compositeName = new CompositeName(string);
        MemoryBinding memoryBinding = _root;
        int n = 0;
        while (n < compositeName.size()) {
            if (compositeName.get(n).length() > 0) {
                try {
                    MemoryBinding memoryBinding2 = (MemoryBinding)memoryBinding.get(compositeName.get(n));
                    if (memoryBinding2 == null) {
                        memoryBinding2 = new MemoryBinding();
                        memoryBinding.put(compositeName.get(n), memoryBinding2);
                    }
                    memoryBinding = memoryBinding2;
                }
                catch (ClassCastException classCastException) {
                    throw new NotContextException(String.valueOf(string) + " does not specify a context");
                }
            }
            ++n;
        }
        return memoryBinding;
    }

    public Context getInitialContext(Hashtable hashtable) throws NamingException {
        if (hashtable.get("java.naming.provider.url") == null) {
            return new MemoryContext(hashtable);
        }
        String string = hashtable.get("java.naming.provider.url").toString();
        return new MemoryContext(MemoryContextFactory.getBindings(string), hashtable);
    }
}

