/*
 * Decompiled with CFR 0.152.
 */
package tyrex.jdbc;

import java.lang.ref.WeakReference;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;
import tyrex.jdbc.TyrexCallableStatementImpl;
import tyrex.jdbc.TyrexConnection;
import tyrex.jdbc.TyrexConnectionListener;
import tyrex.jdbc.TyrexPreparedStatementImpl;
import tyrex.jdbc.TyrexStatementImpl;

public abstract class AbstractTyrexConnectionImpl
implements TyrexConnection {
    public static final int DEFAULT_RESIZE_AMOUNT = 1;
    private final int _resizeAmount;
    private transient WeakReference[] _listeners;
    private transient int _freeIndex;

    public AbstractTyrexConnectionImpl() {
        this(1);
    }

    public AbstractTyrexConnectionImpl(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The argument 'resizeAmount' must be positive.");
        }
        this._resizeAmount = n;
    }

    public synchronized void addListener(TyrexConnectionListener tyrexConnectionListener) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(String.valueOf(this.toString()) + " is closed.");
        }
        if (tyrexConnectionListener != null) {
            if (this._listeners == null) {
                this._listeners = new WeakReference[]{new WeakReference<TyrexConnectionListener>(tyrexConnectionListener)};
                this._freeIndex = 1;
            } else {
                int n = this._freeIndex;
                while (--n >= 0) {
                    Object var4_3;
                    Object v0 = var4_3 = this._listeners[n] == null ? null : this._listeners[n].get();
                    if (var4_3 == null) {
                        this._listeners[n] = null;
                        continue;
                    }
                    if (var4_3 != tyrexConnectionListener) continue;
                    return;
                }
                int n2 = this._listeners.length;
                if (this._freeIndex == n2) {
                    int n3 = -1;
                    int n4 = 0;
                    n = 0;
                    while (n < n2) {
                        if (this._listeners[n] == null) {
                            if (n3 == -1) {
                                n3 = n;
                            }
                            ++n4;
                        } else if (n4 != 0) {
                            this._listeners[n3] = this._listeners[n];
                            n3 = --n4 == 0 ? -1 : ++n3;
                            --this._freeIndex;
                        }
                        ++n;
                    }
                    this._freeIndex -= n4;
                }
                if (this._freeIndex < n2) {
                    this._listeners[this._freeIndex++] = new WeakReference<TyrexConnectionListener>(tyrexConnectionListener);
                } else {
                    WeakReference[] weakReferenceArray = new WeakReference[n2 + this._resizeAmount];
                    System.arraycopy(this._listeners, 0, weakReferenceArray, 0, n2);
                    weakReferenceArray[n2] = new WeakReference<TyrexConnectionListener>(tyrexConnectionListener);
                    this._freeIndex = n2 + 1;
                    this._listeners = weakReferenceArray;
                    weakReferenceArray = null;
                }
            }
        }
    }

    public synchronized void clearWarnings() throws SQLException {
        try {
            this.getUnderlyingConnection().clearWarnings();
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized void close() throws SQLException {
        try {
            this.internalClose();
            this.notifyConnectionClosed();
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized void commit() throws SQLException {
        try {
            this.getUnderlyingConnection().commit();
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized Statement createStatement() throws SQLException {
        try {
            return new TyrexStatementImpl(this.getUnderlyingConnection().createStatement(), this);
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized Statement createStatement(int n, int n2) throws SQLException {
        try {
            return new TyrexStatementImpl(this.getUnderlyingConnection().createStatement(n, n2), this);
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    protected void finalize() throws Throwable {
        if (!this.isClosed()) {
            this.close();
        }
    }

    public synchronized boolean getAutoCommit() throws SQLException {
        try {
            return this.getUnderlyingConnection().getAutoCommit();
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized String getCatalog() throws SQLException {
        try {
            return this.getUnderlyingConnection().getCatalog();
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        try {
            return this.getUnderlyingConnection().getMetaData();
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized int getTransactionIsolation() throws SQLException {
        try {
            return this.getUnderlyingConnection().getTransactionIsolation();
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized Map getTypeMap() throws SQLException {
        try {
            return this.getUnderlyingConnection().getTypeMap();
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    private Connection getUnderlyingConnection() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("The connection is closed.");
        }
        return this.internalGetUnderlyingConnection();
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        try {
            return this.getUnderlyingConnection().getWarnings();
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    protected abstract void internalClose() throws SQLException;

    protected abstract Connection internalGetUnderlyingConnection() throws SQLException;

    public abstract boolean isClosed();

    public synchronized boolean isReadOnly() throws SQLException {
        try {
            return this.getUnderlyingConnection().isReadOnly();
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized String nativeSQL(String string) throws SQLException {
        try {
            return this.getUnderlyingConnection().nativeSQL(string);
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    private final void notifyConnectionClosed() {
        int n = this._freeIndex;
        while (--n >= 0) {
            Object var1_2;
            Object v0 = var1_2 = this._listeners[n] == null ? null : this._listeners[n].get();
            if (var1_2 != null) {
                try {
                    ((TyrexConnectionListener)var1_2).connectionClosed();
                }
                catch (Exception exception) {}
                continue;
            }
            this._listeners[n] = null;
        }
        this._freeIndex = 0;
        this._listeners = null;
    }

    protected void notifyError(SQLException sQLException) {
    }

    public synchronized CallableStatement prepareCall(String string) throws SQLException {
        try {
            return new TyrexCallableStatementImpl(this.getUnderlyingConnection().prepareCall(string), (TyrexConnection)this);
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        try {
            return new TyrexCallableStatementImpl(this.getUnderlyingConnection().prepareCall(string, n, n2), (TyrexConnection)this);
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized PreparedStatement prepareStatement(String string) throws SQLException {
        try {
            return new TyrexPreparedStatementImpl(this.getUnderlyingConnection().prepareStatement(string), (TyrexConnection)this);
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        try {
            return new TyrexPreparedStatementImpl(this.getUnderlyingConnection().prepareStatement(string, n, n2), (TyrexConnection)this);
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized void removeListener(TyrexConnectionListener tyrexConnectionListener) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(String.valueOf(this.toString()) + " is closed.");
        }
        if (tyrexConnectionListener != null && this._listeners != null && this._freeIndex > 0) {
            if (this._freeIndex == 1) {
                Object var2_2;
                Object v0 = var2_2 = this._listeners[0] == null ? null : this._listeners[0].get();
                if (var2_2 == null || var2_2 == tyrexConnectionListener) {
                    this._listeners[0] = null;
                    --this._freeIndex;
                }
                return;
            }
            int n = this._freeIndex;
            while (--n >= 0) {
                Object var2_3;
                Object v1 = var2_3 = this._listeners[n] == null ? null : this._listeners[0].get();
                if (var2_3 == null) {
                    this._listeners[n] = null;
                    continue;
                }
                if (tyrexConnectionListener != var2_3) continue;
                --this._freeIndex;
                if (n == this._freeIndex) {
                    this._listeners[n] = null;
                } else {
                    int n2 = this._freeIndex;
                    while (n2 > n) {
                        this._listeners[n2 - 1] = this._listeners[n2];
                        this._listeners[n2] = null;
                        --n2;
                    }
                }
                return;
            }
        }
    }

    public synchronized void rollback() throws SQLException {
        try {
            this.getUnderlyingConnection().rollback();
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        try {
            this.getUnderlyingConnection().setAutoCommit(bl);
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized void setCatalog(String string) throws SQLException {
        try {
            this.getUnderlyingConnection().setCatalog(string);
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized void setReadOnly(boolean bl) throws SQLException {
        try {
            this.getUnderlyingConnection().setReadOnly(bl);
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized void setTransactionIsolation(int n) throws SQLException {
        try {
            this.getUnderlyingConnection().setTransactionIsolation(n);
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized void setTypeMap(Map map) throws SQLException {
        try {
            this.getUnderlyingConnection().setTypeMap(map);
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }
}

