/*
 * Decompiled with CFR 0.152.
 */
package tyrex.connector.manager;

import java.io.PrintWriter;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.security.auth.Subject;
import tyrex.connector.ConnectionEvent;
import tyrex.connector.ConnectionEventListener;
import tyrex.connector.ConnectionEventListenerAdapter;
import tyrex.connector.ConnectionException;
import tyrex.connector.ConnectionManager;
import tyrex.connector.ManagedConnection;
import tyrex.connector.ManagedConnectionFactory;
import tyrex.connector.conf.ConnectionManagerConfiguration;
import tyrex.connector.transaction.ConnectionTransactionManager;
import tyrex.resource.ResourcePool;
import tyrex.resource.ResourcePoolManager;
import tyrex.resource.ResourceTimeoutException;
import tyrex.util.HashIntTable;
import tyrex.util.Messages;

class ConnectionManagerImpl
implements ConnectionManager {
    private final Map pools = new HashMap();
    private PrintWriter logWriter;
    private ManagedConnectionReleaseThread managedConnectionReleaseThread = null;
    private final Object managedConnectionReleaseThreadLock = new Object();
    private ConnectionTransactionManager connectionTransactionManager;
    private ConnectionManagerConfiguration configuration;

    public ConnectionManagerImpl() {
        this(null, null, null);
    }

    public ConnectionManagerImpl(PrintWriter printWriter) {
        this(null, printWriter);
    }

    public ConnectionManagerImpl(ConnectionManagerConfiguration connectionManagerConfiguration) {
        this(connectionManagerConfiguration, null, null);
    }

    public ConnectionManagerImpl(ConnectionManagerConfiguration connectionManagerConfiguration, PrintWriter printWriter) {
        this(connectionManagerConfiguration, null, printWriter);
    }

    public ConnectionManagerImpl(ConnectionManagerConfiguration connectionManagerConfiguration, ConnectionTransactionManager connectionTransactionManager) {
        this(connectionManagerConfiguration, connectionTransactionManager, null);
    }

    public ConnectionManagerImpl(ConnectionManagerConfiguration connectionManagerConfiguration, ConnectionTransactionManager connectionTransactionManager, PrintWriter printWriter) {
        this.configuration = connectionManagerConfiguration == null ? new ConnectionManagerConfiguration() : connectionManagerConfiguration;
        this.logWriter = printWriter;
        this.connectionTransactionManager = connectionTransactionManager;
    }

    public ConnectionManagerImpl(ConnectionTransactionManager connectionTransactionManager) {
        this(null, connectionTransactionManager);
    }

    static /* synthetic */ Object access$2(ConnectionManagerImpl connectionManagerImpl) {
        return connectionManagerImpl.managedConnectionReleaseThreadLock;
    }

    static /* synthetic */ PrintWriter access$3(ConnectionManagerImpl connectionManagerImpl) {
        return connectionManagerImpl.logWriter;
    }

    private PoolEntry createPoolEntry(ManagedConnectionFactory managedConnectionFactory) {
        class Tyrex_connector_manager_ConnectionManagerImpl$1 {
            /* synthetic */ Tyrex_connector_manager_ConnectionManagerImpl$1() {
            }
        }
        PoolEntry poolEntry = null;
        boolean bl = false;
        Object object = this.pools;
        synchronized (object) {
            ResourcePoolImpl resourcePoolImpl = new ResourcePoolImpl(null, this.logWriter);
            ResourcePoolManager resourcePoolManager = this.configuration.createResourcePoolManager(managedConnectionFactory);
            bl = this.configuration.getConnectionManagerPruneResponsibilty(managedConnectionFactory);
            resourcePoolManager.unmanage();
            resourcePoolManager.setResourceLimits(this.configuration.createResourceLimits());
            resourcePoolManager.manage(resourcePoolImpl, bl ^ true);
            poolEntry = new PoolEntry(null, managedConnectionFactory, resourcePoolImpl, resourcePoolManager, new ManagedConnectionListener(null, managedConnectionFactory));
            this.pools.put(managedConnectionFactory, poolEntry);
        }
        if (bl) {
            object = this.managedConnectionReleaseThreadLock;
            synchronized (object) {
                if (this.managedConnectionReleaseThread == null) {
                    this.managedConnectionReleaseThread = new ManagedConnectionReleaseThread();
                }
                this.managedConnectionReleaseThread.include(poolEntry);
            }
        }
        return poolEntry;
    }

    private void discard(ManagedConnection managedConnection, ManagedConnectionFactory managedConnectionFactory) {
        try {
            block8: {
                try {
                    this.connectionTransactionManager.discard(managedConnection, managedConnectionFactory);
                }
                catch (Exception exception) {
                    if (this.logWriter == null) break block8;
                    this.logWriter.print("Failed to discard managed connection <");
                    this.logWriter.print(managedConnection);
                    this.logWriter.print(">: ");
                    this.logWriter.println(exception.toString());
                    exception.printStackTrace(this.logWriter);
                }
            }
            Object var4_6 = null;
        }
        catch (Throwable throwable) {
            block10: {
                Object var4_7 = null;
                try {
                    managedConnection.close();
                }
                catch (Exception exception) {
                    if (this.logWriter == null) break block10;
                    this.logWriter.println("Failed to close managed connection <" + managedConnection + ">: ");
                    exception.printStackTrace(this.logWriter);
                }
            }
            throw throwable;
        }
        try {
            managedConnection.close();
        }
        catch (Exception exception) {
            if (this.logWriter != null) {
                this.logWriter.println("Failed to close managed connection <" + managedConnection + ">: ");
                exception.printStackTrace(this.logWriter);
            }
        }
    }

    public Object getConnection(ManagedConnectionFactory managedConnectionFactory, Object object) throws ConnectionException {
        if (managedConnectionFactory == null) {
            throw new ConnectionException("The argument 'managedConnectionFactory' is null.");
        }
        Subject subject = ConnectionManagerImpl.getSubject();
        ManagedConnection managedConnection = null;
        PoolEntry poolEntry = null;
        Object object2 = this.pools;
        synchronized (object2) {
            poolEntry = this.getPoolEntry(managedConnectionFactory);
            if (poolEntry == null) {
                poolEntry = this.createPoolEntry(managedConnectionFactory);
            }
        }
        Object object3 = object2 = poolEntry.resourcePool;
        synchronized (object3) {
            Enumeration enumeration;
            if (this.configuration.canShareConnections(managedConnectionFactory) && ((ResourcePoolImpl)object2).getActiveCount() > 0 && (enumeration = this.getShareableConnections(((ResourcePoolImpl)object2).getActiveConnections(), ((ResourcePoolImpl)object2).getActiveCount())) != null) {
                managedConnection = managedConnectionFactory.getManagedConnection(subject, enumeration, object);
            }
            if (managedConnection == null) {
                try {
                    poolEntry.resourcePoolManager.canActivate();
                    if (((ResourcePoolImpl)object2).getPooledCount() != 0) {
                        managedConnection = managedConnectionFactory.getManagedConnection(subject, ((ResourcePoolImpl)object2).getPooledConnections(), object);
                    }
                    if (managedConnection == null) {
                        poolEntry.resourcePoolManager.canCreateNew();
                        managedConnection = managedConnectionFactory.createManagedConnection(subject, object);
                        if (managedConnection == null) {
                            throw new ConnectionException("Unable to create a managed connection from the factory <" + managedConnectionFactory + ">.");
                        }
                    } else {
                        ((ResourcePoolImpl)object2).unpool(managedConnection);
                    }
                    managedConnection.addConnectionEventListener(poolEntry.listener);
                }
                catch (ResourceTimeoutException resourceTimeoutException) {
                    throw new ConnectionException(Messages.format("tyrex.resource.limitExceeded", managedConnectionFactory.toString()));
                }
            }
            try {
                ((ResourcePoolImpl)object2).use(managedConnection);
                Object object4 = this.connectionTransactionManager.enlist(managedConnection.getConnection(object), managedConnection, managedConnectionFactory);
                Object var9_11 = null;
                return object4;
            }
            catch (Exception exception) {
                this.discard(managedConnection, managedConnectionFactory);
                if (exception instanceof ConnectionException) {
                    throw (ConnectionException)exception;
                }
                throw new ConnectionException(exception);
            }
        }
    }

    private static String getCurrentThreadPrettyName() {
        return "Thread[" + Thread.currentThread().getName() + "]";
    }

    private PoolEntry getPoolEntry(ManagedConnectionFactory managedConnectionFactory) {
        Map map = this.pools;
        synchronized (map) {
            PoolEntry poolEntry = (PoolEntry)this.pools.get(managedConnectionFactory);
            Object var4_4 = null;
            return poolEntry;
        }
    }

    private Enumeration getShareableConnections(Enumeration enumeration, int n) {
        return null;
    }

    private static Subject getSubject() {
        return Subject.getSubject(AccessController.getContext());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void unuse(ManagedConnection managedConnection, ManagedConnectionFactory managedConnectionFactory) {
        PoolEntry poolEntry = this.getPoolEntry(managedConnectionFactory);
        if (poolEntry != null) {
            try {
                if (!poolEntry.resourcePool.unuse(managedConnection)) return;
                this.connectionTransactionManager.delist(managedConnection, managedConnectionFactory);
                managedConnection.removeConnectionEventListener(poolEntry.listener);
                poolEntry.resourcePoolManager.released();
                return;
            }
            catch (Exception exception) {
                block5: {
                    try {
                        if (this.logWriter == null) break block5;
                        this.logWriter.println("Internal error: Could not return managed connection <" + managedConnection.toString() + "> to the resource pool.");
                        exception.printStackTrace(this.logWriter);
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        this.discard(managedConnection, managedConnectionFactory);
                        throw throwable;
                    }
                }
                Object var6_5 = null;
                this.discard(managedConnection, managedConnectionFactory);
                return;
            }
        }
        if (this.logWriter == null) return;
        this.logWriter.println("Internal error: Cannot find the managed entry for the specified managed connection <" + managedConnection + "> while trying to return the managed connection to the pool " + "(ManagedConnectionPoolImpl#unuse).");
    }

    private class ManagedConnectionListener
    extends ConnectionEventListenerAdapter
    implements ConnectionEventListener {
        private final ManagedConnectionFactory managedConnectionFactory;

        private ManagedConnectionListener(ManagedConnectionFactory managedConnectionFactory) {
            this.managedConnectionFactory = managedConnectionFactory;
        }

        /* synthetic */ ManagedConnectionListener(1 var2_2, ManagedConnectionFactory managedConnectionFactory) {
            this(managedConnectionFactory);
        }

        public void connectionClosed(ConnectionEvent connectionEvent) {
            ConnectionManagerImpl.this.unuse(connectionEvent.getManagedConnection(), this.managedConnectionFactory);
        }

        public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
            ConnectionManagerImpl.this.discard(connectionEvent.getManagedConnection(), this.managedConnectionFactory);
        }
    }

    private static class ResourcePoolImpl
    implements ResourcePool {
        private final Vector pool = new Vector();
        private final HashIntTable active = new HashIntTable();
        private final PrintWriter logWriter;

        private ResourcePoolImpl(PrintWriter printWriter) {
            this.logWriter = printWriter;
        }

        /* synthetic */ ResourcePoolImpl(1 var1_1, PrintWriter printWriter) {
            this(printWriter);
        }

        private synchronized void discard(ManagedConnection managedConnection) {
            this.active.remove(managedConnection);
            this.pool.remove(managedConnection);
        }

        private Enumeration getActiveConnections() {
            return this.active.keys();
        }

        public int getActiveCount() {
            return this.active.size();
        }

        private Enumeration getPooledConnections() {
            return this.pool.elements();
        }

        public int getPooledCount() {
            return this.pool.size();
        }

        private synchronized void pool(ManagedConnection managedConnection) {
            this.pool.add(managedConnection);
        }

        public synchronized void releasePooled(int n) {
            int n2 = 0;
            while (n2 < n && n2 < this.pool.size()) {
                block3: {
                    ManagedConnection managedConnection = (ManagedConnection)this.pool.get(0);
                    this.pool.remove(0);
                    try {
                        managedConnection.close();
                    }
                    catch (ConnectionException connectionException) {
                        if (this.logWriter == null) break block3;
                        this.logWriter.println(Messages.format("tyrex.resource.fault", this.toString(), managedConnection, connectionException));
                    }
                }
                ++n2;
            }
        }

        private synchronized void unpool(ManagedConnection managedConnection) {
            this.pool.remove(managedConnection);
        }

        private synchronized boolean unuse(ManagedConnection managedConnection) {
            return this.active.increment(managedConnection, -1) == 0;
        }

        private synchronized void use(ManagedConnection managedConnection) {
            this.active.increment(managedConnection, 1);
        }
    }

    private static class PoolEntry {
        private final ManagedConnectionFactory managedConnectionFactory;
        private final ResourcePoolImpl resourcePool;
        private final ResourcePoolManager resourcePoolManager;
        private final ManagedConnectionListener listener;

        private PoolEntry(ManagedConnectionFactory managedConnectionFactory, ResourcePoolImpl resourcePoolImpl, ResourcePoolManager resourcePoolManager, ManagedConnectionListener managedConnectionListener) {
            this.managedConnectionFactory = managedConnectionFactory;
            this.resourcePool = resourcePoolImpl;
            this.resourcePoolManager = resourcePoolManager;
            this.listener = managedConnectionListener;
        }

        /* synthetic */ PoolEntry(1 var1_1, ManagedConnectionFactory managedConnectionFactory, ResourcePoolImpl resourcePoolImpl, ResourcePoolManager resourcePoolManager, ManagedConnectionListener managedConnectionListener) {
            this(managedConnectionFactory, resourcePoolImpl, resourcePoolManager, managedConnectionListener);
        }
    }

    private class ManagedConnectionReleaseThread
    extends Thread {
        private PoolEntry[] poolEntries = null;
        private long[] lastTimes = null;
        private long checkEvery = Long.MAX_VALUE;

        private ManagedConnectionReleaseThread() {
            super("ConnectionManagerImpl Daemon");
            this.setDaemon(true);
            this.setPriority(1);
            this.start();
        }

        private void include(PoolEntry poolEntry) {
            PoolEntry[] poolEntryArray = new PoolEntry[this.poolEntries == null ? 1 : this.poolEntries.length + 1];
            long[] lArray = new long[poolEntryArray.length];
            int n = poolEntryArray.length - 1;
            while (--n >= 0) {
                poolEntryArray[n] = this.poolEntries[n];
                lArray[n] = this.lastTimes[n];
            }
            poolEntryArray[poolEntryArray.length - 1] = poolEntry;
            lArray[lArray.length - 1] = System.currentTimeMillis();
            this.poolEntries = poolEntryArray;
            this.lastTimes = lArray;
            poolEntryArray = null;
            lArray = null;
            this.checkEvery = Math.min((long)poolEntry.resourcePoolManager.getResourceLimits().getCheckEvery(), this.checkEvery);
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            var1_1 = ConnectionManagerImpl.access$2(ConnectionManagerImpl.this);
            synchronized (var1_1) {
                var3_2 = null;
                var4_3 = null;
                var5_4 = 0L;
                var7_5 = 0;
                try {
                    block7: while (true) {
                        ConnectionManagerImpl.access$2(ConnectionManagerImpl.this).wait(this.checkEvery);
                        if (this.poolEntries == null) continue;
                        var8_6 = 0;
                        while (true) {
                            block12: {
                                if (var8_6 < this.poolEntries.length) ** break;
                                continue block7;
                                try {
                                    var3_2 = this.poolEntries[var8_6];
                                    var4_3 = PoolEntry.access$1(var3_2).getResourceLimits();
                                    var5_4 = System.currentTimeMillis();
                                    if (var5_4 - this.lastTimes[var8_6] > (long)var4_3.getCheckEvery()) {
                                        var7_5 = PoolEntry.access$0(var3_2).getPooledCount() - var4_3.getDesiredSize();
                                        if (var7_5 > 0) {
                                            PoolEntry.access$0(var3_2).releasePooled((int)((float)var7_5 * var4_3.getPruneFactor()) + 1);
                                        }
                                        this.lastTimes[var8_6] = System.currentTimeMillis();
                                    }
                                }
                                catch (Exception var9_7) {
                                    if (ConnectionManagerImpl.access$3(ConnectionManagerImpl.this) == null) break block12;
                                    ConnectionManagerImpl.access$3(ConnectionManagerImpl.this).println("Error occurred in pruning resources:");
                                    var9_7.printStackTrace(ConnectionManagerImpl.access$3(ConnectionManagerImpl.this));
                                }
                            }
                            ++var8_6;
                        }
                        break;
                    }
                }
                catch (InterruptedException v0) {
                    if (ConnectionManagerImpl.access$3(ConnectionManagerImpl.this) != null) {
                        ConnectionManagerImpl.access$3(ConnectionManagerImpl.this).println("Pruning thread for <" + ConnectionManagerImpl.this.toString() + "> interrupted.");
                    }
                }
            }
        }
    }
}

