/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls.jxta;

import COM.claymoresystems.ptls.SSLDebug;
import COM.claymoresystems.ptls.SSLSocket;
import COM.claymoresystems.ptls.jxta.JXTATLSDefs;
import COM.claymoresystems.ptls.jxta.JXTATLSutil;
import COM.claymoresystems.ptls.jxta.Message;
import COM.claymoresystems.ptls.jxta.MessageElement;
import COM.claymoresystems.ptls.jxta.MessageImpl;
import COM.claymoresystems.ptls.jxta.MessageWireFormat;
import COM.claymoresystems.ptls.jxta.MessageWireFormatBinary;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class JXTAOutputStream
extends OutputStream {
    private Message jmsg = null;
    private MessageElement sentMelt = null;
    private MessageWireFormat MsgWireOut = null;
    private int sequenceNumber = 0;
    private int appOutputSize = 0;
    private int nElements = 0;
    private OutputStream netOut = null;
    private InputStream netIn = null;
    private Socket netSock;
    private String destHost;
    private int destPort;
    private BufferedOutputStream plaintext_out = null;
    private int queuedBytes = 0;
    private int MAXELEMENTS = 3;

    public JXTAOutputStream() {
        this.setupJxtaMsgs();
    }

    private void setupJxtaMsgs() {
        this.jmsg = new MessageImpl();
        this.MsgWireOut = new MessageWireFormatBinary(JXTATLSDefs.MTYPE);
        this.sequenceNumber = 1;
        this.sentMelt = null;
        this.appOutputSize = 0;
        this.nElements = 0;
    }

    public JXTAOutputStream(String string, int n) {
        this.destHost = string;
        this.destPort = n;
        this.setupJxtaMsgs();
    }

    public void connect() throws IOException {
        this.netSock = new Socket(this.destHost, this.destPort);
        this.netIn = this.netSock.getInputStream();
        this.netOut = this.netSock.getOutputStream();
    }

    public InputStream getNetInputStream() {
        return this.netIn;
    }

    public void setNetOutputStream(OutputStream outputStream) {
        this.netOut = outputStream;
    }

    public void closeNetSocket() throws IOException {
        this.netSock.close();
    }

    public void setPlaintextOutputStream(SSLSocket sSLSocket) {
        this.plaintext_out = new BufferedOutputStream(sSLSocket.getOutputStream());
    }

    public OutputStream getPlaintextOutputStream() {
        return this.plaintext_out;
    }

    public void writeMessage(MessageWireFormat messageWireFormat, Message message) throws IOException {
        int n = JXTATLSutil.getMessageLength(message);
        this.setAppOutputSize(n);
        messageWireFormat.writeMessage(this.plaintext_out, message);
        this.plaintext_out.flush();
    }

    private void setAppOutputSize(int n) {
        this.appOutputSize = n;
        this.nElements = 0;
        if (SSLDebug.getDebug(128)) {
            System.out.println("setAppOutputSize = " + n);
        }
    }

    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)(n & 0xFF)};
        this.write(byArray, 0, 1);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        SSLDebug.debug(128, "\nJXTAOutputStream: TLS Record size = " + n2);
        String string = "jxtatls:" + this.sequenceNumber;
        this.sentMelt = this.jmsg.newMessageElement(string, null, byArray, n, n2, null);
        this.jmsg.addElement(this.sentMelt);
        this.appOutputSize -= n2;
        ++this.nElements;
        this.queuedBytes += n2;
        if (this.appOutputSize <= 0 || this.nElements == this.MAXELEMENTS) {
            this.MsgWireOut.writeMessage(this.netOut, this.jmsg);
            if (SSLDebug.getDebug(128) && this.sequenceNumber % 10 == 0) {
                this.MsgWireOut.writeMessage(this.netOut, this.jmsg);
                System.out.println("Duplicate msg sent, final seq# " + this.sequenceNumber);
            }
            JXTATLSutil.removeElements(this.jmsg);
            if (SSLDebug.getDebug(128)) {
                System.out.println("SENT Elements = " + this.nElements + ", bytes = " + this.queuedBytes + ", decrementor = " + this.appOutputSize + "\n");
            }
            this.queuedBytes = 0;
            this.nElements = 0;
        } else if (SSLDebug.getDebug(128)) {
            System.out.println("Queued " + this.queuedBytes + " bytes, Elts queued = " + this.nElements + "\n");
        }
        ++this.sequenceNumber;
    }
}

