/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls;

import COM.claymoresystems.ptls.SSLCipherSuite;
import COM.claymoresystems.ptls.SSLHandshake;
import java.util.Vector;

class SSLSessionData {
    byte[] session_id;
    int ssl_version;
    byte[] master_secret;
    Vector peerCertificateChain;
    SSLCipherSuite cipher_suite;
    long expiry;
    String lookupKey;

    SSLSessionData(SSLHandshake sSLHandshake, String string) {
        this.session_id = sSLHandshake.session_id;
        this.ssl_version = sSLHandshake._conn.ssl_version;
        this.master_secret = sSLHandshake.master_secret;
        this.peerCertificateChain = sSLHandshake._conn.peerCertificateChain;
        this.cipher_suite = sSLHandshake.cipher_suite;
        this.expiry = System.currentTimeMillis() + (long)(sSLHandshake._conn.getPolicy().getSessionLifetime() * 1000);
        this.lookupKey = string;
        sSLHandshake._conn.sessionLookupKey = string;
    }

    void restoreSession(SSLHandshake sSLHandshake) {
        sSLHandshake.session_id = this.session_id;
        sSLHandshake._conn.ssl_version = this.ssl_version;
        sSLHandshake.master_secret = this.master_secret;
        sSLHandshake._conn.peerCertificateChain = this.peerCertificateChain;
        sSLHandshake.cipher_suite = this.cipher_suite;
        sSLHandshake._conn.sessionLookupKey = this.lookupKey;
    }

    byte[] getSessionID() {
        return this.session_id;
    }

    SSLCipherSuite getCipherSuite() {
        return this.cipher_suite;
    }

    int getSSLVersion() {
        return this.ssl_version;
    }

    Vector getPeerCertificateChain() {
        return this.peerCertificateChain;
    }

    long getExpiryTime() {
        return this.expiry;
    }

    String getLookupKey() {
        return this.lookupKey;
    }
}

