/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls;

import COM.claymoresystems.sslg.SSLPolicyInt;
import java.math.BigInteger;
import java.security.PrivateKey;
import xjava.security.interfaces.CryptixRSAPrivateKey;

class SSLCipherSuite {
    private int cipher_suite;
    private int keyExchangeAlg;
    private int signatureAlg;
    private String digestAlg;
    private int digestBytes;
    private String cipherAlg;
    private int cipherBytes;
    private int effectiveBytes;
    private boolean require_ske;
    private boolean export;
    private boolean block_cipher;
    public static final int SSL_KEX_DH = 1;
    public static final int SSL_KEX_RSA = 2;
    public static final int SSL_SIG_DSS = 1;
    public static final int SSL_SIG_RSA = 2;
    public static final int SSL_SIG_anon = 3;
    private static final SSLCipherSuite[] master_list = new SSLCipherSuite[]{new SSLCipherSuite(1, 2, 2, "MD5", 16, "NULL", 0, 0, false, true, false), new SSLCipherSuite(2, 2, 2, "SHA", 20, "NULL", 0, 0, false, true, false), new SSLCipherSuite(3, 2, 2, "MD5", 16, "RC4", 16, 5, false, true, false), new SSLCipherSuite(4, 2, 2, "MD5", 16, "RC4", 16, 16, false, false, false), new SSLCipherSuite(5, 2, 2, "SHA", 20, "RC4", 16, 16, false, false, false), new SSLCipherSuite(6, 2, 2, "MD5", 16, "RC2", 16, 5, false, true, true), new SSLCipherSuite(7, 2, 2, "SHA", 20, "IDEA", 16, 16, false, false, true), new SSLCipherSuite(8, 2, 2, "SHA", 20, "DES", 8, 5, false, true, true), new SSLCipherSuite(9, 2, 2, "SHA", 20, "DES", 8, 8, false, false, true), new SSLCipherSuite(10, 2, 2, "SHA", 20, "DES-EDE3", 24, 24, false, false, true), new SSLCipherSuite(11, 1, 1, "SHA", 20, "DES", 8, 5, false, true, true), new SSLCipherSuite(12, 1, 1, "SHA", 20, "DES", 8, 8, false, false, true), new SSLCipherSuite(13, 1, 1, "SHA", 20, "DES-EDE3", 24, 24, false, false, true), new SSLCipherSuite(14, 1, 2, "SHA", 20, "DES", 8, 5, false, true, true), new SSLCipherSuite(15, 1, 2, "SHA", 20, "DES", 8, 8, false, false, true), new SSLCipherSuite(16, 1, 2, "SHA", 20, "DES-EDE3", 24, 24, false, false, true), new SSLCipherSuite(17, 1, 1, "SHA", 20, "DES", 8, 5, true, true, true), new SSLCipherSuite(18, 1, 1, "SHA", 20, "DES", 8, 8, true, false, true), new SSLCipherSuite(19, 1, 1, "SHA", 20, "DES-EDE3", 24, 24, true, false, true), new SSLCipherSuite(20, 1, 2, "SHA", 20, "DES", 8, 5, true, true, true), new SSLCipherSuite(21, 1, 2, "SHA", 20, "DES", 8, 8, true, false, true), new SSLCipherSuite(22, 1, 2, "SHA", 20, "DES-EDE3", 24, 24, true, false, true), new SSLCipherSuite(23, 1, 3, "MD5", 16, "RC4", 16, 5, false, true, false), new SSLCipherSuite(24, 1, 3, "MD5", 16, "RC4", 16, 16, false, false, false), new SSLCipherSuite(25, 1, 3, "SHA", 20, "DES", 8, 8, false, false, true), new SSLCipherSuite(26, 1, 3, "SHA", 20, "DES", 8, 8, false, false, true), new SSLCipherSuite(27, 1, 3, "SHA", 20, "DES-EDE3", 24, 24, false, false, true), new SSLCipherSuite(102, 1, 1, "SHA", 20, "RC4", 16, 16, true, false, false), new SSLCipherSuite(103, 1, 1, "SHA", 20, "NULL", 0, 0, true, false, false)};

    public SSLCipherSuite(int n, int n2, int n3, String string, int n4, String string2, int n5, int n6, boolean bl, boolean bl2, boolean bl3) {
        this.cipher_suite = n;
        this.keyExchangeAlg = n2;
        this.signatureAlg = n3;
        this.digestAlg = string;
        this.digestBytes = n4;
        this.cipherAlg = string2;
        this.cipherBytes = n5;
        this.effectiveBytes = n6;
        this.require_ske = bl;
        this.export = bl2;
        this.block_cipher = bl3;
    }

    public static SSLCipherSuite findCipherSuite(int n) {
        int n2 = 0;
        while (n2 < master_list.length) {
            if (SSLCipherSuite.master_list[n2].cipher_suite == n) {
                return master_list[n2];
            }
            ++n2;
        }
        throw new Error("Unknown cipher suite  " + n);
    }

    int getValue() {
        return this.cipher_suite;
    }

    String getName() {
        return SSLPolicyInt.getCipherSuiteName(this.cipher_suite);
    }

    int getKeyExchangeAlg() {
        return this.keyExchangeAlg;
    }

    int getSignatureAlg() {
        return this.signatureAlg;
    }

    String getSignatureAlgNorm() {
        switch (this.signatureAlg) {
            case 2: {
                return this.digestAlg + "/RSA/PKCS#1";
            }
            case 1: {
                return "DSA";
            }
        }
        throw new InternalError("Bogus algorithm");
    }

    String getSignatureAlgBase() {
        switch (this.signatureAlg) {
            case 2: {
                return "RSA";
            }
            case 1: {
                return "DSA";
            }
        }
        throw new InternalError("Bogus algorithm");
    }

    String getSignatureAlgCV() {
        switch (this.signatureAlg) {
            case 2: {
                return "RawRSA";
            }
            case 1: {
                return "RawDSA";
            }
        }
        throw new InternalError("Bogus algorithm");
    }

    String getDigestAlg() {
        return this.digestAlg;
    }

    int getDigestOutputLength() {
        return this.digestBytes;
    }

    String getCipherAlg() {
        String string = this.cipherAlg;
        if (this.blockCipherP()) {
            string = string + "/CBC";
        }
        return string;
    }

    int getCipherKeyLength() {
        return this.cipherBytes;
    }

    int getCipherEffectiveKeyLength() {
        return this.effectiveBytes;
    }

    boolean requireServerKeyExchangeP(PrivateKey privateKey) {
        BigInteger bigInteger;
        if (this.require_ske) {
            return true;
        }
        if (!this.exportableP()) {
            return false;
        }
        return this.keyExchangeAlg == 2 && (bigInteger = ((CryptixRSAPrivateKey)privateKey).getModulus()).bitLength() > 512;
    }

    boolean exportableP() {
        return this.export;
    }

    boolean blockCipherP() {
        return this.block_cipher;
    }
}

