/*
 * Decompiled with CFR 0.152.
 */
package jxta.security.publickey;

import jxta.security.publickey.PublickeyData;
import jxta.security.publickey.RSAPublicKey;

public class RSAPublickeyData
implements PublickeyData {
    private byte[] modulus = null;
    private byte[] publicExponent = null;

    public RSAPublickeyData(RSAPublicKey rSAPublicKey) {
        this.modulus = new byte[rSAPublicKey.getModulusLength()];
        this.publicExponent = new byte[rSAPublicKey.getPublicExponentLength()];
        rSAPublicKey.getModulus(this.modulus, 0);
        rSAPublicKey.getPublicExponent(this.publicExponent, 0);
    }

    public RSAPublickeyData() {
        this.publicExponent = null;
        this.modulus = null;
    }

    public void setModulus(byte[] byArray) {
        this.modulus = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.modulus, 0, byArray.length);
    }

    public void setPublicExponent(byte[] byArray) {
        this.publicExponent = new byte[byArray.length];
        System.arraycopy(this.publicExponent, 0, byArray, 0, byArray.length);
    }

    public String getType() {
        return "RSA";
    }

    public byte[] getModulus() {
        return this.modulus;
    }

    public byte[] getPublicExponent() {
        return this.publicExponent;
    }

    public int getModulusLength() {
        return this.modulus.length;
    }

    public int getPublicExponentLength() {
        return this.publicExponent.length;
    }
}

