/*
 * Decompiled with CFR 0.152.
 */
package jxta.security.impl.hash;

import jxta.security.hash.Hash;

public class SHA1Hash
implements Hash {
    public final byte SHA1DigestLength = (byte)20;
    private static String myname = "SHA-1 Hash";
    private boolean debug = false;
    private final int blockLength = 16;
    private final int nStates = 5;
    private int[] block = new int[16];
    private int blockIndex;
    private int[] dd = new int[5];
    private int[] state = new int[5];
    private long count = 0L;
    private byte type = 1;
    private byte len = (byte)20;
    private int tmp;

    public SHA1Hash() {
        this.reset();
    }

    public String getAlgorithmName() {
        return myname;
    }

    public void setDebug() {
        this.debug = true;
    }

    public void clearDebug() {
        this.debug = false;
    }

    public byte getAlgorithm() {
        return this.type;
    }

    public byte getDigestLength() {
        return this.len;
    }

    public void reset() {
        this.state[0] = 1732584193;
        this.state[1] = -271733879;
        this.state[2] = -1732584194;
        this.state[3] = 271733878;
        this.state[4] = -1009589776;
        this.count = 0L;
        this.blockIndex = 0;
        int n = 0;
        while (n < 16) {
            this.block[n] = 0;
            ++n;
        }
        int n2 = 0;
        while (n2 < 5) {
            this.dd[n2] = 0;
            ++n2;
        }
        this.type = 1;
        this.len = (byte)20;
    }

    private final void R0(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        this.block[n6] = (this.block[n6] << 24 | this.block[n6] >>> 8) & 0xFF00FF00 | (this.block[n6] << 8 | this.block[n6] >>> 24) & 0xFF00FF;
        int n7 = n5;
        nArray[n7] = nArray[n7] + ((nArray[n2] & (nArray[n3] ^ nArray[n4]) ^ nArray[n4]) + this.block[n6] + 1518500249 + (nArray[n] << 5 | nArray[n] >>> 27));
        nArray[n2] = nArray[n2] << 30 | nArray[n2] >>> 2;
    }

    private final void R1(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        this.tmp = this.block[n6 + 13 & 0xF] ^ this.block[n6 + 8 & 0xF] ^ this.block[n6 + 2 & 0xF] ^ this.block[n6 & 0xF];
        this.block[n6 & 0xF] = this.tmp = this.tmp << 1 | this.tmp >>> 31;
        int n7 = n5;
        nArray[n7] = nArray[n7] + ((nArray[n2] & (nArray[n3] ^ nArray[n4]) ^ nArray[n4]) + this.tmp + 1518500249 + (nArray[n] << 5 | nArray[n] >>> 27));
        nArray[n2] = nArray[n2] << 30 | nArray[n2] >>> 2;
    }

    private final void R2(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        this.tmp = this.block[n6 + 13 & 0xF] ^ this.block[n6 + 8 & 0xF] ^ this.block[n6 + 2 & 0xF] ^ this.block[n6 & 0xF];
        this.block[n6 & 0xF] = this.tmp = this.tmp << 1 | this.tmp >>> 31;
        int n7 = n5;
        nArray[n7] = nArray[n7] + ((nArray[n2] ^ nArray[n3] ^ nArray[n4]) + this.tmp + 1859775393 + (nArray[n] << 5 | nArray[n] >>> 27));
        nArray[n2] = nArray[n2] << 30 | nArray[n2] >>> 2;
    }

    private final void R3(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        this.tmp = this.block[n6 + 13 & 0xF] ^ this.block[n6 + 8 & 0xF] ^ this.block[n6 + 2 & 0xF] ^ this.block[n6 & 0xF];
        this.block[n6 & 0xF] = this.tmp = this.tmp << 1 | this.tmp >>> 31;
        int n7 = n5;
        nArray[n7] = nArray[n7] + (((nArray[n2] | nArray[n3]) & nArray[n4] | nArray[n2] & nArray[n3]) + this.tmp + -1894007588 + (nArray[n] << 5 | nArray[n] >>> 27));
        nArray[n2] = nArray[n2] << 30 | nArray[n2] >>> 2;
    }

    private final void R4(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        this.tmp = this.block[n6 + 13 & 0xF] ^ this.block[n6 + 8 & 0xF] ^ this.block[n6 + 2 & 0xF] ^ this.block[n6 & 0xF];
        this.block[n6 & 0xF] = this.tmp = this.tmp << 1 | this.tmp >>> 31;
        int n7 = n5;
        nArray[n7] = nArray[n7] + ((nArray[n2] ^ nArray[n3] ^ nArray[n4]) + this.tmp + -899497514 + (nArray[n] << 5 | nArray[n] >>> 27));
        nArray[n2] = nArray[n2] << 30 | nArray[n2] >>> 2;
    }

    private void transform() {
        this.dd[0] = this.state[0];
        this.dd[1] = this.state[1];
        this.dd[2] = this.state[2];
        this.dd[3] = this.state[3];
        this.dd[4] = this.state[4];
        this.R0(this.dd, 0, 1, 2, 3, 4, 0);
        this.R0(this.dd, 4, 0, 1, 2, 3, 1);
        this.R0(this.dd, 3, 4, 0, 1, 2, 2);
        this.R0(this.dd, 2, 3, 4, 0, 1, 3);
        this.R0(this.dd, 1, 2, 3, 4, 0, 4);
        this.R0(this.dd, 0, 1, 2, 3, 4, 5);
        this.R0(this.dd, 4, 0, 1, 2, 3, 6);
        this.R0(this.dd, 3, 4, 0, 1, 2, 7);
        this.R0(this.dd, 2, 3, 4, 0, 1, 8);
        this.R0(this.dd, 1, 2, 3, 4, 0, 9);
        this.R0(this.dd, 0, 1, 2, 3, 4, 10);
        this.R0(this.dd, 4, 0, 1, 2, 3, 11);
        this.R0(this.dd, 3, 4, 0, 1, 2, 12);
        this.R0(this.dd, 2, 3, 4, 0, 1, 13);
        this.R0(this.dd, 1, 2, 3, 4, 0, 14);
        this.R0(this.dd, 0, 1, 2, 3, 4, 15);
        this.R1(this.dd, 4, 0, 1, 2, 3, 16);
        this.R1(this.dd, 3, 4, 0, 1, 2, 17);
        this.R1(this.dd, 2, 3, 4, 0, 1, 18);
        this.R1(this.dd, 1, 2, 3, 4, 0, 19);
        this.R2(this.dd, 0, 1, 2, 3, 4, 20);
        this.R2(this.dd, 4, 0, 1, 2, 3, 21);
        this.R2(this.dd, 3, 4, 0, 1, 2, 22);
        this.R2(this.dd, 2, 3, 4, 0, 1, 23);
        this.R2(this.dd, 1, 2, 3, 4, 0, 24);
        this.R2(this.dd, 0, 1, 2, 3, 4, 25);
        this.R2(this.dd, 4, 0, 1, 2, 3, 26);
        this.R2(this.dd, 3, 4, 0, 1, 2, 27);
        this.R2(this.dd, 2, 3, 4, 0, 1, 28);
        this.R2(this.dd, 1, 2, 3, 4, 0, 29);
        this.R2(this.dd, 0, 1, 2, 3, 4, 30);
        this.R2(this.dd, 4, 0, 1, 2, 3, 31);
        this.R2(this.dd, 3, 4, 0, 1, 2, 32);
        this.R2(this.dd, 2, 3, 4, 0, 1, 33);
        this.R2(this.dd, 1, 2, 3, 4, 0, 34);
        this.R2(this.dd, 0, 1, 2, 3, 4, 35);
        this.R2(this.dd, 4, 0, 1, 2, 3, 36);
        this.R2(this.dd, 3, 4, 0, 1, 2, 37);
        this.R2(this.dd, 2, 3, 4, 0, 1, 38);
        this.R2(this.dd, 1, 2, 3, 4, 0, 39);
        this.R3(this.dd, 0, 1, 2, 3, 4, 40);
        this.R3(this.dd, 4, 0, 1, 2, 3, 41);
        this.R3(this.dd, 3, 4, 0, 1, 2, 42);
        this.R3(this.dd, 2, 3, 4, 0, 1, 43);
        this.R3(this.dd, 1, 2, 3, 4, 0, 44);
        this.R3(this.dd, 0, 1, 2, 3, 4, 45);
        this.R3(this.dd, 4, 0, 1, 2, 3, 46);
        this.R3(this.dd, 3, 4, 0, 1, 2, 47);
        this.R3(this.dd, 2, 3, 4, 0, 1, 48);
        this.R3(this.dd, 1, 2, 3, 4, 0, 49);
        this.R3(this.dd, 0, 1, 2, 3, 4, 50);
        this.R3(this.dd, 4, 0, 1, 2, 3, 51);
        this.R3(this.dd, 3, 4, 0, 1, 2, 52);
        this.R3(this.dd, 2, 3, 4, 0, 1, 53);
        this.R3(this.dd, 1, 2, 3, 4, 0, 54);
        this.R3(this.dd, 0, 1, 2, 3, 4, 55);
        this.R3(this.dd, 4, 0, 1, 2, 3, 56);
        this.R3(this.dd, 3, 4, 0, 1, 2, 57);
        this.R3(this.dd, 2, 3, 4, 0, 1, 58);
        this.R3(this.dd, 1, 2, 3, 4, 0, 59);
        this.R4(this.dd, 0, 1, 2, 3, 4, 60);
        this.R4(this.dd, 4, 0, 1, 2, 3, 61);
        this.R4(this.dd, 3, 4, 0, 1, 2, 62);
        this.R4(this.dd, 2, 3, 4, 0, 1, 63);
        this.R4(this.dd, 1, 2, 3, 4, 0, 64);
        this.R4(this.dd, 0, 1, 2, 3, 4, 65);
        this.R4(this.dd, 4, 0, 1, 2, 3, 66);
        this.R4(this.dd, 3, 4, 0, 1, 2, 67);
        this.R4(this.dd, 2, 3, 4, 0, 1, 68);
        this.R4(this.dd, 1, 2, 3, 4, 0, 69);
        this.R4(this.dd, 0, 1, 2, 3, 4, 70);
        this.R4(this.dd, 4, 0, 1, 2, 3, 71);
        this.R4(this.dd, 3, 4, 0, 1, 2, 72);
        this.R4(this.dd, 2, 3, 4, 0, 1, 73);
        this.R4(this.dd, 1, 2, 3, 4, 0, 74);
        this.R4(this.dd, 0, 1, 2, 3, 4, 75);
        this.R4(this.dd, 4, 0, 1, 2, 3, 76);
        this.R4(this.dd, 3, 4, 0, 1, 2, 77);
        this.R4(this.dd, 2, 3, 4, 0, 1, 78);
        this.R4(this.dd, 1, 2, 3, 4, 0, 79);
        this.state[0] = this.state[0] + this.dd[0];
        this.state[1] = this.state[1] + this.dd[1];
        this.state[2] = this.state[2] + this.dd[2];
        this.state[3] = this.state[3] + this.dd[3];
        this.state[4] = this.state[4] + this.dd[4];
    }

    private byte[] digest() {
        byte[] byArray = new byte[20];
        byte[] byArray2 = new byte[8];
        int n = 0;
        while (n < 8) {
            byArray2[n] = (byte)(this.count >>> (7 - n) * 8 & 0xFFL);
            ++n;
        }
        int n2 = 55 - this.blockIndex;
        if (n2 < 0) {
            n2 += 64;
        }
        int n3 = n2 + 1;
        byte[] byArray3 = new byte[n3];
        byArray3[0] = -128;
        n = 1;
        while (n < n3) {
            byArray3[n] = 0;
            ++n;
        }
        this.update(byArray3, 0, n3);
        this.update(byArray2, 0, 8);
        n = 0;
        while (n < 20) {
            byArray[n] = (byte)(this.state[n >> 2] >> (3 - (n & 3)) * 8 & 0xFF);
            ++n;
        }
        return byArray;
    }

    public Object clone() {
        SHA1Hash sHA1Hash = new SHA1Hash();
        System.arraycopy(this.block, 0, sHA1Hash.block, 0, 16);
        System.arraycopy(this.dd, 0, sHA1Hash.dd, 0, 5);
        System.arraycopy(this.state, 0, sHA1Hash.state, 0, 5);
        sHA1Hash.blockIndex = this.blockIndex;
        sHA1Hash.count = this.count;
        sHA1Hash.type = this.type;
        sHA1Hash.len = this.len;
        return sHA1Hash;
    }

    public void update(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = n;
        while (n4 < n + n2) {
            n3 = (this.blockIndex & 3) << 3;
            int n5 = this.blockIndex >> 2;
            this.block[n5] = this.block[n5] & ~(255 << n3);
            int n6 = this.blockIndex >> 2;
            this.block[n6] = this.block[n6] | (byArray[n4] & 0xFF) << n3;
            ++this.blockIndex;
            if (this.blockIndex == 64) {
                this.transform();
                this.blockIndex = 0;
            }
            ++n4;
        }
        this.count += (long)(n2 << 3);
    }

    public int doFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        try {
            int n4 = byArray2[n3] + byArray2[n3 + this.len - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (this.debug) {
                int n5 = this.len - 1;
                System.out.println("SHA1Hash - doFinal: Index out of bounds\nmax = " + n3 + n5 + " outOff = " + n3 + " hash len = " + n5);
            }
            return 0;
        }
        this.update(byArray, n, n2);
        System.arraycopy(this.digest(), 0, byArray2, n3, this.len);
        this.reset();
        return 20;
    }
}

