/*
 * Decompiled with CFR 0.152.
 */
package jxta.security.impl.hash;

import jxta.security.hash.Hash;

public class MD5Hash
implements Hash {
    private static final int S11 = 7;
    private static final int S12 = 12;
    private static final int S13 = 17;
    private static final int S14 = 22;
    private static final int S21 = 5;
    private static final int S22 = 9;
    private static final int S23 = 14;
    private static final int S24 = 20;
    private static final int S31 = 4;
    private static final int S32 = 11;
    private static final int S33 = 16;
    private static final int S34 = 23;
    private static final int S41 = 6;
    private static final int S42 = 10;
    private static final int S43 = 15;
    private static final int S44 = 21;
    private static final byte[] padding = new byte[]{-128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private final int MD5DigestLength = 16;
    private static String myname = "MD5 Hash";
    private static boolean debug = false;
    private final int bufferLength = 64;
    private int[] state = new int[4];
    private int[] count = new int[2];
    private byte[] buffer = new byte[64];
    private byte type = (byte)2;
    private byte len = (byte)16;

    public MD5Hash() {
        this.reset();
    }

    public String getAlgorithmName() {
        return myname;
    }

    public void setDebug() {
        debug = true;
    }

    public void clearDebug() {
        debug = false;
    }

    private static int FF(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = 0;
        n8 = n2 & n3 | ~n2 & n4;
        n += n8 + n5 + n7;
        n = n << n6 | n >>> 32 - n6;
        return n += n2;
    }

    private static int GG(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = 0;
        n8 = n2 & n4 | n3 & ~n4;
        n += n8 + n5 + n7;
        n = n << n6 | n >>> 32 - n6;
        return n += n2;
    }

    private static int HH(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = 0;
        n8 = n2 ^ n3 ^ n4;
        n += n8 + n5 + n7;
        n = n << n6 | n >>> 32 - n6;
        return n += n2;
    }

    private static int II(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = 0;
        n8 = n3 ^ (n2 | ~n4);
        n += n8 + n5 + n7;
        n = n << n6 | n >>> 32 - n6;
        return n += n2;
    }

    private void transform(byte[] byArray, int n) {
        int n2 = this.state[0];
        int n3 = this.state[1];
        int n4 = this.state[2];
        int n5 = this.state[3];
        int[] nArray = new int[16];
        int n6 = 0;
        int n7 = n;
        while (n7 < n + 64) {
            nArray[n6] = byArray[n7] & 0xFF | (byArray[n7 + 1] & 0xFF) << 8 | (byArray[n7 + 2] & 0xFF) << 16 | (byArray[n7 + 3] & 0xFF) << 24;
            ++n6;
            n7 += 4;
        }
        n2 = MD5Hash.FF(n2, n3, n4, n5, nArray[0], 7, -680876936);
        n5 = MD5Hash.FF(n5, n2, n3, n4, nArray[1], 12, -389564586);
        n4 = MD5Hash.FF(n4, n5, n2, n3, nArray[2], 17, 606105819);
        n3 = MD5Hash.FF(n3, n4, n5, n2, nArray[3], 22, -1044525330);
        n2 = MD5Hash.FF(n2, n3, n4, n5, nArray[4], 7, -176418897);
        n5 = MD5Hash.FF(n5, n2, n3, n4, nArray[5], 12, 1200080426);
        n4 = MD5Hash.FF(n4, n5, n2, n3, nArray[6], 17, -1473231341);
        n3 = MD5Hash.FF(n3, n4, n5, n2, nArray[7], 22, -45705983);
        n2 = MD5Hash.FF(n2, n3, n4, n5, nArray[8], 7, 1770035416);
        n5 = MD5Hash.FF(n5, n2, n3, n4, nArray[9], 12, -1958414417);
        n4 = MD5Hash.FF(n4, n5, n2, n3, nArray[10], 17, -42063);
        n3 = MD5Hash.FF(n3, n4, n5, n2, nArray[11], 22, -1990404162);
        n2 = MD5Hash.FF(n2, n3, n4, n5, nArray[12], 7, 1804603682);
        n5 = MD5Hash.FF(n5, n2, n3, n4, nArray[13], 12, -40341101);
        n4 = MD5Hash.FF(n4, n5, n2, n3, nArray[14], 17, -1502002290);
        n3 = MD5Hash.FF(n3, n4, n5, n2, nArray[15], 22, 1236535329);
        n2 = MD5Hash.GG(n2, n3, n4, n5, nArray[1], 5, -165796510);
        n5 = MD5Hash.GG(n5, n2, n3, n4, nArray[6], 9, -1069501632);
        n4 = MD5Hash.GG(n4, n5, n2, n3, nArray[11], 14, 643717713);
        n3 = MD5Hash.GG(n3, n4, n5, n2, nArray[0], 20, -373897302);
        n2 = MD5Hash.GG(n2, n3, n4, n5, nArray[5], 5, -701558691);
        n5 = MD5Hash.GG(n5, n2, n3, n4, nArray[10], 9, 38016083);
        n4 = MD5Hash.GG(n4, n5, n2, n3, nArray[15], 14, -660478335);
        n3 = MD5Hash.GG(n3, n4, n5, n2, nArray[4], 20, -405537848);
        n2 = MD5Hash.GG(n2, n3, n4, n5, nArray[9], 5, 568446438);
        n5 = MD5Hash.GG(n5, n2, n3, n4, nArray[14], 9, -1019803690);
        n4 = MD5Hash.GG(n4, n5, n2, n3, nArray[3], 14, -187363961);
        n3 = MD5Hash.GG(n3, n4, n5, n2, nArray[8], 20, 1163531501);
        n2 = MD5Hash.GG(n2, n3, n4, n5, nArray[13], 5, -1444681467);
        n5 = MD5Hash.GG(n5, n2, n3, n4, nArray[2], 9, -51403784);
        n4 = MD5Hash.GG(n4, n5, n2, n3, nArray[7], 14, 1735328473);
        n3 = MD5Hash.GG(n3, n4, n5, n2, nArray[12], 20, -1926607734);
        n2 = MD5Hash.HH(n2, n3, n4, n5, nArray[5], 4, -378558);
        n5 = MD5Hash.HH(n5, n2, n3, n4, nArray[8], 11, -2022574463);
        n4 = MD5Hash.HH(n4, n5, n2, n3, nArray[11], 16, 1839030562);
        n3 = MD5Hash.HH(n3, n4, n5, n2, nArray[14], 23, -35309556);
        n2 = MD5Hash.HH(n2, n3, n4, n5, nArray[1], 4, -1530992060);
        n5 = MD5Hash.HH(n5, n2, n3, n4, nArray[4], 11, 1272893353);
        n4 = MD5Hash.HH(n4, n5, n2, n3, nArray[7], 16, -155497632);
        n3 = MD5Hash.HH(n3, n4, n5, n2, nArray[10], 23, -1094730640);
        n2 = MD5Hash.HH(n2, n3, n4, n5, nArray[13], 4, 681279174);
        n5 = MD5Hash.HH(n5, n2, n3, n4, nArray[0], 11, -358537222);
        n4 = MD5Hash.HH(n4, n5, n2, n3, nArray[3], 16, -722521979);
        n3 = MD5Hash.HH(n3, n4, n5, n2, nArray[6], 23, 76029189);
        n2 = MD5Hash.HH(n2, n3, n4, n5, nArray[9], 4, -640364487);
        n5 = MD5Hash.HH(n5, n2, n3, n4, nArray[12], 11, -421815835);
        n4 = MD5Hash.HH(n4, n5, n2, n3, nArray[15], 16, 530742520);
        n3 = MD5Hash.HH(n3, n4, n5, n2, nArray[2], 23, -995338651);
        n2 = MD5Hash.II(n2, n3, n4, n5, nArray[0], 6, -198630844);
        n5 = MD5Hash.II(n5, n2, n3, n4, nArray[7], 10, 1126891415);
        n4 = MD5Hash.II(n4, n5, n2, n3, nArray[14], 15, -1416354905);
        n3 = MD5Hash.II(n3, n4, n5, n2, nArray[5], 21, -57434055);
        n2 = MD5Hash.II(n2, n3, n4, n5, nArray[12], 6, 1700485571);
        n5 = MD5Hash.II(n5, n2, n3, n4, nArray[3], 10, -1894986606);
        n4 = MD5Hash.II(n4, n5, n2, n3, nArray[10], 15, -1051523);
        n3 = MD5Hash.II(n3, n4, n5, n2, nArray[1], 21, -2054922799);
        n2 = MD5Hash.II(n2, n3, n4, n5, nArray[8], 6, 1873313359);
        n5 = MD5Hash.II(n5, n2, n3, n4, nArray[15], 10, -30611744);
        n4 = MD5Hash.II(n4, n5, n2, n3, nArray[6], 15, -1560198380);
        n3 = MD5Hash.II(n3, n4, n5, n2, nArray[13], 21, 1309151649);
        n2 = MD5Hash.II(n2, n3, n4, n5, nArray[4], 6, -145523070);
        n5 = MD5Hash.II(n5, n2, n3, n4, nArray[11], 10, -1120210379);
        n4 = MD5Hash.II(n4, n5, n2, n3, nArray[2], 15, 718787259);
        n3 = MD5Hash.II(n3, n4, n5, n2, nArray[9], 21, -343485551);
        this.state[0] = this.state[0] + n2;
        this.state[1] = this.state[1] + n3;
        this.state[2] = this.state[2] + n4;
        this.state[3] = this.state[3] + n5;
        int n8 = 0;
        while (n8 < nArray.length) {
            nArray[n8] = 0;
            ++n8;
        }
    }

    private byte[] digest() {
        byte[] byArray = new byte[16];
        byte[] byArray2 = new byte[]{(byte)(this.count[0] & 0xFF), (byte)(this.count[0] >>> 8 & 0xFF), (byte)(this.count[0] >>> 16 & 0xFF), (byte)(this.count[0] >>> 24 & 0xFF), (byte)(this.count[1] & 0xFF), (byte)(this.count[1] >>> 8 & 0xFF), (byte)(this.count[1] >>> 16 & 0xFF), (byte)(this.count[1] >>> 24 & 0xFF)};
        int n = this.count[0] >>> 3 & 0x3F;
        int n2 = n < 56 ? 56 - n : 120 - n;
        this.update(padding, 0, n2);
        this.update(byArray2, 0, 8);
        byArray[0] = (byte)(this.state[0] & 0xFF);
        byArray[1] = (byte)(this.state[0] >>> 8 & 0xFF);
        byArray[2] = (byte)(this.state[0] >>> 16 & 0xFF);
        byArray[3] = (byte)(this.state[0] >>> 24 & 0xFF);
        byArray[4] = (byte)(this.state[1] & 0xFF);
        byArray[5] = (byte)(this.state[1] >>> 8 & 0xFF);
        byArray[6] = (byte)(this.state[1] >>> 16 & 0xFF);
        byArray[7] = (byte)(this.state[1] >>> 24 & 0xFF);
        byArray[8] = (byte)(this.state[2] & 0xFF);
        byArray[9] = (byte)(this.state[2] >>> 8 & 0xFF);
        byArray[10] = (byte)(this.state[2] >>> 16 & 0xFF);
        byArray[11] = (byte)(this.state[2] >>> 24 & 0xFF);
        byArray[12] = (byte)(this.state[3] & 0xFF);
        byArray[13] = (byte)(this.state[3] >>> 8 & 0xFF);
        byArray[14] = (byte)(this.state[3] >>> 16 & 0xFF);
        byArray[15] = (byte)(this.state[3] >>> 24 & 0xFF);
        this.count[1] = 0;
        this.count[0] = 0;
        this.state[3] = 0;
        this.state[2] = 0;
        this.state[1] = 0;
        this.state[0] = 0;
        return byArray;
    }

    public byte getAlgorithm() {
        return this.type;
    }

    public byte getDigestLength() {
        return this.len;
    }

    public void reset() {
        this.count[0] = 0;
        this.count[1] = 0;
        this.state[0] = 1732584193;
        this.state[1] = -271733879;
        this.state[2] = -1732584194;
        this.state[3] = 271733878;
        this.type = (byte)2;
        this.len = (byte)16;
        int n = 0;
        while (n < 64) {
            this.buffer[n] = 0;
            ++n;
        }
    }

    public Object clone() {
        MD5Hash mD5Hash = new MD5Hash();
        System.arraycopy(this.state, 0, mD5Hash.state, 0, 4);
        System.arraycopy(this.buffer, 0, mD5Hash.buffer, 0, 64);
        System.arraycopy(this.count, 0, mD5Hash.count, 0, 2);
        mD5Hash.type = this.type;
        mD5Hash.len = this.len;
        return mD5Hash;
    }

    public void update(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        n4 = this.count[0] >>> 3 & 0x3F;
        int n6 = n2 << 3;
        this.count[0] = this.count[0] + n6;
        if (this.count[0] < n6) {
            this.count[1] = this.count[1] + 1;
        }
        this.count[1] = this.count[1] + (n2 >>> 29);
        n5 = 64 - n4;
        if (n2 >= n5) {
            System.arraycopy(byArray, n, this.buffer, n4, n5);
            this.transform(this.buffer, 0);
            n3 = n5;
            while (n3 + 63 < n2) {
                this.transform(byArray, n3 + n);
                n3 += 64;
            }
            n4 = 0;
        } else {
            n3 = 0;
        }
        System.arraycopy(byArray, n3 + n, this.buffer, n4, n2 - n3);
    }

    public int doFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        try {
            int n4 = byArray2[n3] + byArray2[n3 + this.len - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (debug) {
                int n5 = this.len - 1;
                System.out.println("MD5 Hash - doFinal: Index out of bounds\nmax = " + n3 + n5 + " outOff = " + n3 + " hash len = " + n5);
            }
            return 0;
        }
        this.update(byArray, n, n2);
        System.arraycopy(this.digest(), 0, byArray2, n3, this.len);
        this.reset();
        return this.len;
    }
}

