/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.warp;

import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.catalina.connector.HttpResponseBase;
import org.apache.catalina.connector.ResponseBase;
import org.apache.catalina.connector.warp.WarpConnection;
import org.apache.catalina.connector.warp.WarpPacket;
import org.apache.catalina.util.CookieTools;

public class WarpResponse
extends HttpResponseBase {
    private Stream localstream = new Stream(this);
    private WarpPacket packet;
    private WarpConnection connection;

    public WarpResponse() {
        this.setStream(this.localstream);
    }

    public void finishResponse() throws IOException {
        super.finishResponse();
        this.localstream.finish();
    }

    public WarpConnection getConnection() {
        return this.connection;
    }

    public WarpPacket getPacket() {
        return this.packet;
    }

    public void recycle() {
        super.recycle();
        this.localstream.recycle();
        this.setStream(this.localstream);
    }

    protected void sendHeaders() throws IOException {
        ArrayList cookie;
        if (this.isCommitted()) {
            return;
        }
        if ("HTTP/0.9".equals(((ResponseBase)this).request.getRequest().getProtocol())) {
            ((ResponseBase)this).committed = true;
            return;
        }
        this.packet.reset();
        this.packet.setType(32);
        this.packet.writeUnsignedShort(this.status);
        this.packet.writeString(this.message);
        this.connection.send(this.packet);
        if (this.getContentType() != null) {
            this.packet.reset();
            this.packet.setType(33);
            this.packet.writeString("Content-Type");
            this.packet.writeString(this.getContentType());
            this.connection.send(this.packet);
        }
        if (this.getContentLength() >= 0) {
            this.packet.reset();
            this.packet.setType(33);
            this.packet.writeString("Content-Length");
            this.packet.writeString(Integer.toString(this.getContentLength()));
            this.connection.send(this.packet);
        }
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            Iterator names = this.headers.keySet().iterator();
            while (names.hasNext()) {
                String name = (String)names.next();
                ArrayList values = (ArrayList)this.headers.get(name);
                Iterator items = ((AbstractList)values).iterator();
                while (items.hasNext()) {
                    String value = (String)items.next();
                    this.packet.reset();
                    this.packet.setType(33);
                    this.packet.writeString(name);
                    this.packet.writeString(value);
                    this.connection.send(this.packet);
                }
            }
        }
        HttpServletRequest hreq = (HttpServletRequest)((ResponseBase)this).request.getRequest();
        HttpSession session = hreq.getSession(false);
        if (session != null && session.isNew() && this.getContext() != null && this.getContext().getCookies()) {
            cookie = new Cookie("JSESSIONID", session.getId());
            cookie.setMaxAge(-1);
            String contextPath = null;
            if (((ResponseBase)this).context != null) {
                contextPath = ((ResponseBase)this).context.getPath();
            }
            if (contextPath != null && contextPath.length() > 0) {
                cookie.setPath(contextPath);
            } else {
                cookie.setPath("/");
            }
            if (hreq.isSecure()) {
                cookie.setSecure(true);
            }
            this.addCookie((Cookie)cookie);
        }
        cookie = this.cookies;
        synchronized (cookie) {
            Iterator items = ((AbstractList)this.cookies).iterator();
            while (items.hasNext()) {
                Cookie cookie2 = (Cookie)items.next();
                String name = CookieTools.getCookieHeaderName((Cookie)cookie2);
                StringBuffer value = new StringBuffer();
                CookieTools.getCookieHeaderValue((Cookie)cookie2, (StringBuffer)value);
                this.packet.reset();
                this.packet.setType(33);
                this.packet.writeString(name);
                this.packet.writeString(value.toString());
                this.connection.send(this.packet);
            }
            // ** MonitorExit[names] (shouldn't be in output)
            this.packet.reset();
            this.packet.setType(47);
            this.connection.send(this.packet);
            ((ResponseBase)this).committed = true;
            return;
        }
    }

    public void setConnection(WarpConnection connection) {
        this.connection = connection;
    }

    public void setPacket(WarpPacket packet) {
        this.packet = packet;
    }

    protected class Stream
    extends OutputStream {
        private WarpResponse response = null;
        private WarpPacket packet = null;
        private boolean closed = false;

        protected Stream(WarpResponse response) {
            this.response = response;
            this.packet = new WarpPacket();
        }

        public void close() throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            this.flush();
            this.packet.setType(63);
            this.response.getConnection().send(this.packet);
            this.packet.reset();
        }

        public void finish() throws IOException {
            if (this.closed) {
                return;
            }
            this.close();
        }

        public void flush() throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            this.packet.setType(48);
            this.response.getConnection().send(this.packet);
            this.packet.reset();
        }

        public void recycle() {
            this.packet.reset();
            this.closed = false;
        }

        public void write(int b) throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            if (this.packet.size >= this.packet.buffer.length) {
                this.flush();
            }
            this.packet.buffer[this.packet.size++] = (byte)b;
        }
    }
}

