<?xml version="1.0"?> 

<!--

$Id: mozilla-search.xsl,v 1.42 2002/02/09 10:07:52 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

See http://reptile.openprivacy.org for more information

TODO:

- This page is setup to process each channel into a content-list.

-->

<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema-instance"
                xmlns:layout="http://schemas.openprivacy.org/reptile/layout"
                xmlns:page="http://schemas.openprivacy.org/reptile/mozilla/page"
                xmlns:dc="http://purl.org/metadata/dublin_core#" 
                xmlns:dce="http://purl.org/dc/elements/1.1/"
                xmlns:control="http://schemas.openprivacy.org/reptile/control"
                xmlns:cl="http://schemas.openprivacy.org/reptile/content-list"
                xmlns:link-producer="http://schemas.openprivacy.org/reptile/link-producer"
                xmlns:logo-producer="http://schemas.openprivacy.org/reptile/logo-producer"
                xmlns:error="http://schemas.openprivacy.org/reptile/error"
                xmlns:search="http://schemas.openprivacy.org/reptile/search"
                xmlns:timestamp="xalan://org.openprivacy.reptile.extensions.TimeStamp"
                xmlns:channel-extension="xalan://org.openprivacy.reptile.extensions.om.ChannelExtension"
                xmlns:article-extension="xalan://org.openprivacy.reptile.extensions.om.ArticleExtension"
                xmlns:escape="xalan://org.openprivacy.reptile.extensions.EscapeExtension"
                xmlns:bootstrap="http://schemas.openprivacy.org/reptile/bootstrap"
                xmlns:image="xalan://org.openprivacy.reptile.extensions.Image"
                extension-element-prefixes="channel-extension article-extension timestamp escape image"
                version="1.0">

    <xsl:include href="resource:/xsl/misc/error/mozilla/mozilla-error.xsl"/>

    <xsl:output indent="yes" 
                omit-xml-declaration="yes"
                encoding="ISO-8859-1"/>

    <xsl:param name="reptile.search.criteria" select="''"/>
    <xsl:param name="provider-name" select="/bootstrap:bootstrap/search:search/@provider-name"/>
    <xsl:param name="request-name" select="/bootstrap:bootstrap/search:search/@request-name"/>

    <xsl:param name="reptile.home.location" select="''"/>

    <xsl:template match="/bootstrap:bootstrap/search:search">

        <control:content subscribe="false">
    
            <dce:title>Search Results</dce:title>
    
            <control:body>

                <!-- FIXME: put an advanced search form here -->
                
<!--                 <xsl:call-template name="advanced-search"/> -->

                <xsl:apply-templates/>

            </control:body>

        </control:content>

    </xsl:template>

    <xsl:template match="search:request">

        <p>

            <center>
                
                <table>

                    <form method="get" action="{$reptile.home.location}">

                        <td valign="top" width="280" class="reptile-search-control" nowrap="nowrap">
                            
                            <b> Provider name: </b> <xsl:value-of select="../@provider-name"/><br/>
                            <b> Request name: </b> <xsl:value-of select="../@request-name"/><br/>
                            <b> State: </b> <xsl:value-of select="../@provider-state"/>

                            <p>

                                <input type="hidden" name="reptile.action" value="SearchRefresh"/>
                                <input type="hidden" name="reptile.search.provider.handle" value="{../@provider-handle}"/>
                                <input type="submit" value="Refresh"/>

                            </p>

                            <!-- display nice messages for custom queries -->
                            
                            <xsl:if test="$request-name = 'UnreadArticlesSearchRequest'">

                                <p>

                                    Searching for unread articles...
                                    
                                </p>
                                
                            </xsl:if>

                            <xsl:if test="$request-name = 'RecentArticlesSearchRequest'">

                                <p>

                                    Searching for recent (last 1000) articles (either read or unread)
                                    
                                </p>
                                
                            </xsl:if>

                            <xsl:if test="$request-name = 'NewestArticlesSearchRequest'">

                                <p>

                                    Searching for newest articles found in the last hour.
                                    
                                </p>
                                
                            </xsl:if>

                        </td>

                    </form>

                    <td width="10"/>

                    <form method="get" action="{$reptile.home.location}">

                    <td valign="top" class="reptile-search-control">

                            <table>

                                <tr>

                                    <td>

                                        <b>Search: </b>

                                    </td>
                                    
                                    <td>
                                        
                                        <input name="reptile.search.criteria" type="text" class="reptile-quick-search">

                                            <!-- on basic search requests... include the string -->
                                            
                                            <xsl:if test="$request-name = 'SearchRequest'">

                                                <xsl:attribute name="value">

                                                    <xsl:value-of select="./search:criteria/xs:string[1]"/>
                                                    
                                                </xsl:attribute>

                                            </xsl:if>

                                        </input>

                                    </td>

                                </tr>
                                
                                <tr>
                                    <td>

                                        <b>Within: </b>

                                    </td>

                                    <td>
                                        <select name="reptile.search.provider" size="4">
                                            
                                            <option value="ArticleSearchProvider">

                                                <xsl:if test="$provider-name = 'ArticleSearchProvider'">

                                                    <xsl:attribute name="selected">selected</xsl:attribute>
                                                    
                                                </xsl:if>
                                                
                                                <article-extension:count/> articles (ArticleSearchProvider)

                                            </option>

                                            <option value="ChannelSearchProvider">

                                                <xsl:if test="$provider-name = 'ChannelSearchProvider'">

                                                    <xsl:attribute name="selected">selected</xsl:attribute>
                                                    
                                                </xsl:if>

                                                <channel-extension:count/> channels (ChannelSearchProvider)

                                            </option>

                                        </select>

                                    </td>

                                </tr>

                                <tr>
                                    
                                    <td colspan="3">

                                        <input type="hidden" name="reptile.action" value="Search"/>
                                        <input type="hidden" name="reptile.layer" value="Search Results"/>
                                        <input type="submit" value="Search"/>

                                    </td>

                                </tr>
                                
                            </table>        

                    </td>

                    </form>

                    <td width="10"/>
                    
                    <td valign="top" class="reptile-search-control">

                        <form method="get" action="{$reptile.home.location}">
                            
                            <select size="4" name="reptile.search.request">

                                <option value="UnreadArticlesSearchRequest" selected="selected">

                                    <xsl:if test="$request-name = 'UnreadArticlesSearchRequest'">
                                        <xsl:attribute name="selected">selected</xsl:attribute>
                                    </xsl:if>

                                    Unread Articles
                                </option>

                                <option value="RecentArticlesSearchRequest">

                                    <xsl:if test="$request-name = 'RecentArticlesSearchRequest'">
                                        <xsl:attribute name="selected">selected</xsl:attribute>
                                    </xsl:if>

                                    Recent Articles
                                </option>

                                <option value="NewestArticlesSearchRequest">

                                    <xsl:if test="$request-name = 'NewestArticlesSearchRequest'">
                                        <xsl:attribute name="selected">selected</xsl:attribute>
                                    </xsl:if>

                                    Newest Articles
                                </option>

                            </select>

                            <p>

                                <input type="hidden"
                                       name="reptile.action"
                                       value="AdvancedSearch"/>

                                <input type="hidden"
                                       name="reptile.sequence.name"
                                       value="urn:channel-management/maximize"/>

                                <input type="submit" name="submit" value="Search"/>

                            </p>

                        </form>
                        
                    </td>
                    
                </table>

            </center>
            
        </p>

    </xsl:template>

    <xsl:template match="search:results">

        <xsl:call-template name="navigation"/>
        
        <table width="100%">

            <!-- apply the results -->
            
            <xsl:apply-templates/>

        </table>

        <xsl:call-template name="navigation"/>

    </xsl:template>

    <xsl:template match="search:entry">

        <xsl:variable name="location">

            <xsl:value-of select="./search:link/@location"/>

        </xsl:variable>

        <xsl:variable name="contentType">

            <xsl:value-of select="./search:link/@contentType"/>

        </xsl:variable>

        <tr>

            <td>

                <table width="100%" class="reptile-search-entry-title">

                    <!-- FIXME: PUT  channel link here with the title -->
                    
                    <!-- FIXME: COULD WE PUT THE LAYER IF IT IS A SUBSCRIPTION -->

                    <td nowrap="nowrap" width="10">

                        <xsl:choose>

                            <xsl:when test="search:link/@channel != ''">

                                <link-producer:link link-name="urn:view-xml" location="{ search:link/@channel }"/>

                            </xsl:when>
                            
                            <xsl:otherwise>

                                <link-producer:link link-name="urn:view-xml" location="{$location}"/>

                            </xsl:otherwise>

                        </xsl:choose>

                    </td>

                    <td nowrap="nowrap">
                        
                        <b>Last updated: </b> <xsl:value-of select="timestamp:get( ./search:link/@date-found )"/>
                        
                    </td>

                    <xsl:if test="search:link/@channel != ''">
                        
                        <td width="100%" align="right" nowrap="nowrap">

                            <link-producer:link link-name="urn:channel-management/maximize"
                                                title="{ channel-extension:getTitle( search:link/@channel ) }"
                                                location="{ search:link/@channel }"
                                                contentType="{ channel-extension:getContentType( search:link/@channel ) }"/>

                            (
                            <b>

                                <link-producer:link link-name="urn:search/channel-history"
                                                    channel="{search:link/@channel}"/>

                            </b>
                            )

                        </td>

                    </xsl:if>

                </table>
                
            </td>
            
        </tr>

        <tr>

            <td width="100%" bgcolor="white"  class="reptile-search-results-item">

                <table width="100%" height="100%">

                    <td valign="top" width="20">

                        <link-producer:favicon site="{$location}" 
                                               contentType="{$contentType}" 
                                               location="{$location}"
                                               name="{ escape:attributes( dc:title ) }"/>

                    </td>

                    <td valign="top">

                        <xsl:choose>
                            
                            <xsl:when test="search:link/@channel != ''">

                                <!-- FIXME: this should be a channel link -->
                                
                                <img src="{ image:link( channel-extension:getImage( search:link/@channel ) ) }"
                                     align="right"
                                     hspace="10"
                                     vspace="10"/>

                            </xsl:when>

                            <xsl:otherwise>

                                <img src="/reptile/images/channel.png" align="right"/>

                            </xsl:otherwise>
                            
                        </xsl:choose>

                        <!-- ok... display the link to the match.  -->

                        <xsl:choose>

                            <xsl:when test="../../@provider-name = 'ChannelSearchProvider'">

                                <link-producer:channel-management location="{ search:link/@channel }"
                                                                  contentType="{ channel-extension:getContentType( search:link/@channel ) }"
                                                                  name="{ channel-extension:getTitle( search:link/@channel ) }"/>

                            </xsl:when>

                            <xsl:otherwise>

                                <!-- ok.. just display a link to the URL -->
                                
                                <a href="{$location}" target="_new"><xsl:value-of select="dc:title"/></a>

                            </xsl:otherwise>

                        </xsl:choose>
                            
                        <xsl:choose>

                            <xsl:when test="dc:description = ''">

                                <xsl:value-of select="' '"/> <i>No description available.</i>
                                
                            </xsl:when>

                            <xsl:otherwise>

                                <!-- FIXME: sue CSS2 for this spacing -->

                                <xsl:value-of select="concat( ' ', ./dc:description )"/>

                            </xsl:otherwise>

                        </xsl:choose>

                        <p class="reptile-rss-timestamp">

                            Found <timestamp:time_since time="{ search:link/@date-found }"/> ago

                        </p>

                    </td>

                </table>

            </td>

        </tr>

    </xsl:template>

    <xsl:template name="navigation">

        <p>

            <center>
                
                <table>

                    <td align="left">
                        
                        <xsl:if test="@page != 0">

                            <link-producer:link link-name="urn:search/previous-page"
                                                current-page="{@page}"
                                                provider-handle="{../@provider-handle}"/>
                            
                        </xsl:if>
                        
                    </td>

                    <td align="center">

                        <xsl:choose>

                            <xsl:when test="@found &gt; 0">
                                
                                <xsl:value-of select="@start + 1"/> through
                                <xsl:value-of select="@end + 1"/> of about
                                <xsl:value-of select="@found"/>
                                ( <xsl:value-of select="@page + 1"/> / <xsl:value-of select="@total-pages"/> pages )
                                
                            </xsl:when>

                            <xsl:otherwise>

                                No results found.
                                
                            </xsl:otherwise>

                        </xsl:choose>

                    </td>
                    
                    <td align="right">
                        
                        <!-- only display the next if we can actually go forward. -->
                        
                        <xsl:if test="@page + 1 != @total-pages">

                            <link-producer:link link-name="urn:search/next-page"
                                                current-page="{@page}"
                                                provider-handle="{../@provider-handle}"/>
                            
                        </xsl:if>

                    </td>

                </table>

            </center>
            
        </p>

    </xsl:template>

    <xsl:template match="search:search-fields"/>
    <xsl:template match="search:criteria"/>
    <xsl:template match="search:sort-order"/>
    
</xsl:stylesheet>

