<?xml version="1.0"?> 

<!--

$Id: mozilla-search-resolve.xsl,v 1.3 2001/12/18 08:52:22 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

Responsible for rendering Mozilla layout controls.  

See http://reptile.openprivacy.org for more information

-->

<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:dc="http://purl.org/dc/elements/1.1/" 
                xmlns:search-results="http://schemas.openprivacy.org/reptile/search-results"
                xmlns:layout="http://schemas.openprivacy.org/reptile/layout"
                xmlns:escape="xalan://org.openprivacy.reptile.extensions.EscapeExtension"
                xmlns:link-producer="http://schemas.openprivacy.org/reptile/link-producer"
                extension-element-prefixes="escape"
                version="1.0">

    <xsl:output indent="yes"
                omit-xml-declaration="yes"/>

    <xsl:include href="resource:/xsl/misc/copy.xsl"/>

    <xsl:template match="search-results:entry">
    
        <tr>

        <td valign="top">

        <link-producer:favicon site="{search-results:link/@location}"
                               contentType="{../../@contentType}"
                               location="{search-results:link/@contentType}"
                               name="{ escape:attributes( ./dc:title ) }"/>

        </td>

        <td>

            <a href="{search-results:link/@location}" target="_new">
        
                <xsl:value-of select="./dc:title"/>

            </a>

            <span class="reptile-item-list-entry">

            <xsl:value-of select="./dc:description"/>

            </span>

        </td>

        </tr>

    </xsl:template>

</xsl:stylesheet>

