<?xml version="1.0"?> 

<!--

$Id: channel-list.xsl,v 1.9 2001/12/18 08:52:22 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

See http://reptile.openprivacy.org for more information

TODO:

- Use <xsl:sort select="@name"/> to sort the channels like they are originally
displayed.

-->

<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:layout="http://schemas.openprivacy.org/reptile/layout"
                xmlns:page="http://schemas.openprivacy.org/reptile/mozilla/page"
                xmlns:dc="http://purl.org/dc/elements/1.1/" 
                xmlns:control="http://schemas.openprivacy.org/reptile/control"
                xmlns:cl="http://schemas.openprivacy.org/reptile/content-list"
                xmlns:link-producer="http://schemas.openprivacy.org/reptile/link-producer"
                xmlns:logo-producer="http://schemas.openprivacy.org/reptile/logo-producer"
                xmlns:error="http://schemas.openprivacy.org/reptile/error"
                xmlns:escape="xalan://org.openprivacy.reptile.extensions.EscapeExtension"
                extension-element-prefixes="escape"
                version="1.0">

    <xsl:output indent="yes" 
                omit-xml-declaration="yes"/>                

    <xsl:template match="/layout:layout">

        <control:content>

            <dc:title>Quick channel viewer</dc:title>

            <dc:description>
            This control allows you to view channels and jump between them.
            </dc:description>
    
            <control:body>
    
            <xsl:apply-templates/>
    
            </control:body>
        
        </control:content>

    </xsl:template>

    <xsl:template match="cl:content-list">

        <table>

        <xsl:apply-templates/>

        </table>

    </xsl:template>

    <xsl:template match="layout:layer">
    
        <logo-producer:bullet/>
    
        <link-producer:link link-name="urn:subscriptions/layer" name="{@name}"/>
        
        <br/>

        <xsl:apply-templates/>

    </xsl:template>

    <xsl:template match="cl:channel">

        <xsl:comment>

        CHANNEL-LIST begin channel.

        </xsl:comment>

        <xsl:variable name="location">

            <xsl:value-of select="../../@location"/>
        
        </xsl:variable>

        <xsl:variable name="contentType">

            <xsl:value-of select="../../@contentType"/>
        
        </xsl:variable>

        <td width="20">

        </td>

        <td>

            <link-producer:favicon site="{cl:link}" 
                                   contentType="{$contentType}" 
                                   location="{$location}"
                                   title="{ escape:attributes( dc:title ) }"/>


        </td>
        
        <td>

        <xsl:variable name="title" select="./dc:title"/>

        <xsl:variable name="location" select="../../@location"/>

        <xsl:variable name="contentType" select="../../@contentType"/>

        
        <link-producer:channel-management location="{$location}"
                                          contentType="{$contentType}"
                                          name="{$title}"/>

        </td>

    </xsl:template>


    <xsl:template match="dc:title"/>
    <xsl:template match="cl:entry"/>
    
    <!-- we don't care about errors here -->
    <xsl:template match="error:error"/>

    <!-- don't render control bodies...  -->
    <xsl:template match="control:body"/>

</xsl:stylesheet>

