<?xml version="1.0"?> 

<!--

$Id: mozilla-channel-options.xsl,v 1.8 2002/02/08 02:18:48 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

Responsible for rendering Mozilla layout controls.  

See http://reptile.openprivacy.org for more information

-->

<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml" 
                xmlns:dc="http://purl.org/dc/elements/1.1/" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:sub="http://schemas.openprivacy.org/reptile/subscriptions"
                xmlns:control="http://schemas.openprivacy.org/reptile/control"
                xmlns:link-producer="http://schemas.openprivacy.org/reptile/link-producer"
                xmlns:layout="http://schemas.openprivacy.org/reptile/layout"
                xmlns:error="http://schemas.openprivacy.org/reptile/error"
                exclude-result-prefixes="dc transformer sub control error layout link-producer"
                version="1.0">

    <!-- Include any options necessary for any options to operate. -->
    <xsl:template name="include-options">

        <xsl:comment>Include scripts necessary for channel option functionality.</xsl:comment>

        <!-- HACK: Internet explorer and Konq require the script tag to
        terminate -->     

        <script src="/reptile/javascript/mozilla-form.js">.</script>
        <script src="/reptile/javascript/mozilla-options.js">.</script>
        <script src="/reptile/javascript/mozilla-publish.js">.</script>
        <script src="/reptile/javascript/mozilla-view-source.js">.</script>
    
    </xsl:template>

    <!-- Generate all options the given parameter 'location' contains the
    location id for the form to be used. -->
    <xsl:template name="generate-options">

        <xsl:message>asdfasdfasdf</xsl:message>
        
        <xsl:param name="location"/>                

        <!-- only display the options if we actually have a channel that exposes
        options -->

<!--         <xsl:if test="contains( $location, 'http://' ) "> -->

            <td align="right">

                <input type="hidden" name="reptile.sequence.name" value="urn:syndication/publish"/>
                
                <input type="hidden" name="reptile_link" value=""/>
                <input type="hidden" name="reptile_link_title" value=""/>
                <input type="hidden" name="reptile_link_description" value=""/>                

                <select name="reptile_option_select"
                        class="reptile-channel-options"
                        onChange="reptileChannelOptions( this, '{$location}' )">

                    <option value="" checked="true">Choose an option...</option>
                    <option value="" >----</option>

                    <option value="reptilePublish( form )">Publish with weblog</option>
                    <option value="reptileViewSource( form )">View source</option>

                </select>
                
            </td>

<!--         </xsl:if> -->

    </xsl:template>

</xsl:stylesheet>

