<?xml version="1.0"?> 

<!--

$Id: reptile-link-producer.xsl,v 1.45 2002/02/09 22:39:58 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

This stylesheet is a filter which can produce XHTML A links for complicated
references which help drive Reptile.  This allows lower level stylesheets to
generate complicated link in a centralized manner.  All complicated XSLT is kept
in this stylesheet while less complicated XML is kept within the lower
stylesheets.

See http://reptile.openprivacy.org for more information

-->

<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:link-producer="http://schemas.openprivacy.org/reptile/link-producer"
                xmlns:functions="xalan://org.openprivacy.reptile.extensions.Functions"
                xmlns:reputation="xalan://org.openprivacy.reptile.extensions.ReputationExtension"
                xmlns:favicon="xalan://org.openprivacy.reptile.extensions.Favicon"
                xmlns:elp="xalan://org.openprivacy.reptile.extensions.LinkProducer"
                extension-element-prefixes="functions reputation favicon elp"
                version="1.0">

    <xsl:output indent="yes"
                omit-xml-declaration="yes"/>                

    <!-- declare all parameters and provide default values -->
    <xsl:param name="reptile.home.location" select="''"/>

    <xsl:param name="reptile.sequence.name" select="'urn:subscriptions'"/>

    <xsl:param name="reptile.layer" select="''"/>

    <!--
    Match channel-management elements.  Example:

    -->
    <xsl:template name="get-channel-management-url">

        <xsl:param name="location"/>

        <xsl:param name="contentType"/>

        <!-- allows you to override the sequence to use -->
        <xsl:param name="sequence" select="'urn:channel-management'"/>

        <elp:newLink/>

        <elp:value name="reptile.sequence.name" value="urn:channel-management"/>

        <elp:value name="reptile.channel-management.location" value="{$location}"/>

        <elp:value name="reptile.channel-management.contentType" value="{$contentType}"/>

        <xsl:value-of select="elp:getLink()"/>

    </xsl:template>

    <!-- 

    Channel management 

    Example:    

    <link-producer:channel-management location="http://www.slashdot.org/slashdot.rdf"
                                      contentType="http://my.netscape.com/rdf/simple/0.9/"
                                      name="Edit"/>
    -->
    <xsl:template match="link-producer:channel-management">

        <a>

            <xsl:attribute name="href">
            
            <xsl:call-template name="get-channel-management-url">

                <xsl:with-param name="location">
                     <xsl:value-of select="@location"/>
                </xsl:with-param>

                <xsl:with-param name="contentType">
                     <xsl:value-of select="@contentType"/>
                </xsl:with-param>

            </xsl:call-template>

            </xsl:attribute>

            <xsl:value-of select="@name"/>

        </a>

        <xsl:apply-templates/>

    </xsl:template>

    <!--
    Match 'read-marks' elements.  Example:

    <link-producer:read-marks location="http://www.slashdot.org/slashdot.rdf"
                    contentType="http://my.netscape.com/rdf/simple/0.9/"
                    name="Read"/>

    More info can be found in the 'read-marks' channel feature.

    -->
    <xsl:template match="link-producer:read-marks">

        <elp:newLink/>

        <elp:value name="reptile.feature.read-marks.location" value="{@location}"/>

        <elp:value name="reptile.feature.read-marks.contentType" value="{@contentType}"/>

        <elp:value name="reptile.action" value="UpdateReadMarks"/>

        <elp:value name="reptile.feature.read-marks.operation" value="{@name}"/>

        <elp:value name="reptile.action.next.sequence" value="{$reptile.sequence.name}"/>

        <elp:value name="reptile.action.next.layer" value="{$reptile.layer}"/>
                                               
        <elp:value name="reptile.layer" value="{$reptile.layer}"/>

        <!-- optional params when we are in channel management -->

        <elp:param name="reptile.channel-management.contentType"/>

        <elp:param name="reptile.channel-management.location"/>

        <a href="{elp:getLink()}">

            <xsl:value-of select="@name"/>

        </a>

    </xsl:template>

    <xsl:template name="link-producer:logout">

        <elp:newLink/>

        <elp:value name="reptile.action" value="Logout"/>

        <a href="{elp:getLink()}">Logout</a>

    </xsl:template>

    <!-- Generate links to the logout URL -->
    <xsl:template match="link-producer:logout">

        <xsl:call-template name="link-producer:logout"/>
    
    </xsl:template>

    <xsl:template name="link-producer:tools">

        <elp:newLink/>

        <elp:value name="reptile.sequence.name" value="urn:navigation/tools"/>

        <a href="{elp:getLink()}">Tools</a>

    </xsl:template>

    <!-- Generate links to the tools URL -->
    <xsl:template match="link-producer:tools">

        <xsl:call-template name="link-producer:tools"/>

    </xsl:template>

    <xsl:template name="link-producer:publish">

        <elp:newLink/>

        <elp:value name="reptile.sequence.name" value="urn:syndication/publish"/>

        <elp:value name="reptile.layer" value="Preview"/>
        
        <a href="{elp:getLink()}">Weblog</a>

    </xsl:template>

    <xsl:template match="link-producer:publish">

        <xsl:call-template name="link-producer:publish"/>

    </xsl:template>

    <xsl:template name="link-producer:about">

        <elp:newLink/>
                  
        <elp:value name="reptile.sequence.name" value="urn:about"/>

        <a href="{elp:getLink()}">About</a>

    </xsl:template>

    <xsl:template match="link-producer:about">

        <xsl:call-template name="link-producer:about"/>

    </xsl:template>

    <xsl:template name="link-producer:settings">

        <elp:newLink/>
                  
        <elp:value name="reptile.sequence.name" value="urn:settings"/>

        <a href="{elp:getLink()}">Settings</a>

    </xsl:template>

    <xsl:template name="link-producer:license">

        <elp:newLink/>
                  
        <elp:value name="reptile.sequence.name" value="urn:license"/>

        <a href="{elp:getLink()}">License</a>

    </xsl:template>

    <xsl:template match="link-producer:settings">

        <xsl:call-template name="link-producer:settings"/>

    </xsl:template>

    <xsl:template name="link-producer:my-subscriptions">

        <a>

            <xsl:attribute name="href">
            
                <xsl:value-of select="$reptile.home.location"/>

            </xsl:attribute>
            
            My Subscriptions</a>

    </xsl:template>

    <!-- Generate links to the home URL -->
    <xsl:template match="link-producer:my-subscriptions">

        <xsl:call-template name="link-producer:my-subscriptions"/>

    </xsl:template>

    <!-- get-reputation operations -->
    <xsl:template match="link-producer:get-reputation">

        <elp:newLink/>
                  
        <elp:value name="reptile.sequence.name" value="urn:reputation-management"/>
        <elp:value name="identifier" value="{@identifier}"/>

        <table cellspacing="0" cellpadding="0">

            <td>

                <img src="/reptile/images/reputation.png" border="0" hspace="3"/>

            </td>            

            <td nowrap="true">

                <a href="{elp:getLink()}">Reputation: </a>

            </td>

            <td nowrap="true">

                <xsl:value-of select="reputation:getReputation( string( ./@identifier ) )"/>

            </td>

        </table>

    </xsl:template>

    <!-- 
    
    Example:

    <link-producer:favicon site="" location="" contentType="" name=""/>

    Where:
    
    - location is the URL on the site you want to display.
    
    - name is the name of the channel this favicon is in.

    -->
    <xsl:template match="link-producer:favicon">

        <!--  
        
        Favicons can be in 64 x 64 or 32 x 32 or 16 x 16.  We are using 16 x 16
        so that they can be displayeed in a smaller box.
        
        -->

        <a>

            <xsl:attribute name="href">

                <xsl:call-template name="get-channel-management-url">
    
                    <xsl:with-param name="location">
                         <xsl:value-of select="@location"/>
                    </xsl:with-param>
    
                    <xsl:with-param name="contentType">
                         <xsl:value-of select="@contentType"/>
                    </xsl:with-param>
    
                </xsl:call-template>

            </xsl:attribute>
            
            <!--

            When we have favicon's working under Mozilla, we can start to add
            alt tags.
            
            alt="{@name}"

            -->

            <img border="0" width="16" height="16" hspace="10" vspace="2">
    
                <xsl:attribute name="src">
    
                    <xsl:value-of select="favicon:get( @site )"/>
    
                </xsl:attribute>
    
            </img>

        </a>

    </xsl:template>

    <!-- Generate a link to maximize a control.  If you provide an attribute of
    @title this will be used as the title, else 'Max' -->
    <xsl:template match="link-producer:link[@link-name = 'urn:channel-management/maximize']">

        <elp:newLink/>

        <elp:include/>

        <elp:value name="reptile.sequence.name" value="urn:channel-management/maximize"/>

        <elp:value name="reptile.channel-management.location" value="{@location}"/>

        <elp:value name="reptile.channel-management.contentType" value="{@contentType}"/>

        <elp:value name="reptile.channel-management.title" value="{@title}"/>

        <xsl:choose>

             <xsl:when test="@title = ''">

                <a href="{elp:getLink()}">Max</a>

             </xsl:when>

             <xsl:otherwise>

                <a href="{elp:getLink()}"><xsl:value-of select="@title"/></a>

             </xsl:otherwise>

        </xsl:choose>

    </xsl:template>

    <xsl:template match="link-producer:link[@link-name = 'urn:channel-management/delete']">

        <elp:newLink/>

        <elp:value name="reptile.channel-management.location" value="{@location}"/>

        <elp:value name="reptile.update_content.resource" value="resource:/xml/users/default/subscriptions.xml"/>

        <elp:value name="reptile.update_content.sequence" value="urn:channel-management/delete"/>

        <elp:value name="reptile.action" value="UpdateContent"/>

        <elp:value name="reptile.action.next.layer" value="{$reptile.layer}"/>

        <elp:value name="reptile.action.next.sequence" value="urn:subscriptions"/>

        <a href="{elp:getLink()}">Delete</a>

    </xsl:template>

    <!--  view a layer under subscriptions  -->
    <xsl:template match="link-producer:link[@link-name = 'urn:subscriptions/layer']">

        <elp:newLink/>

        <elp:value name="reptile.sequence.name" value="urn:subscriptions"/>

        <elp:value name="reptile.layer" value="{@name}"/>

        <a href="{elp:getLink()}"><xsl:value-of select="@name"/></a>

    </xsl:template>

    <xsl:template name="link-producer:quick-channel/item-list/full">

        <elp:newLink/>

        <!-- 
        This is uses the urn:channel-management/maximize feature.  See this link
        for more information.
        -->

        <elp:value name="reptile.sequence.name" value="urn:channel-management/maximize"/>

        <elp:value name="reptile.channel-management.location" value="urn:quick-channel/item-list/full"/>

        <elp:value name="reptile.channel-management.contentType" value="http://schemas.openprivacy.org/reptile/stylesheet-sequence"/>

        <elp:value name="reptile.channel-management.title" value="Unread Articles"/>
    
        <a href="{elp:getLink()}">Unread Articles</a>

    </xsl:template>

    <!--  view a full item list  -->
    <xsl:template match="link-producer:link[@link-name = 'urn:quick-channel/item-list/full']">

        <xsl:call-template name="link-producer:quick-channel/item-list/full"/>

    </xsl:template>

    <!-- 

    Given a resource URL, get the local file which is backing it up. This
    basically produces valid links for a given resource.

    Example:
    
    <link-producer:link link-name="urn:reptile/link/resource"
                        resource="resource:/images/logo.png"/>

    -->
    <xsl:template match="link-producer:link[@link-name = 'urn:reptile/link/resource']">
    
<!--          <xsl:value-of select="proxy:getFileLocation( @resource )"/> -->

    </xsl:template>

    <!-- Create the ability to make a link so that the user can 'view source' on
    a specific URL.  Example:

    <link-producer:link link-name="urn:view-source"
                        location="http://site"
                        name="View source"/>

    -->
    <xsl:template match="link-producer:link[@link-name = 'urn:view-source']">

        <a href="view-source:{@location}" type="text/plain" target="_new">

           <xsl:value-of select="@name"/>

        </a>

    </xsl:template>

    <xsl:template match="link-producer:link[@link-name = 'urn:view-xml']">

        <a href="view-source:{@location}" type="text/plain" alt="{@name}" target="_new">

           <img src="/reptile/images/xml.png" border="0"/>

        </a>

    </xsl:template>

    <xsl:template match="link-producer:view-layer">

            <elp:newLink/>
                  
            <elp:value name="reptile.layer" value="{@name}"/>

            <elp:param name="reptile.sequence.name"/>

            <!-- optional params when we are in channel management -->

            <elp:param name="reptile.channel-management.contentType"/>

            <elp:param name="reptile.channel-management.location"/>

            <a href="{elp:getLink()}">

                <xsl:value-of select="@name"/> 

            </a>

    </xsl:template>

    <xsl:template name="link-producer:advanced-search">

        <elp:newLink/>

        <!-- 
        This is uses the urn:channel-management/maximize feature.  See this link
        for more information.
        -->

        <elp:value name="reptile.sequence.name" value="urn:channel-management/maximize"/>

        <elp:value name="reptile.channel-management.location" value="urn:search/channels/advanced"/>

        <elp:value name="reptile.channel-management.contentType" value="http://schemas.openprivacy.org/reptile/stylesheet-sequence"/>

        <elp:value name="reptile.channel-management.title" value="Advanced search"/>
    
        <a href="{elp:getLink()}">Advanced Search</a>

    </xsl:template>

    <!-- link to a page which allows us to do an 'Advanced search' -->
    <xsl:template match="link-producer:link[@link-name = 'urn:advanced-search']">

        <xsl:call-template name="link-producer:advanced-search"/>

    </xsl:template>

    <xsl:template name="link-producer:browse">

        <elp:newLink/>

        <!-- 
        This is uses the urn:channel-management/maximize feature.  See this link
        for more information.
        -->

        <elp:value name="reptile.sequence.name" value="urn:channel-management/maximize"/>

        <elp:value name="reptile.channel-management.location" value="urn:browse"/>

        <elp:value name="reptile.channel-management.contentType" value="http://schemas.openprivacy.org/reptile/stylesheet-sequence"/>

        <elp:value name="reptile.channel-management.title" value="Browse"/>
    
        <a href="{elp:getLink()}">Browse</a>

    </xsl:template>

    <!-- link to a page which allows us to do an 'browse' of known content -->
    <xsl:template match="link-producer:link[@link-name = 'urn:browse']">

        <xsl:call-template name="link-producer:browse"/>

    </xsl:template>

    <!-- 
    Used to render a 'quickbar' control.  Basically this is just a bar at the
    top of a browser with two frames.  One on the remote URL and one that lets
    you interact with Reptile.
    -->
    <xsl:template match="link-producer:link[@link-name = 'urn:quickbar']">

        <elp:newLink/>

        <elp:value name="reptile.sequence.name" value="urn:quickbar"/>

        <elp:value name="reptile.quickbar.location" value="{@location}"/>

        <a href="{elp:getLink()}"><xsl:value-of select="@title"/></a>

    </xsl:template>

    <!--
         
         <link-producer:link link-name="urn:search/next-page"
                             current-page="0"
                             provider-handle="1012962724"/>

         Navigate forward one page.
         
    -->
         
    <xsl:template match="link-producer:link[@link-name = 'urn:search/next-page']">

        <elp:newLink/>

        <elp:value name="reptile.sequence.name" value="urn:search-serialize/page"/>

        <elp:value name="reptile.search.page" value="{@current-page + 1}"/>

        <elp:value name="reptile.search.provider.handle" value="{@provider-handle}"/>
        
        <a href="{elp:getLink()}">Next page</a><b> &gt; &gt; </b>

    </xsl:template>

    <!--
         
         <link-producer:link link-name="urn:search/previous-page"
                             current-page="0"
                             provider-handle="1012962724"/>

         Navigate backward one page.
         
    -->
         
    <xsl:template match="link-producer:link[@link-name = 'urn:search/previous-page']">

        <elp:newLink/>

        <elp:value name="reptile.sequence.name" value="urn:search-serialize/page"/>

        <elp:value name="reptile.search.page" value="{@current-page - 1}"/>

        <elp:value name="reptile.search.provider.handle" value="{@provider-handle}"/>
        
        <b>&lt; &lt; </b><a href="{elp:getLink()}">Previous page </a>

    </xsl:template>

    <!--
         
         <link-producer:link link-name="urn:search/channel-history"
                             channel="http://www.slashdot.org/slashdot.rdf"/>

         View the channel history for the given channel.
         
    -->
         
    <xsl:template match="link-producer:link[@link-name = 'urn:search/channel-history']">

        <elp:newLink/>

        <elp:value name="reptile.sequence.name" value="urn:search-request/channel-history/page"/>

        <elp:value name="reptile.search.channel" value="{@channel}"/>

        <a href="{elp:getLink()}">History</a>

    </xsl:template>

</xsl:stylesheet>

