<?xml version="1.0"?> 

<!--

$Id: rss-0.90-uplevel.xsl,v 1.5 2002/02/08 01:05:53 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

This stylesheet is designed to render RSS 0.90 content into an RSS 1.0 format.

The RSS 0.90 specification is located here:

http://www.purplepages.ie/RSS/netscape/rss0.90.html

-->

<xsl:stylesheet xmlns:downlevel="http://my.netscape.com/rdf/simple/0.9/"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
                xmlns:dc="http://purl.org/dc/elements/1.1/"
                xmlns:uplevel="http://purl.org/rss/1.0/"
                version="1.0">

    <xsl:output indent="yes" 
                encoding="ISO-8859-1"
                omit-xml-declaration="no"/>

    <xsl:template match="/rdf:RDF">

        <rdf:RDF>

            <xsl:apply-templates/>

        </rdf:RDF>

    </xsl:template>

    <xsl:template match="downlevel:channel">

        <uplevel:channel>

            <uplevel:title><xsl:value-of select="downlevel:title"/></uplevel:title>
    
            <uplevel:link><xsl:value-of select="downlevel:link"/></uplevel:link>
    
            <uplevel:description><xsl:value-of select="downlevel:description"/></uplevel:description>

            <xsl:apply-templates select="/rdf:RDF/downlevel:image"/>

        </uplevel:channel>

    </xsl:template>

    <xsl:template match="downlevel:image">

        <uplevel:image rdf:about="{downlevel:link}">

            <uplevel:title><xsl:value-of select="downlevel:title"/></uplevel:title>

            <uplevel:link><xsl:value-of select="downlevel:link"/></uplevel:link>
    
            <uplevel:url><xsl:value-of select="downlevel:url"/></uplevel:url>

            <xsl:apply-templates/>

        </uplevel:image>

    </xsl:template>

    <xsl:template match="downlevel:item">

        <uplevel:item>

            <uplevel:title><xsl:value-of select="downlevel:title"/></uplevel:title>
    
            <uplevel:link><xsl:value-of select="downlevel:link"/></uplevel:link>
    
            <uplevel:description><xsl:value-of select="downlevel:description"/></uplevel:description>

            <xsl:apply-templates/>

        </uplevel:item>

    </xsl:template>

    <xsl:template match="downlevel:textinput">

        <uplevel:textinput rdf:about="{downlevel:link}">

            <uplevel:title><xsl:value-of select="downlevel:title"/></uplevel:title>

            <uplevel:link><xsl:value-of select="downlevel:link"/></uplevel:link>

            <uplevel:name><xsl:value-of select="downlevel:name"/></uplevel:name>

            <uplevel:description><xsl:value-of select="downlevel:description"/></uplevel:description>

            <xsl:apply-templates/>

        </uplevel:textinput>

    </xsl:template>    

</xsl:stylesheet>

