<?xml version="1.0"?> 

<!--

$Id: process.xsl,v 1.26 2001/12/21 09:56:16 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

This stylesheet will process a subscription URL and include control markup so
that we can render it as a Control.  Next a brower/platform specific XSLT will
render this control.  

See http://reptile.openprivacy.org for additional information.

-->

<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml" 
                xmlns:dc="http://purl.org/dc/elements/1.1/" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:layout="http://schemas.openprivacy.org/reptile/layout"
                xmlns:control="http://schemas.openprivacy.org/reptile/control"
                xmlns:transformer="xalan://org.openprivacy.reptile.extensions.ContentTransformer"
                xmlns:proxy="xalan://org.openprivacy.reptile.extensions.ProxyFunctions"
                xmlns:error="http://schemas.openprivacy.org/reptile/error"
                extension-element-prefixes="transformer proxy"
                exclude-result-prefixes="transformer layout"
                version="1.0">

    <!-- by default, copy all matching templates -->
    <xsl:include href="resource:/xsl/misc/copy.xsl"/>

    <xsl:output indent="yes" encoding="ISO-8859-1"/>                

    <xsl:param name="outputFormat" select="'http://schemas.openprivacy.org/reptile/control/subset'"/>

    <xsl:template match="layout:content">

        <transformer:init/>

        <control:control>    

            <!-- forward the content information.  We need to strip this from
            within the control -->
            <layout:content location="{@location}" 
                            contentType="{@contentType}">

                <layout:position column="{./layout:position/@column}" layer="{./layout:position/@layer}"/>

            </layout:content>

            <control:location><xsl:value-of select="./@location"/></control:location>

            <control:contentType><xsl:value-of select="./@contentType"/></control:contentType>

            <!-- We need to be specific here. If the content is in the proxy (
            and is supported) we can render it.  If not we should tell the user
            this and then try to update it.  -->

            <xsl:choose>

                <xsl:when test="proxy:supports( @location ) and proxy:contains( @location ) = false"> 

                    <control:content>
                  
                        <control:link><xsl:value-of select="@location"/></control:link>

                        <dc:title>Channel not available.</dc:title>

                        <control:body>

                        <error:error type="error">
    
                            <!-- FIXME: move this over to an error --> 

                            The channel specified is currently not available but
                            will be shortly (you may need to refresh your
                            browser).  It is being requested now.  Note that if
                            this URL is invalid, this error may be permanent.
    
                        </error:error>

                        <!-- force an update -->
                        <xsl:value-of select="proxy:update( @location )"/>

                        <p>
                        
                            <control:feature name="urn:view-source" location="{@location}"/>

                        </p>
                        
                        </control:body>

                    </control:content>

                </xsl:when>

                <xsl:otherwise>

                    <xsl:value-of select="transformer:transform( ./@location, @contentType, $outputFormat )" disable-output-escaping="yes"/>

                </xsl:otherwise>

            </xsl:choose>

        </control:control>    

    </xsl:template>

</xsl:stylesheet>

