<?xml version="1.0"?>

<!--

$Id: meta-update.xsl,v 1.9 2002/02/09 05:55:48 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
                xmlns:dc="http://purl.org/dc/elements/1.1/"
                xmlns:rss="http://purl.org/rss/1.0/"
                xmlns:cl="http://schemas.openprivacy.org/reptile/content-list"
                xmlns:valid-item="xalan://org.openprivacy.reptile.extensions.ValidItem"
                xmlns:meta-update="xalan://org.openprivacy.reptile.metaupdate.extensions.MetaUpdateExtension"
                extension-element-prefixes="valid-item meta-update"
                version="1.0">

    <xsl:output indent="yes"
                omit-xml-declaration="yes"/>

    <xsl:param name="location" select="''"/>

    <xsl:param name="inputFormat" select="''"/>

    <xsl:template match="/rdf:RDF">

        <meta-update:channel location="{$location}"
                             site="{rss:channel/rss:link}"
                             contentType="{$inputFormat}"
                             title="{rss:channel/rss:title}"
                             image="{rss:channel/rss:image/rss:url}"
                             description="{rss:channel/rss:description}"/>

        <xsl:apply-templates select="./rss:item"/>

    </xsl:template>

    <xsl:template match="/rdf:RDF/rss:item">

        <meta-update:article location="{rss:link}"
                             title="{rss:title}"
                             description="{rss:description}"
                             channel="{$location}"/>

    </xsl:template>

</xsl:stylesheet>