<?xml version="1.0"?> 

<!--

$Id: mozilla-system-property-edit.xsl,v 1.3 2002/02/05 04:54:03 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

Responsible for rendering Mozilla layout controls.  

See http://reptile.openprivacy.org for more information

-->

<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:control="http://schemas.openprivacy.org/reptile/control"
                xmlns:dc="http://purl.org/dc/elements/1.1/" 
                xmlns:bootstrap="http://schemas.openprivacy.org/reptile/bootstrap"
                xmlns:cache="xalan://org.openprivacy.reptile.extensions.admin.SequenceCacheExtension"
                xmlns:properties="xalan://org.openprivacy.reptile.extensions.JVMProperties"
                extension-element-prefixes="cache"
                version="1.0">

    <xsl:output indent="yes"
                omit-xml-declaration="yes"/>

    <xsl:param name="reptile.action" select="''"/>

    <xsl:template match="/bootstrap:bootstrap">

        <control:content>
    
            <dc:title>Edit important system properties</dc:title>
    
            <control:body>

            <p>This control can be used to edit important Java system properties.</p>
    
            <xsl:call-template name="debug-sequence-engine"/>

            </control:body>

        </control:content>

    </xsl:template>

    <xsl:template name="debug-sequence-engine">

        <fieldset>

            <legend>Debug sequence engine.</legend>

            <form>

            <p>
            This is used to toggle the 'reptile.sequence.debug.enabled' System
            property.  Keeping this off <i>will increase</i> performance.
            </p>

            <p>
            Note that this only supports StylesheetEngine implementations that
            support debugging.
            </p>

            <p>

            The current value is:

            <xsl:value-of select="properties:getProperty( 'reptile.sequence.debug.enabled' )"/>

            </p>

            <table width="100%">

            <td align="right">

                <input type="submit" value="Toggle reptile.sequence.debug.enabled"/>
                
            </td>
            
            </table>

            <input type="hidden" name="reptile.action" value="ToggleSystemProperty"/>

            <input type="hidden" name="property" value="reptile.sequence.debug.enabled"/>

            <input type="hidden" name="reptile.action.next.layer" value="{$reptile.action}"/>
             
            <input type="hidden" name="reptile.action.next.sequence" value="urn:settings"/>

            </form>

        </fieldset>
    
    </xsl:template>

</xsl:stylesheet>

