/*
 * Decompiled with CFR 0.152.
 */
package talon.references;

import talon.Component;
import talon.ComponentHandle;
import talon.references.ReferenceFactory;
import talon.util.net.URI;

public class TypeReferenceFactory
extends ReferenceFactory {
    public static URI getTypeReference(Component component) {
        ComponentHandle handle = component.getComponentHandle();
        String interfaceURIPart = ReferenceFactory.buildInterfaceURIPart(ReferenceFactory.getInterfaces(component.getClass()));
        return TypeReferenceFactory.getTypeReference(component.getClass().getName(), interfaceURIPart);
    }

    public static URI getTypeReference(ComponentHandle handle) {
        try {
            Class<?> clazz = Class.forName(handle.getImplementation());
            Class[] interfaces = ReferenceFactory.getInterfaces(clazz);
            return TypeReferenceFactory.getTypeReference(handle.getImplementation(), ReferenceFactory.buildInterfaceURIPart(interfaces));
        }
        catch (Throwable t) {
            return TypeReferenceFactory.getTypeReference(handle.getImplementation(), "/interface/" + handle.getInterface());
        }
    }

    public static URI getTypeReference(Class clazz) {
        Class[] interfaces = ReferenceFactory.getInterfaces(clazz);
        return TypeReferenceFactory.getTypeReference(clazz.getName(), ReferenceFactory.buildInterfaceURIPart(interfaces));
    }

    protected static URI getTypeReference(String implementation, String interfaceURIPart) {
        return new URI("talon:///type-reference/component/" + implementation + interfaceURIPart);
    }
}

