/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.Vector;
import org.apache.cactus.Cookie;
import org.apache.cactus.WebRequest;
import org.apache.cactus.client.HttpClientHelper;
import org.apache.cactus.util.ChainedRuntimeException;
import org.apache.cactus.util.log.Log;
import org.apache.cactus.util.log.LogService;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpException;

public class WebResponse {
    private static Log logger = LogService.getInstance().getLog((class$org$apache$cactus$WebResponse == null ? (class$org$apache$cactus$WebResponse = WebResponse.class$("org.apache.cactus.WebResponse")) : class$org$apache$cactus$WebResponse).getName());
    private HttpURLConnection connection;
    private WebRequest request;
    private String content;
    static /* synthetic */ Class class$org$apache$cactus$WebResponse;

    public WebResponse(WebRequest theRequest, HttpURLConnection theConnection) {
        this.request = theRequest;
        this.connection = theConnection;
    }

    public HttpURLConnection getConnection() {
        return this.connection;
    }

    public WebRequest getWebRequest() {
        return this.request;
    }

    /*
     * WARNING - void declaration
     */
    public String getText() {
        if (this.content == null) {
            StringBuffer sb = new StringBuffer();
            try {
                int nb;
                BufferedReader input = new BufferedReader(new InputStreamReader(this.connection.getInputStream()));
                char[] buffer = new char[2048];
                while (-1 != (nb = input.read(buffer, 0, 2048))) {
                    void var4_5;
                    sb.append(buffer, 0, (int)var4_5);
                }
                input.close();
            }
            catch (IOException e) {
                throw new ChainedRuntimeException(e);
            }
            this.content = sb.toString();
        }
        return this.content;
    }

    /*
     * WARNING - void declaration
     */
    public String[] getTextAsArray() {
        Vector<void> lines = new Vector<void>();
        try {
            String str;
            if (this.content == null) {
                this.getText();
            }
            BufferedReader input = new BufferedReader(new StringReader(this.content));
            while (null != (str = input.readLine())) {
                void var3_4;
                lines.addElement(var3_4);
            }
            input.close();
        }
        catch (IOException e) {
            throw new ChainedRuntimeException(e);
        }
        String[] dummy = new String[lines.size()];
        return lines.toArray(dummy);
    }

    public InputStream getInputStream() {
        try {
            return this.connection.getInputStream();
        }
        catch (IOException e) {
            throw new ChainedRuntimeException(e);
        }
    }

    public Cookie getCookie(String theName) {
        Cookie result = null;
        Cookie[] cookies = this.getCookies();
        int i = 0;
        while (i < cookies.length) {
            if (cookies[i].getName().equals(theName)) {
                result = cookies[i];
                break;
            }
            ++i;
        }
        return result;
    }

    public Cookie[] getCookies() {
        logger.entry("getCookies()");
        Object[] returnCookies = null;
        String headerName = ((URLConnection)this.connection).getHeaderFieldKey(0);
        String headerValue = ((URLConnection)this.connection).getHeaderField(0);
        Vector<Cookie> cookieVector = new Vector<Cookie>();
        int i = 1;
        while (headerName != null || headerValue != null) {
            logger.debug("Header name  = [" + headerName + "]");
            logger.debug("Header value = [" + headerValue + "]");
            if (headerName != null && (headerName.toLowerCase().equals("set-cookie") || headerName.toLowerCase().equals("set-cookie2"))) {
                org.apache.commons.httpclient.Cookie[] cookies;
                try {
                    cookies = org.apache.commons.httpclient.Cookie.parse((String)HttpClientHelper.getDomain(this.getWebRequest(), this.getConnection()), (Header)new Header(headerName, headerValue));
                }
                catch (HttpException e) {
                    throw new ChainedRuntimeException("Error parsing cookies", e);
                }
                int j = 0;
                while (j < cookies.length) {
                    Cookie cookie = new Cookie(cookies[j].getDomain(), cookies[j].getName(), cookies[j].getValue());
                    cookie.setComment(cookies[j].getComment());
                    cookie.setExpiryDate(cookies[j].getExpiryDate());
                    cookie.setPath(cookies[j].getPath());
                    cookie.setSecure(cookies[j].getSecure());
                    cookieVector.addElement(cookie);
                    ++j;
                }
            }
            headerName = ((URLConnection)this.connection).getHeaderFieldKey(i);
            headerValue = ((URLConnection)this.connection).getHeaderField(i);
            ++i;
        }
        returnCookies = new Cookie[cookieVector.size()];
        cookieVector.copyInto(returnCookies);
        logger.exit("getCookies");
        return returnCookies;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

