/*
 * Decompiled with CFR 0.152.
 */
package tyrex.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import tyrex.jdbc.TyrexConnection;
import tyrex.jdbc.TyrexConnectionListener;
import tyrex.jdbc.TyrexResultSetImpl;

class TyrexStatementImpl
implements Statement,
TyrexConnectionListener {
    private TyrexConnection _connection;
    private Statement _statement;
    private TyrexResultSetImpl _resultSet;

    TyrexStatementImpl(Statement statement, TyrexConnection tyrexConnection) throws SQLException {
        if (statement == null) {
            throw new IllegalArgumentException("The argument 'statement' is null.");
        }
        if (tyrexConnection == null) {
            throw new IllegalArgumentException("The argument 'connection' is null.");
        }
        this._connection = tyrexConnection;
        this._statement = statement;
        tyrexConnection.addListener(this);
    }

    public final synchronized void addBatch(String string) throws SQLException {
        this.getStatement().addBatch(string);
    }

    public final synchronized void cancel() throws SQLException {
        this.getStatement().cancel();
    }

    public final synchronized void clearBatch() throws SQLException {
        this.getStatement().clearBatch();
    }

    public final synchronized void clearWarnings() throws SQLException {
        this.getStatement().clearWarnings();
    }

    public final synchronized void close() throws SQLException {
        this.internalClose(true);
    }

    protected void closeResultSet() {
        block2: {
            if (this._resultSet == null) break block2;
            try {
                TyrexResultSetImpl tyrexResultSetImpl = this._resultSet;
                this._resultSet = null;
                tyrexResultSetImpl.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    public final synchronized void connectionClosed() {
        if (this._statement != null) {
            try {
                this.internalClose(false);
            }
            catch (SQLException sQLException) {}
            this._statement = null;
        }
    }

    public final boolean execute(String string) throws SQLException {
        Statement statement;
        TyrexStatementImpl tyrexStatementImpl = this;
        synchronized (tyrexStatementImpl) {
            statement = this.getStatement();
        }
        return statement.execute(string);
    }

    public final int[] executeBatch() throws SQLException {
        Statement statement;
        TyrexStatementImpl tyrexStatementImpl = this;
        synchronized (tyrexStatementImpl) {
            statement = this.getStatement();
        }
        return statement.executeBatch();
    }

    public final ResultSet executeQuery(String string) throws SQLException {
        Statement statement;
        TyrexStatementImpl tyrexStatementImpl = this;
        synchronized (tyrexStatementImpl) {
            statement = this.getStatement();
            this.closeResultSet();
        }
        return this.setResultSet(statement.executeQuery(string));
    }

    public final int executeUpdate(String string) throws SQLException {
        Statement statement;
        TyrexStatementImpl tyrexStatementImpl = this;
        synchronized (tyrexStatementImpl) {
            statement = this.getStatement();
        }
        return statement.executeUpdate(string);
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public final Connection getConnection() throws SQLException {
        return this._connection;
    }

    public final synchronized int getFetchDirection() throws SQLException {
        return this.getStatement().getFetchDirection();
    }

    public final synchronized int getFetchSize() throws SQLException {
        return this.getStatement().getFetchSize();
    }

    public final synchronized int getMaxFieldSize() throws SQLException {
        return this.getStatement().getMaxFieldSize();
    }

    public final synchronized int getMaxRows() throws SQLException {
        return this.getStatement().getMaxRows();
    }

    public final synchronized boolean getMoreResults() throws SQLException {
        return this.getStatement().getMoreResults();
    }

    public final synchronized int getQueryTimeout() throws SQLException {
        return this.getStatement().getQueryTimeout();
    }

    public final ResultSet getResultSet() throws SQLException {
        Statement statement;
        TyrexStatementImpl tyrexStatementImpl = this;
        synchronized (tyrexStatementImpl) {
            statement = this.getStatement();
            this.closeResultSet();
        }
        return this.setResultSet(statement.getResultSet());
    }

    public final synchronized int getResultSetConcurrency() throws SQLException {
        return this.getStatement().getResultSetConcurrency();
    }

    public final synchronized int getResultSetType() throws SQLException {
        return this.getStatement().getResultSetType();
    }

    protected final Statement getStatement() throws SQLException {
        if (this._statement == null) {
            throw new SQLException("The statement has been closed.");
        }
        return this._statement;
    }

    public final synchronized int getUpdateCount() throws SQLException {
        return this.getStatement().getUpdateCount();
    }

    public final synchronized SQLWarning getWarnings() throws SQLException {
        return this.getStatement().getWarnings();
    }

    private void internalClose(boolean bl) throws SQLException {
        if (this._statement == null) {
            throw new SQLException("The statement is already closed");
        }
        this.closeResultSet();
        try {
            this._statement.close();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (bl) {
                try {
                    this._connection.removeListener(this);
                }
                catch (Exception exception) {}
            }
            this._statement = null;
            this._connection = null;
            throw throwable;
        }
        Object var3_2 = null;
        if (bl) {
            try {
                this._connection.removeListener(this);
            }
            catch (Exception exception) {}
        }
        this._statement = null;
        this._connection = null;
    }

    final synchronized void resultSetIsClosed(TyrexResultSetImpl tyrexResultSetImpl) {
        if (tyrexResultSetImpl == this._resultSet) {
            this._resultSet = null;
        }
    }

    public final synchronized void setCursorName(String string) throws SQLException {
        this.getStatement().setCursorName(string);
    }

    public final synchronized void setEscapeProcessing(boolean bl) throws SQLException {
        this.getStatement().setEscapeProcessing(bl);
    }

    public final synchronized void setFetchDirection(int n) throws SQLException {
        this.getStatement().setFetchDirection(n);
    }

    public final synchronized void setFetchSize(int n) throws SQLException {
        this.getStatement().setFetchSize(n);
    }

    public final synchronized void setMaxFieldSize(int n) throws SQLException {
        this.getStatement().setMaxFieldSize(n);
    }

    public final synchronized void setMaxRows(int n) throws SQLException {
        this.getStatement().setMaxRows(n);
    }

    public final synchronized void setQueryTimeout(int n) throws SQLException {
        this.getStatement().setQueryTimeout(n);
    }

    protected synchronized ResultSet setResultSet(ResultSet resultSet) {
        this._resultSet = resultSet == null ? null : (resultSet instanceof TyrexResultSetImpl ? (TyrexResultSetImpl)resultSet : new TyrexResultSetImpl(resultSet, this));
        return this._resultSet;
    }
}

