/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.velocity;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Vector;
import javax.servlet.ServletConfig;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.pull.TurbinePull;
import org.apache.turbine.services.servlet.TurbineServlet;
import org.apache.turbine.services.template.BaseTemplateEngineService;
import org.apache.turbine.services.velocity.VelocityService;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.StringUtils;
import org.apache.turbine.util.TurbineConfig;
import org.apache.turbine.util.TurbineException;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.configuration.Configuration;

public class TurbineVelocityService
extends BaseTemplateEngineService
implements VelocityService {
    private String defaultCharSet = "ISO-8859-1";
    private Context globalContext = null;
    private boolean pullModelActive = false;
    private boolean refreshToolsPerRequest = false;

    public void init(ServletConfig config) throws InitializationException {
        try {
            this.initVelocity();
            this.globalContext = null;
            if (TurbinePull.isRegistered()) {
                this.globalContext = TurbinePull.getGlobalContext();
                this.pullModelActive = true;
                this.refreshToolsPerRequest = TurbinePull.refreshToolsPerRequest();
            }
            if (this.globalContext == null) {
                this.globalContext = new VelocityContext();
            }
            this.registerConfiguration("vm");
            this.setInit(true);
        }
        catch (Exception e) {
            throw new InitializationException("Failed to initialize TurbineVelocityService", e);
        }
    }

    public Context getContext() {
        return new VelocityContext(this.globalContext);
    }

    public Context getContext(RunData data) {
        Context context = (Context)data.getTemplateInfo().getTemplateContext("VELOCITY_CONTEXT");
        if (context == null) {
            context = this.getContext();
            context.put("data", (Object)data);
            if (this.pullModelActive) {
                TurbinePull.populateContext(context, data);
            }
            data.getTemplateInfo().setTemplateContext("VELOCITY_CONTEXT", context);
        }
        return context;
    }

    /*
     * Loose catch block
     */
    public String handleRequest(Context context, String filename) throws TurbineException {
        String results;
        block11: {
            results = null;
            ByteArrayOutputStream bytes = null;
            bytes = new ByteArrayOutputStream();
            String charset = this.decodeRequest(context, filename, bytes);
            results = bytes.toString(charset);
            Object var6_9 = null;
            try {
                if (bytes != null) {
                    bytes.close();
                }
                break block11;
            }
            catch (IOException ignored) {}
            break block11;
            {
                catch (Exception e) {
                    TurbineVelocityService.renderingError(filename, e);
                    Object var6_10 = null;
                    try {
                        if (bytes != null) {
                            bytes.close();
                        }
                        break block11;
                    }
                    catch (IOException ignored) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                try {
                    if (bytes != null) {
                        bytes.close();
                    }
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return results;
    }

    public void handleRequest(Context context, String filename, OutputStream output) throws TurbineException {
        this.decodeRequest(context, filename, output);
    }

    /*
     * Loose catch block
     */
    private String decodeRequest(Context context, String filename, OutputStream output) throws TurbineException {
        String charset;
        block17: {
            OutputStreamWriter writer;
            block16: {
                Object encoding;
                Object data;
                if (this.pullModelActive && this.refreshToolsPerRequest) {
                    TurbinePull.refreshGlobalTools();
                }
                if ((data = context.get("data")) != null && data instanceof RunData) {
                    charset = ((RunData)data).getCharSet();
                    if (charset == null) {
                        charset = this.defaultCharSet;
                    }
                    String string = ((RunData)data).getTemplateEncoding();
                } else {
                    charset = this.defaultCharSet;
                    encoding = null;
                }
                writer = null;
                writer = new OutputStreamWriter(output, charset);
                if (encoding != null) {
                    Velocity.mergeTemplate((String)filename, (Context)context, (Writer)writer);
                    break block16;
                }
                Velocity.mergeTemplate((String)filename, (Context)context, (Writer)writer);
            }
            Object var9_8 = null;
            try {
                if (writer != null) {
                    writer.flush();
                }
                break block17;
            }
            catch (Exception e2) {}
            break block17;
            {
                catch (Exception e) {
                    TurbineVelocityService.renderingError(filename, e);
                    Object var9_9 = null;
                    try {
                        if (writer != null) {
                            writer.flush();
                        }
                        break block17;
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                try {
                    if (writer != null) {
                        writer.flush();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return charset;
    }

    private static final void renderingError(String filename, Exception e) throws TurbineException {
        String err = "Error rendering Velocity template: " + filename;
        Log.error(err + ": " + e.getMessage());
        throw new TurbineException(err, e);
    }

    private void initVelocity() throws InitializationException {
        Configuration configuration = this.getConfiguration();
        String logFile = TurbineServlet.getRealPath(configuration.getString("runtime.log", null));
        if (!StringUtils.isValid(logFile)) {
            String msg = "VelocityService runtime log file is misconfigured: '" + logFile + "' is not a valid log file";
            if (TurbineServlet.getServletConfig() instanceof TurbineConfig) {
                msg = msg + ": TurbineConfig users must use a path relative to web application root";
            }
            throw new Error(msg);
        }
        configuration.setProperty("runtime.log", (Object)logFile);
        Vector templatePaths = configuration.getVector("file.resource.loader.path");
        Velocity.clearProperty((String)"file.resource.loader.path");
        configuration.clearProperty("file.resource.loader.path");
        int pathsToProcess = templatePaths.size();
        int i = 0;
        while (i < pathsToProcess) {
            configuration.addProperty("file.resource.loader.path", (Object)TurbineServlet.getRealPath((String)templatePaths.get(i)));
            ++i;
        }
        try {
            Velocity.setConfiguration((Configuration)configuration);
            Velocity.init();
        }
        catch (Exception e) {
            throw new InitializationException("Failed to set up TurbineVelocityService", e);
        }
    }

    public boolean templateExists(String template) {
        return Velocity.templateExists((String)template);
    }

    public void requestFinished(Context context) {
        if (this.pullModelActive) {
            TurbinePull.releaseTools(context);
        }
    }
}

