<?xml version="1.0"?> 

<!--

$Id: mozilla-search.xsl,v 1.28 2002/02/07 01:20:20 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

See http://reptile.openprivacy.org for more information

TODO:

- This page is setup to process each channel into a content-list.

-->

<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:layout="http://schemas.openprivacy.org/reptile/layout"
                xmlns:page="http://schemas.openprivacy.org/reptile/mozilla/page"
                xmlns:dc="http://purl.org/metadata/dublin_core#" 
                xmlns:dce="http://purl.org/dc/elements/1.1/"
                xmlns:control="http://schemas.openprivacy.org/reptile/control"
                xmlns:cl="http://schemas.openprivacy.org/reptile/content-list"
                xmlns:link-producer="http://schemas.openprivacy.org/reptile/link-producer"
                xmlns:logo-producer="http://schemas.openprivacy.org/reptile/logo-producer"
                xmlns:error="http://schemas.openprivacy.org/reptile/error"
                xmlns:search="http://schemas.openprivacy.org/reptile/search"
                xmlns:timestamp="xalan://org.openprivacy.reptile.extensions.TimeStamp"
                xmlns:channel="xalan://org.openprivacy.reptile.extensions.om.ChannelExtension"
                xmlns:escape="xalan://org.openprivacy.reptile.extensions.EscapeExtension"
                xmlns:bootstrap="http://schemas.openprivacy.org/reptile/bootstrap"
                extension-element-prefixes="timestamp escape"
                version="1.0">

    <xsl:include href="resource:/xsl/misc/error/mozilla/mozilla-error.xsl"/>

    <xsl:output indent="yes" 
                omit-xml-declaration="yes"
                encoding="ISO-8859-1"/>

    <xsl:param name="reptile.home.location" select="''"/>

    <xsl:template match="/bootstrap:bootstrap/search:search">

        <control:content>
    
            <dce:title>Search Results</dce:title>
    
            <control:body>

                <!-- FIXME: put an advanced search form here -->
                
<!--                 <xsl:call-template name="advanced-search"/> -->

                <xsl:apply-templates/>

            </control:body>

        </control:content>

    </xsl:template>

    <xsl:template match="search:request">

        <p>

            <b> Search results for query: </b> <xsl:apply-templates/><br/>
            <b> Provider: </b> <xsl:value-of select="../@provider"/><br/>
            <b> State: </b> <xsl:value-of select="../@provider-state"/>

        </p>

    </xsl:template>

    <xsl:template match="search:results">

        <p>

            <xsl:choose>

                <xsl:when test="@found &gt; 0">
                    
                    <xsl:value-of select="@start + 1"/> through
                    <xsl:value-of select="@end + 1"/> of about
                    <xsl:value-of select="@found"/>
                    ( <xsl:value-of select="@page + 1"/> / <xsl:value-of select="@total-pages"/> pages )
                    
                </xsl:when>

                <xsl:otherwise>

                    No results found.
                    
                </xsl:otherwise>

            </xsl:choose>

        </p>

        <p>

            <table width="100%">

                <td align="left">
                    
                    <xsl:if test="@page != 0">
                        
                        <link-producer:link link-name="urn:search/previous-page"
                                            current-page="{@page}"
                                            provider-handle="{../@provider-handle}"/>
                        
                    </xsl:if>
                        
                </td>

                <td align="right">

                    <!-- only display the next if we can actually go forward. -->
                    
                    <xsl:if test="@page + 1 != @total-pages">
                        
                        <link-producer:link link-name="urn:search/next-page"
                                            current-page="{@page}"
                                            provider-handle="{../@provider-handle}"/>
                        
                    </xsl:if>

                </td>
                    
            </table>
                
        </p>

        <table width="100%">

            <!-- apply the results -->
            
            <xsl:apply-templates/>

        </table>
                 
    </xsl:template>

    <xsl:template match="search:entry">

        <xsl:variable name="location">

            <xsl:value-of select="./search:link/@location"/>

        </xsl:variable>

        <xsl:variable name="contentType">

            <xsl:value-of select="./search:link/@contentType"/>

        </xsl:variable>

        <tr>

        <td>

            <table width="100%" class="reptile-search-entry-title">

                <!-- FIXME: PUT  channel link here with the title -->
                
                <!-- FIXME: COULD WE PUT THE LAYER IF IT IS A SUBSCRIPTION -->

                <td nowrap="nowrap" width="10">
                    
                    <link-producer:link link-name="urn:view-xml" location="{$location}"/>
                    
                </td>

                <td nowrap="nowrap">
                    
                    <b>Last updated: </b> <xsl:value-of select="timestamp:get( ./search:link/@date-found )"/>
                    
                </td>

                <xsl:if test="search:link/@channel != ''">
                
                    <td width="100%" align="right" nowrap="nowrap">

                        <link-producer:channel-management location="{search:link/@channel}"
                                                          contentType="{ channel:getContentType( search:link/@channel ) }"
                                                          name="{ channel:getTitle( search:link/@channel ) }"/>

                        (
                        <b>

                            <link-producer:link link-name="urn:search/channel-history"
                                                channel="{search:link/@channel}"/>

                            
                        </b>
                        )

                    </td>

                </xsl:if>

            </table>
            
        </td>
        
        </tr>

        <tr>

        <td width="100%" bgcolor="white"  class="reptile-search-results-item">

            <table width="100%">

            <td valign="top" width="20">

            <link-producer:favicon site="{$location}" 
                           contentType="{$contentType}" 
                           location="{$location}"
                           name="{ escape:attributes( dc:title ) }"/>

            </td>

            <td valign="top">

                <xsl:choose>
                
                    <xsl:when test="search:link/@channel != ''">

                        <!-- FIXME: this should be a channel link -->
                        
                        <img src="{ channel:getImage( search:link/@channel ) }" align="right"/>

                    </xsl:when>

                    <xsl:otherwise>

                        <img src="/reptile/images/channel.png" align="right"/>

                    </xsl:otherwise>
                    
                </xsl:choose>

                <a href="{$location}" target="_new"><xsl:value-of select="dc:title"/></a>

                <xsl:choose>

                    <xsl:when test="dc:description = ''">

                         <xsl:value-of select="' '"/> <i>No description available.</i>
                    
                    </xsl:when>

                    <xsl:otherwise>

                        <!-- FIXME: sue CSS2 for this spacing -->

                        <xsl:value-of select="concat( ' ', ./dc:description )"/>

                    </xsl:otherwise>

                </xsl:choose>

            </td>

            </table>

        </td>

        </tr>

    </xsl:template>

</xsl:stylesheet>

