<?xml version="1.0"?> 

<!--

$Id: mozilla-edit.xsl,v 1.12 2001/12/22 21:39:02 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

See http://reptile.openprivacy.org for more information

TODO:

- add the following information:

    - channel title
    - channel description
    - dublin core metainfo

    - the skeleton and stylesheet this was generated from.

-->

<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml" 
                xmlns:dc="http://purl.org/dc/elements/1.1/" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:layout="http://schemas.openprivacy.org/reptile/layout"
                xmlns:cm="http://schemas.openprivacy.org/reptile/channel-management"
                xmlns:control="http://schemas.openprivacy.org/reptile/control"
                xmlns:error="http://schemas.openprivacy.org/reptile/error"
                xmlns:proxy="xalan://org.openprivacy.reptile.extensions.ProxyFunctions"
                extension-element-prefixes="proxy"
                exclude-result-prefixes=""
                version="1.0">

    <xsl:output indent="no"
                omit-xml-declaration="yes"/>                

    <xsl:param name="reptile.home.location" select="''"/>
    <xsl:param name="reptile.channel-management.location" select="''"/>
    <xsl:param name="reptile.channel-management.contentType" select="''"/>

    <xsl:variable name="layer" 
                  select="/layout:layout/layout:content[@location = $reptile.channel-management.location]/layout:position/@layer"/>

    <xsl:variable name="column"
                  select="/layout:layout/layout:content[@location = $reptile.channel-management.location]/layout:position/@column"/>

    <xsl:template match="/layout:layout">

         <control:content>

             <dc:title>Edit channel</dc:title>
    
             <control:body>
    
             <h3>Channel information:</h3>

             <b>URL: </b>  

             <a href="view-source:{$reptile.channel-management.location}">
                 <xsl:value-of select="$reptile.channel-management.location"/>
             </a>

             <br/>

             <b>Content type: </b>  

             <xsl:value-of select="$reptile.channel-management.contentType"/>
             <br/>

             <xsl:if test="proxy:supports( $reptile.channel-management.location )">

                 <h3>Proxy cache information:</h3>

                 <b>Last updated:  </b>  <proxy:lastModified location="{$reptile.channel-management.location}"/>
                 <br/>                 

                 <b>Next update:  </b>  <proxy:nextUpdate location="{$reptile.channel-management.location}"/>
                 <br/>                 

                 <b>Update interval:  </b>  <proxy:updateInterval location="{$reptile.channel-management.location}"/>
                 <br/>                 
        
             </xsl:if>

             <h3>Subscription information:</h3>

             <p>
             This channel will not be displayed again unless you subscribe to it.  
             </p>
    
             <form action="{$reptile.home.location}" method="post">
    
             <div align="center">
    
             <table>
    
             <tr>
             
             <xsl:apply-templates select="./layout:layer-index"/>
    
             </tr>
             
             <tr>
    
             <td>
             
             <b>Or create a new layer: </b>
    
             </td>
    
             <td>
    
             <input type="text" name="reptile.channel-management.edit.new-layer" value=""/>         
    
             </td>
    
             </tr>

             <tr>
             
             <td>

             <b>Number of columns:</b>

             </td>
             
             <td>

                 <select name="reptile.channel-management.edit.numcolumns">

                     <option value="2">Two</option>

                     <option value="1">One</option>

                 </select>

             </td>             

             </tr>
    
             <tr>
             <td>
             
             <b>Select Column: </b>
             
             </td>
    
             <td>
    
             <input type="radio" 
                    name="reptile.channel-management.edit.column"
                    value="left"> 
    
             <xsl:if test="$column = 'left'">
                 <xsl:attribute name="checked">true</xsl:attribute>
             </xsl:if>
    
             Left
             
             </input>
    
             <input type="radio" 
                    name="reptile.channel-management.edit.column"
                    value="right">
    
             <xsl:if test="$column = 'right'">
                 <xsl:attribute name="checked">true</xsl:attribute>
             </xsl:if>
    
             Right
             
             </input>
    
             </td>
    
             </tr>
    
             </table>
    
             <input type="submit" value="Subscribe/Update"/>
    
             </div>
    
             <input type="hidden" name="reptile.channel-management.location" value="{$reptile.channel-management.location}"/>
             <input type="hidden" name="reptile.channel-management.contentType" value="{$reptile.channel-management.contentType}"/>
    
             <!-- Tell the correct action to execute -->
             <input type="hidden" name="reptile.action" value="UpdateSubscriptions"/>
    
             </form>

             <!-- View source for http:// urls -->

            <!-- <xsl:if test="starts-with( $reptile.channel-management.location, 'http://' )"> -->
                         
            <!--     <control:feature name="urn:view-source" location="{$reptile.channel-management.location}"/> -->

            <!-- </xsl:if> -->
    
             </control:body>
    
             <xsl:apply-templates/>

         </control:content>

    </xsl:template>

    <xsl:template match="layout:layer-index">

        <td>

        <b>Select a layer: </b>

        </td>
 
        <td>

        <select name="reptile.channel-management.edit.layer">

        <option value="{@name}">----</option>

        <xsl:apply-templates select="./layout:layer"/>

        </select>
        
        </td>

    </xsl:template>

    <xsl:template match="layout:layer">

         <!-- FIXME: don't continually call this -->

        <option value="{@name}">

        <xsl:if test="$layer = @name">

            <xsl:attribute name="selected">selected</xsl:attribute>

        </xsl:if>

        <xsl:value-of select="@name"/>

        </option>

    </xsl:template>

</xsl:stylesheet>

