/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.panther.implementations;

import java.io.IOException;
import javax.xml.transform.URIResolver;
import org.openprivacy.panther.components.Proxy;
import org.openprivacy.panther.components.ProxyEntry;
import org.openprivacy.panther.event.ProxyEventListener;
import org.openprivacy.panther.event.ProxyEventManager;
import org.openprivacy.panther.implementations.PantherURIResolver;
import org.openprivacy.panther.implementations.UpdateManager;
import org.openprivacy.panther.implementations.operations.Contains;
import org.openprivacy.panther.implementations.operations.Get;
import talon.BaseComponent;
import talon.Component;
import talon.TalonException;
import talon.resources.Resource;
import talon.resources.ResourceMapper;
import talon.util.net.URI;

public class PantherProxy
extends BaseComponent
implements Component,
Proxy {
    protected static Proxy proxyInstance = null;
    private ResourceMapper mapper = null;
    private URIResolver uriResolver = null;

    public void init() throws TalonException {
        this.uriResolver = new PantherURIResolver(this);
        proxyInstance = this;
    }

    public Resource getResource(URI uri) throws IOException {
        return this.mapper.getResource(uri);
    }

    public Resource getResource(String uri) throws IOException {
        return this.mapper.getResource(uri);
    }

    public void setResourceMapper(ResourceMapper mapper) {
        this.mapper = mapper;
    }

    public ResourceMapper getResourceMapper() {
        return this.mapper;
    }

    public ProxyEntry get(String location) throws IOException {
        return this.get(new URI(location));
    }

    public ProxyEntry get(URI location) throws IOException {
        return Get.getInstance(this).get(location);
    }

    public void update(String location) throws IOException {
        UpdateManager.getInstance().update(location);
    }

    public void update(URI location) throws IOException {
        this.update(location.toString());
    }

    public boolean supports(URI location) {
        return location.getScheme().equals("http") || location.getScheme().equals("ftp");
    }

    public boolean supports(String location) {
        return this.supports(new URI(location));
    }

    public boolean contains(URI location) {
        return this.contains(location.toString());
    }

    public boolean contains(String location) {
        return Contains.getInstance(this).contains(location);
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public void asyncUpdate(String location) {
        try {
            this.update(location);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void asyncUpdate(URI location) {
        this.asyncUpdate(location.toString());
    }

    public void addProxyEventListener(ProxyEventListener listener) {
        ProxyEventManager.getInstance().addProxyEventListener(listener);
    }

    public void removeProxyEventListener(ProxyEventListener listener) {
        ProxyEventManager.getInstance().removeProxyEventListener(listener);
    }
}

