/*
 * Decompiled with CFR 0.152.
 */
package talon.util.net;

import java.io.IOException;
import java.net.URL;

public class URI {
    private String reference = "";
    private boolean isURL = false;

    public URI() {
    }

    public URI(String reference) {
        this.reference = reference;
    }

    public URI(String reference, boolean isURL) {
        this.reference = reference;
        this.isURL = isURL;
    }

    public String toString() {
        return this.reference;
    }

    public boolean isURL() {
        return this.isURL;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getScheme() {
        String scheme = null;
        int index = this.reference.indexOf(":");
        if (index != -1) {
            scheme = this.reference.substring(0, index);
        }
        return scheme;
    }

    public URL getURL() throws IOException {
        return new URL(this.toString());
    }

    public URL getResource() throws IOException {
        URL url = this.getClass().getResource(this.toString());
        if (url == null) {
            throw new IOException("Could not find URI as a resource:  " + this.toString());
        }
        System.out.println("Found url: + " + url.toString());
        return url;
    }

    public boolean equals(Object obj) {
        if (obj instanceof String) {
            String location = (String)obj;
            return this.toString().equals(location);
        }
        if (this.getClass() == obj.getClass()) {
            URI other = (URI)obj;
            return this.toString().equals(other.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

