<?xml version="1.0"?> 

<!--

$Id: mozilla-jvm-settings.xsl,v 1.2 2001/08/02 08:17:11 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

See http://reptile.openprivacy.org for more information

-->

<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml" 
                xmlns:dc="http://purl.org/dc/elements/1.1/" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:layout="http://schemas.openprivacy.org/reptile/layout"
                xmlns:control="http://schemas.openprivacy.org/reptile/control"
                xmlns:error="http://schemas.openprivacy.org/reptile/error"
                xmlns:jvm-settings="http://schemas.openprivacy.org/reptile/settings/jvm"
                xmlns:logo-producer="http://schemas.openprivacy.org/reptile/logo-producer"
                exclude-result-prefixes=""
                version="1.0">

    <xsl:output indent="yes"
                omit-xml-declaration="yes"/>                

    <xsl:template match="/jvm-settings:jvm-settings">

         <control:content>

             <dc:title>Java Virtual Machine</dc:title>
    
             <control:body>
    
                 <p>
                 This control will allow you to view settings for you Java
                 Virtual Machine.
    
                 <logo-producer:java/>
    
                 </p>
    
                 <xsl:apply-templates/>
    
             </control:body>

         </control:content>

    </xsl:template>


    <xsl:template match="jvm-settings:runtime">

        <h4>Runtime information: </h4>

        <table>
        
        <tr>

        <td>

        <logo-producer:bullet/>

        <b>Total Memory: </b>

        </td>
        
        <td>

        <xsl:value-of select="./jvm-settings:total-memory"/>

        (in bytes)

        </td>

        </tr>

        <tr>

        <td>
        
        <logo-producer:bullet/>

        <b>Free Memory: </b> 
        
        </td>

        <td>

        <xsl:value-of select="./jvm-settings:free-memory"/>

        (in bytes)

        </td>

        </tr>

        </table>

    </xsl:template>

</xsl:stylesheet>

