<?xml version="1.0"?> 

<!--

$Id: mozilla-search.xsl,v 1.9 2001/09/23 23:06:57 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

See http://reptile.openprivacy.org for more information

TODO:

- This page is setup to process each channel into a content-list.

-->

<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:layout="http://schemas.openprivacy.org/reptile/layout"
                xmlns:page="http://schemas.openprivacy.org/reptile/mozilla/page"
                xmlns:dc="http://purl.org/dc/elements/1.1/" 
                xmlns:control="http://schemas.openprivacy.org/reptile/control"
                xmlns:cl="http://schemas.openprivacy.org/reptile/content-list"
                xmlns:link-producer="http://schemas.openprivacy.org/reptile/link-producer"
                xmlns:logo-producer="http://schemas.openprivacy.org/reptile/logo-producer"
                xmlns:error="http://schemas.openprivacy.org/reptile/error"
                xmlns:results="http://schemas.openprivacy.org/reptile/search-results"
                xmlns:proxy="xalan://org.openprivacy.reptile.extensions.ProxyFunctions"
                xmlns:feeds="xalan://org.openprivacy.reptile.extensions.feeds.Feeds"
                extension-element-prefixes="proxy feeds"
                version="1.0">

    <xsl:include href="resource:/xsl/search/mozilla/mozilla-advanced-search.xsl"/>

    <xsl:output indent="yes" 
                omit-xml-declaration="yes"/>                

    <xsl:param name="reptile.search.query" select="''"/>

    <xsl:param name="reptile.search.type" select="''"/>

    <xsl:param name="reptile.home.location" select="''"/>

    <xsl:template match="/results:search-results">

        <control:content>
    
            <dc:title>Search Results</dc:title>
    
            <control:body>

                <xsl:call-template name="advanced-search"/>

                <p>

                Search results for query '<xsl:value-of select="$reptile.search.query"/>'

                </p>

                <table bgcolor="lightgray" width="100%">

                    <xsl:apply-templates/>

                </table>

            </control:body>

        </control:content>

    </xsl:template>

    <xsl:template match="results:entry">

        <xsl:variable name="location">

            <xsl:value-of select="./results:link/@location"/>

        </xsl:variable>


        <xsl:variable name="contentType">

            <xsl:value-of select="./results:link/@contentType"/>

        </xsl:variable>

        <tr>

        <td width="100%" bgcolor="white"  class="reptileSearchResultsItem">

            <table>

            <td>

            <link-producer:favicon site="{$location}" 
                           contentType="{$contentType}" 
                           location="{$location}"
                           name="{dc:title}"/>

            </td>

            <td>

            <link-producer:channel-management location="{$location}"
                                              contentType="{$contentType}"
                                              name="{dc:title}"/>

            </td>

            </table>
            
            <xsl:choose>

                <xsl:when test="dc:description = ''">

                     <xsl:value-of select="' '"/> <i>No description available.</i>
                
                </xsl:when>

                <xsl:otherwise>

                    <xsl:value-of select="concat( ' ', ./dc:description )"/>

                </xsl:otherwise>

            </xsl:choose>

            <link-producer:get-reputation>
                    
                <xsl:attribute name="identifier">
                    <xsl:value-of select="$location"/>
                </xsl:attribute>
            
            </link-producer:get-reputation>

            <small>

            <b>View source: </b> <link-producer:link link-name="urn:view-source" location="{$location}" name="{$location}"/>
            
            <br/>

            <b>Last updated: </b> <proxy:lastModified location="{$location}"/>

            </small>

        </td>

        </tr>

    </xsl:template>

</xsl:stylesheet>

