<?xml version="1.0"?> 

<!--

$Id: execute.xsl,v 1.3 2001/08/13 03:47:06 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

See http://reptile.openprivacy.org for more information

TODO:

- This page is setup to process each channel into a content-list.

-->

<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:layout="http://schemas.openprivacy.org/reptile/layout"
                xmlns:page="http://schemas.openprivacy.org/reptile/mozilla/page"
                xmlns:dc="http://purl.org/dc/elements/1.1/" 
                xmlns:control="http://schemas.openprivacy.org/reptile/control"
                xmlns:bootstrap="http://schemas.openprivacy.org/reptile/bootstrap"
                xmlns:results="http://schemas.openprivacy.org/reptile/search-results"
                xmlns:search="xalan://org.openprivacy.reptile.extensions.feeds.Search"
                extension-element-prefixes="search"
                version="1.0">

    <xsl:output indent="yes" 
                omit-xml-declaration="yes"/>                

    <xsl:param name="reptile.search.query" select="''"/>

    <xsl:param name="reptile.search.type" select="'byTitleAndDescription'"/>

    <xsl:template match="/bootstrap:bootstrap">
    
        <results:search-results>

            <xsl:choose>

                <xsl:when test="$reptile.search.type = 'byTitle'">

                    <search:byTitle query="%{$reptile.search.query}%"/>

                </xsl:when>

                <xsl:when test="$reptile.search.type = 'byDescription'">

                    <search:byDescription query="%{$reptile.search.query}%"/>

                </xsl:when>

                <xsl:otherwise>

                    <search:byTitleAndDescription query="%{$reptile.search.query}%"/>

                </xsl:otherwise>

            </xsl:choose>

        </results:search-results>

    </xsl:template>
    
</xsl:stylesheet>

