<?xml version="1.0"?> 

<!--

$Id: item-list.xsl,v 1.7 2001/08/10 04:51:05 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

See http://reptile.openprivacy.org for more information

TODO:

- This page is setup to process each channel into a content-list.

-->

<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:layout="http://schemas.openprivacy.org/reptile/layout"
                xmlns:page="http://schemas.openprivacy.org/reptile/mozilla/page"
                xmlns:dc="http://purl.org/dc/elements/1.1/" 
                xmlns:control="http://schemas.openprivacy.org/reptile/control"
                xmlns:cl="http://schemas.openprivacy.org/reptile/content-list"
                xmlns:link-producer="http://schemas.openprivacy.org/reptile/link-producer"
                xmlns:error="http://schemas.openprivacy.org/reptile/error"
                xmlns:marks="xalan://org.openprivacy.reptile.extensions.Marks"
                xmlns:shown-count="xalan://org.openprivacy.reptile.extensions.ShownCount"
                extension-element-prefixes="marks shown-count"
                version="1.0">

    <xsl:output indent="yes" 
                omit-xml-declaration="yes"/>                

    <xsl:template match="/layout:layout">

        <control:content>
    
            <dc:title>Unread articles</dc:title>
    
            <control:body>

            This channel allows you to view all unread stories you are
            subscribed to.  There is also a 

            <link-producer:link link-name="urn:quick-channel/item-list/full" name="more detailed list"/> 

            available.

            <br/>            

            <table>

            <!--  HTML hack.  For some reason konq needs at least one row. -->
            <tr>

            <td/>

            <td/>

            </tr>

            <xsl:apply-templates select="./layout:layer/layout:content/cl:content-list/cl:entry"/>
    
            </table>

            </control:body>

            <control:shownCount><xsl:value-of select="shown-count:get()"/></control:shownCount>

        </control:content>

    </xsl:template>

    <xsl:template match="cl:entry">

        <xsl:variable name="location">

            <xsl:value-of select="../../@location"/>
        
        </xsl:variable>

        <xsl:variable name="contentType">

            <xsl:value-of select="../../@contentType"/>
        
        </xsl:variable>

        <xsl:variable name="channelTitle">

            <xsl:value-of select="../cl:channel//dc:title"/>
        
        </xsl:variable>

        <xsl:if test="marks:isRead( @location ) = false">

            <shown-count:increment/>

            <tr>

            <td valign="top">

            <link-producer:favicon site="{@location}" 
                                   contentType="{$contentType}" 
                                   location="{$location}"
                                   name="{$channelTitle}"/>
    
            </td>

            <td>
    
            <a href="{@location}" target="_new">
    
            <xsl:value-of select="./dc:title"/>
            
            </a>
    
            </td>

            </tr>

        </xsl:if>

    </xsl:template>

    <!-- we don't care about errors here -->
    <xsl:template match="error:error"/>

</xsl:stylesheet>

