<?xml version="1.0"?> 

<!--

$Id: mozilla-edit-channel.xsl,v 1.5 2001/09/21 22:06:09 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

Responsible for rendering Mozilla layout controls.  

See http://reptile.openprivacy.org for more information

-->

<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml" 
                xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" 
                xmlns:rss="http://purl.org/rss/1.0/"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:sub="http://schemas.openprivacy.org/reptile/subscriptions"
                xmlns:add="http://schemas.openprivacy.org/reptile/publish/add"
                xmlns:control="http://schemas.openprivacy.org/reptile/control"
                xmlns:dc="http://purl.org/dc/elements/1.1/" 
                exclude-result-prefixes="dc transformer sub control"
                version="1.0">

    <xsl:output indent="yes"
                omit-xml-declaration="yes"/>

    <xsl:param name="reptile.home.location" select="''"/>

    <xsl:param name="reptile.sequence.name" select="''"/>

    <xsl:param name="reptile.syndication.publish.input.size" select="'65'"/>

    <xsl:param name="reptile.syndication.publish.textarea.rows" select="'6'"/>

    <xsl:param name="reptile.syndication.publish.textarea.cols" select="'80'"/>

    <xsl:template match="/rdf:RDF">

        <control:content>
    
            <dc:title>Edit Channel Information</dc:title>
    
            <control:body>
    
            <img align="right" hspace="3" vspace="3" src="/reptile/images/publish.png"/>

            <form action="{$reptile.home.location}" method="post">
    
            <div align="center">
    
            <table>

            <tr>

            <td class="reptileSpacing">

                <p>
                This allows you to edit channel information for your RSS channel.
                </p>

            </td>
            
            </tr>

            <xsl:apply-templates select="rss:channel/rss:title"/>

            <xsl:call-template name="image"/>
    
            <xsl:apply-templates select="rss:channel/rss:description"/>

            <tr>
    
            <td align="right" class="reptileSpacing" >
    
            <input type="submit" value="Update" name="Add"/>
    
            </td>
    
            </tr>
    
            </table>        
    
            </div>
    
             <!-- Tell the correct action to execute -->
             <input type="hidden" name="reptile.action" value="UpdateContent"/>
    
             <input type="hidden" name="reptile.update_content.resource" value="resource:/xml/users/default/mychannel.rss"/>

             <input type="hidden" name="reptile.update_content.sequence" value="urn:syndication/publish/edit-channel/apply"/>

             <input type="hidden" name="reptile.action.next.layer" value="Preview"/>
             
             <input type="hidden" name="reptile.action.next.sequence" value="urn:syndication/publish"/>
    
            </form>
    
            <br/>
    
            </control:body>

        </control:content>

    </xsl:template>

    <xsl:template match="rss:title">

        <tr>

        <td>

        <b>Title: </b>

        <input type="text" 
               name="reptile.edit-channel.title" 
               size="{$reptile.syndication.publish.input.size}"
               value="{.}"/>

        </td>        

        </tr>        

    </xsl:template>

    <xsl:template match="rss:description">

        <tr>

        <td>

        <fieldset>

            <legend>Description:</legend>

            <textarea class="largemargin" 
                      rows="{$reptile.syndication.publish.textarea.rows}" 
                      cols="{$reptile.syndication.publish.textarea.cols}" 
                      name="reptile.edit-channel.description">

            <xsl:value-of select="."/>

            </textarea>

        </fieldset>

        </td>

        </tr>

    </xsl:template>

    <xsl:template name="image">

        <tr>

        <td>

            <fieldset>

                <legend>Image:</legend>

                <table>

                <tr>

                <td>

                <b>Title: </b>

                </td>
                
                <td>

                <input type="text" 
                       name="reptile.edit-channel.image.title" 
                       size="{$reptile.syndication.publish.input.size}"
                       value="{/rdf:RDF/rss:channel/rss:image/rss:title}"/>
                       
                </td>

                </tr>


                <tr>

                <td>

                <b>Website Link: </b>

                </td>
                
                <td>

                <input type="text" 
                       name="reptile.edit-channel.image.link" 
                       size="{$reptile.syndication.publish.input.size}"
                       value="{/rdf:RDF/rss:channel/rss:image/rss:link}"/>

                </td>

                </tr>

                <tr>

                <td>

                <b>Image URL: </b>

                </td>
                
                <td>

                <input type="text" 
                       name="reptile.edit-channel.image.url" 
                       size="{$reptile.syndication.publish.input.size}"
                       value="{/rdf:RDF/rss:channel/rss:image/rss:url}"/>

                </td>

                </tr>            

                </table>

            </fieldset>

        </td>

        </tr>            

    </xsl:template>

</xsl:stylesheet>

