<?xml version="1.0"?> 

<!--

$Id: mozilla-options.xsl,v 1.7 2001/09/23 02:40:11 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

Responsible for rendering Mozilla layout controls.  

See http://reptile.openprivacy.org for more information

-->

<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml" 
                xmlns:dc="http://purl.org/dc/elements/1.1/" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:sub="http://schemas.openprivacy.org/reptile/subscriptions"
                xmlns:control="http://schemas.openprivacy.org/reptile/control"
                xmlns:link-producer="http://schemas.openprivacy.org/reptile/link-producer"
                xmlns:layout="http://schemas.openprivacy.org/reptile/layout"
                xmlns:error="http://schemas.openprivacy.org/reptile/error"
                exclude-result-prefixes="dc transformer sub control"
                version="1.0">

    <!-- Include any options necessary for any options to operate. -->
    <xsl:template name="include-options">

        <xsl:comment>Include scripts necessary for option functionality.</xsl:comment>
    
        <script src="/reptile/javascript/mozilla-options.js"/>
        <script src="/reptile/javascript/mozilla-publish.js"/>
        <script src="/reptile/javascript/mozilla-view-source.js"/>
    
    </xsl:template>

    <!-- Generate all options the given parameter 'location' contains the
    location id for the form to be used. -->
    <xsl:template name="generate-options">

        <xsl:param name="location"/>                

        <!-- only display the options if we actually have a channel that exposes
        options -->

        <xsl:if test="count( ./control:content/control:option ) > 0">

            <td align="right">

                <select name="reptile_option_select" class="reptileChannelOptions" onChange="reptileChannelOptions( '{$location}' )">

                    <option value="" checked="true">Choose an option...</option>
                    <option value="" >----</option>

                    <xsl:apply-templates select="./control:content/control:option"/>

                </select>

                <input type="hidden" name="reptile.sequence.name" value="urn:syndication/publish"/>
                
                <input type="hidden" name="reptile_link" value=""/>
                <input type="hidden" name="reptile_link_title" value=""/>
                <input type="hidden" name="reptile_link_description" value=""/>                

            </td>

        </xsl:if>

    </xsl:template>

    <!-- options for publishing to the weblog -->
    <xsl:template match="control:option[@name = 'urn:reptile/channel/rss/options/publish']">
    
        <option value="reptilePublish( form )">Publish with weblog</option>

    </xsl:template>

    <!-- Create the ability to make a link so that the user can 'view source' on
    a specific URL.  Example:

    <control:option name="urn:view-source"
                    location="http://site"/>

    -->
    <xsl:template match="control:option[@name = 'urn:view-source']">

        <option value="reptileViewSource( form )">View source</option>

    </xsl:template>

</xsl:stylesheet>

