<?xml version="1.0"?> 

<!--

$Id: page.xsl,v 1.28 2001/09/24 08:52:29 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

See http://reptile.openprivacy.org for more information

-->

<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:sub="http://schemas.openprivacy.org/reptile/subscriptions"
                xmlns:page="http://schemas.openprivacy.org/reptile/mozilla/page"
                xmlns:link-producer="http://schemas.openprivacy.org/reptile/link-producer"
                xmlns:timestamp="xalan://org.openprivacy.reptile.extensions.TimeStamp"
                xmlns:proxy="xalan://org.openprivacy.reptile.extensions.ProxyFunctions"
                xmlns:feeds="xalan://org.openprivacy.reptile.extensions.feeds.Feeds"
                extension-element-prefixes="timestamp proxy feeds"
                exclude-result-prefixes="sub page"
                version="1.0">

    <xsl:include href="resource:/xsl/misc/xhtml/reptile-link-producer.xsl"/>

    <xsl:include href="resource:/xsl/misc/xhtml/reptile-logo-producer.xsl"/>

    <xsl:include href="resource:/xsl/misc/error/mozilla/mozilla-error.xsl"/>

    <xsl:include href="resource:/xsl/option/mozilla-options.xsl"/>

    <xsl:include href="resource:/xsl/misc/xhtml/services.xsl"/>

    <!-- by default, copy all matching templates -->
    <xsl:include href="resource:/xsl/misc/copy.xsl"/>

    <!-- output html here because this is out last step -->
    <xsl:output indent="yes" 
                method="html"
                omit-xml-declaration="yes"/>                

    <!-- declare all parameters and provide default values -->
    <xsl:param name="reptile.home.location" select="''"/>

    <xsl:param name="reptile.search.query" select="''"/>

    <xsl:param name="reptile.layer" select="''"/>

    <xsl:template match="page:page">
    
        <html>

        <head>

            <title>
            <xsl:value-of select="@title"/>        
            </title>

            <!-- NOTE: Mozilla can't handle loading stylesheets from file:// URLs.  -->
            <link title="Style"
                  type="text/css"
                  href="/reptile/style/default.css"
                  rel="stylesheet"/>

            <xsl:call-template name="include-options"/>

        </head>

        <body>

        <table cellpadding="0" 
               width="100%"
               bgcolor="#efefef">

        <td nowrap="nowrap" class="reptileNavItem">

            <xsl:call-template name="link-producer:my-subscriptions"/>

        </td>

        <td nowrap="nowrap" class="reptileNavItem">

            <xsl:call-template name="link-producer:quick-channel/item-list/full"/> 

        </td>

        <td nowrap="nowrap" class="reptileNavItem">

            <xsl:call-template name="link-producer:publish"/>

        </td>

        <td nowrap="nowrap" class="reptileNavItem">

            <xsl:call-template name="link-producer:browse"/>

        </td>

        <td nowrap="nowrap" class="reptileNavItem">

            <xsl:call-template name="link-producer:advanced-search"/>

        </td>

        <td nowrap="nowrap" class="reptileNavItem">

            <xsl:call-template name="link-producer:tools"/>

        </td>

        <td nowrap="nowrap" class="reptileNavItem">

            <xsl:call-template name="link-producer:settings"/>

        </td>

        <td nowrap="nowrap" class="reptileNavItem">

            <xsl:call-template name="link-producer:about"/>

        </td>

        <td nowrap="nowrap" class="reptileNavItem">

            <xsl:call-template name="link-producer:logout"/>

        </td>

        <td width="100%" align="right">

            <small>
            <b>Date: </b> <xsl:value-of select="timestamp:get()"/>
            </small>

        </td>

        </table>

        <table width="100%">

        <td class="reptileWelcomeMessage" width="100%">

        <h1>
        <xsl:value-of select="@title"/>

            <xsl:if test="$reptile.layer != ''">

            : <xsl:value-of select="$reptile.layer"/>

            </xsl:if>

        </h1>

        </td>        

        <td align="right" valign="middle">

        <xsl:call-template name="search-form"/>

        </td>

        </table>

        <xsl:apply-templates/>

        <hr/>

        <div align="right">

            <small>

            Powered by <a href="http://reptile.openprivacy.org">Reptile</a>, an <a
            href="http://www.openprivacy.org">OpenPrivacy</a> enabled technology.

            </small>
            
        </div>

        </body>

        </html>

    </xsl:template>

    <!-- Generate a search form -->
    <xsl:template name="search-form">

        <table width="100%" 
               cellspacing="0" 
               cellpadding="1" 
               class="reptileNavSearch">

            <form method="get" action="{$reptile.home.location}">

                <tr>

                    <td nowrap="true" valign="middle">

                    <b>Search <feeds:count/> channels: </b>

                    </td>

                    <td valign="middle">

                    <input name="reptile.search.query" type="text" class="reptileQuickSearch">

                        <xsl:attribute name="value">

                            <xsl:value-of select="$reptile.search.query"/>

                        </xsl:attribute>

                    </input>

                    </td>       

                </tr>

            <input type="hidden" name="reptile.sequence.name" value="urn:search"/>

            <input type="hidden" name="reptile.layer" value="Search Results"/>

            </form>

        </table>

    </xsl:template>

</xsl:stylesheet>
