<?xml version="1.0"?> 

<!--

$Id: mozilla-control.xsl,v 1.44 2001/09/24 08:52:28 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

Responsible for rendering Mozilla layout controls.  

See http://reptile.openprivacy.org for more information

-->

<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml" 
                xmlns:dc="http://purl.org/dc/elements/1.1/" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:sub="http://schemas.openprivacy.org/reptile/subscriptions"
                xmlns:control="http://schemas.openprivacy.org/reptile/control"
                xmlns:link-producer="http://schemas.openprivacy.org/reptile/link-producer"
                xmlns:layout="http://schemas.openprivacy.org/reptile/layout"
                xmlns:proxy="xalan://org.openprivacy.reptile.extensions.ProxyFunctions"
                xmlns:error="http://schemas.openprivacy.org/reptile/error"
                extension-element-prefixes="proxy"
                exclude-result-prefixes="dc transformer sub control"
                version="1.0">

    <xsl:include href="resource:/xsl/misc/error/mozilla/mozilla-error.xsl"/>

    <xsl:include href="resource:/xsl/option/mozilla-options.xsl"/>

    <!-- by default, copy all matching templates -->
    <xsl:include href="resource:/xsl/misc/copy.xsl"/>

    <xsl:output indent="yes"
                omit-xml-declaration="yes"/>                

    <!-- declare all parameters and provide default values -->
    <xsl:param name="reptile.home.location" select="''"/>

    <xsl:param name="reptile.content.location" select="''"/>

    <xsl:param name="reptile.sequence.name" select="''"/>

    <xsl:template match="control:control">

        <!-- define necessary variables -->
        <xsl:variable name="location">

            <xsl:value-of select="./layout:content/@location"/>

        </xsl:variable>

        <xsl:variable name="contentType">

            <xsl:value-of select="./layout:content/@contentType"/>

        </xsl:variable>

        <xsl:variable name="link">

            <xsl:value-of select="./control:content/control:link"/>

        </xsl:variable>

        <xsl:variable name="title">

            <xsl:value-of select="./control:content/dc:title"/>

        </xsl:variable>

        <xsl:variable name="width">100%</xsl:variable>

        <xsl:comment>
        
        CONTROL: BEGIN control for <xsl:value-of select="$location"/>

        </xsl:comment>

        <form action="{$reptile.home.location}" method="post" id="{$location}">

        <tr>

        <td width="100%">

        <input type="hidden" name="reptile_content_location" value="{$location}"/>

        <table width="{$width}" 
               border="0" 
               cellpadding="3" 
               cellspacing="0"
               bgcolor="white"
               class="reptileControl">

        <tr class="reptileControlTop">

        <td width="100%" 
            nowrap="true">

            <table cellpadding="1"
                   cellspacing="1">

            <!-- Add favicon.ico -->
            
            <td valign="middle">

            <link-producer:favicon site="{$link}" 
                                   location="{$location}"
                                   contentType="{$contentType}"
                                   name="{$title}"/>

            </td>

            <td>

            <!-- add link and title.  Use an anchor if the link is available.-->
            
            <xsl:choose>

                <xsl:when test="$link != ''">

                    <b>
                    <a href="{$link}">

                    <xsl:value-of select="$title"/>

                    </a>
                    </b>

                </xsl:when>

                <xsl:otherwise>

                    <b>
                    <xsl:value-of select="$title"/>
                    </b>

                </xsl:otherwise>
            
            </xsl:choose>

            <!-- Show the number of unread items in this channel -->
            <xsl:if test="count( control:content/control:shownCount ) = 1">

                ( <xsl:value-of select="control:content/control:shownCount"/> )

            </xsl:if>

            <!-- if we don't have a title, either because of an exception or
            because the title isn't defined, use the URL for the title -->

            <xsl:if test="count( ./control:content/dc:title ) = 0">
                        
                <!-- I started off using the title but it was too long... -->
                <!--  <xsl:value-of select="control:location"/> -->
                                
                No title...
                
            </xsl:if>

            </td>

            </table>

        </td>

        <td width="100%" 
            align="right" 
            bgcolor="gray"
            nowrap="true">

            <xsl:if test="$reptile.sequence.name = 'urn:subscriptions'">

                <link-producer:link link-name="urn:channel-management/delete"
                                    location="{$location}"/>
            
            </xsl:if>

            <link-producer:channel-management location="{$location}"
                                              contentType="{$contentType}"
                                              name="Edit"/>

            <link-producer:link link-name="urn:channel-management/maximize"
                                title="Max"
                                location="{$location}"
                                contentType="{$contentType}"/>

        </td>

        </tr>

        <tr>

        <td width="100%" bgcolor="white" colspan="2">

        <!-- BEGIN CHANNEL BODY -->

        <!-- FIXME: provide an error if we don't have any body. -->
<!--          <xsl:if test="count( ./control:content/control:body ) = 1"> -->

<!--              <error:error type="error"> -->
    
<!--              This sequence did not generate any content. -->

<!--              </error:error> -->

<!--          </xsl:if> -->

        <xsl:apply-templates select="./control:content/control:body"/>

        <!-- we need to find error at BOTH locations because if an XML parsing
        error occurs they are at the root -->

        <!-- FIXME: looks like this is matching two templates.  The copy
        template and the error template -->
        <xsl:apply-templates select="./error:error"/>

        <xsl:apply-templates select="./control:content/error:error"/>

        <!-- if we have a shownCount of 0 then tell the user this. -->

        <xsl:if test="control:content/control:shownCount = 0">

            <!-- FIXME: convert this section to use warning/error markup 
                 http://bugzilla.openprivacy.org/show_bug.cgi?id=66
             -->
            <p>
            
            <img src="/reptile/images/warning.png"/>

            <i>
            This channel currently has no new items to display.  This will
            change in the future as new content is found and syndicated by the
            publisher.
            </i>
            </p>

        </xsl:if>

        <xsl:call-template name="display-metainfo">

            <xsl:with-param name="location">

                <xsl:value-of select="$location"/>

            </xsl:with-param>

        </xsl:call-template>

        </td>
        </tr>

        <tr>

            <td colspan="2" bgcolor="lightgray">

                <xsl:call-template name="channel-features">

                    <xsl:with-param name="location">

                        <xsl:value-of select="$location"/>

                    </xsl:with-param>

                </xsl:call-template>

            </td>
        
        </tr>

        </table>

        </td>
        
        </tr>        

        </form>

        <xsl:comment>
        
        CONTROL: END control for <xsl:value-of select="$location"/>

        </xsl:comment>

    </xsl:template>

    <!-- Display channel features -->
    <xsl:template name="channel-features">

        <xsl:param name="location"/>

        <table bgcolor="lightgray" width="100%">

        <td nowrap="true">

            <!-- get channel specific features -->
            <xsl:apply-templates select="./control:content/control:feature"/>

            <!-- Mozilla has problems with blank TD elements.  I put the
            following 'dot' to act as a holder. -->
            .
            
        </td>

        <td bgcolor="lightgray" 
            align="right" 
            nowrap="true">

            <xsl:choose>
    
                <!-- If the URL is based on HTTP, add support for reputation -->
                <xsl:when test="contains( $location, 'http://' )">
    
                    <link-producer:get-reputation>
                    
                        <xsl:attribute name="identifier">
                            <xsl:value-of select="$location"/>
                        </xsl:attribute>
                
                    </link-producer:get-reputation>
    
                </xsl:when>

                <xsl:otherwise>
                <!-- blank td cell.  need this under Mozilla -->
                .
                </xsl:otherwise>

            </xsl:choose>

        </td>

        </table>

    </xsl:template>

    <!-- Display channel metainfo at the bottom of the control -->
    <xsl:template name="display-metainfo">

        <xsl:param name="location"/>

        <tr>

        <td width="100%" colspan="2">

            <table width="100%">
            
            <td>

            <!-- show when this URL was last modified... only work for http urls.  -->
            <xsl:if test="contains( $location, 'http://' )">

                <b>Last updated:  </b>  <proxy:lastModified location="{$location}"/>
                <br/>

            </xsl:if>

            <!-- show the shown count -->
            <xsl:if test="count( control:content/control:shownCount ) = 1">
            
                <b>Unread articles:  </b>  <xsl:value-of select="control:content/control:shownCount"/>
                <br/>

            </xsl:if>

            </td>

                <!-- FIXME: We need to selectively enable this!!! -->
            
                <xsl:call-template name="generate-options">

                    <xsl:with-param name="location">

                        <xsl:value-of select="$location"/>

                    </xsl:with-param>

                </xsl:call-template>

            </table>

        </td>

        </tr>

    </xsl:template>

    <!-- handle URLs we don't want anything to do with -->

    <xsl:template match="control:location"/>

    <xsl:template match="control:link"/>

    <xsl:template match="dc:description"/>

    <xsl:template match="dc:title"/>

    <!-- This is a template for matching channels that support 'read marks'  IE
    marking all current items within a channel as read -->
    <xsl:template match="control:feature[@name = 'urn:reptile/channel/feature/read-marks']">

        <!-- get the location and contentType variable for this content -->                                    
        <xsl:variable name="location">
            <xsl:value-of select="../../layout:content/@location"/>
        </xsl:variable>

        <xsl:variable name="contentType">
            <xsl:value-of select="../../layout:content/@contentType"/>
        </xsl:variable>

        Mark channel

        <link-producer:read-marks location="{$location}"
                        contentType="{$contentType}"
                        name="read"/>
                        
        or 

        <link-producer:read-marks location="{$location}"
                        contentType="{$contentType}"
                        name="unread"/>

    </xsl:template>

    <xsl:template match="control:feature[@name = 'urn:view-source']">

        <b>View Source: </b>
    
        <link-producer:link link-name="urn:view-source"
                            location="{@location}"
                            name="{@location}"/>
        
        <br/>    

    </xsl:template>

    <!-- Need anything below the body -->
    <xsl:template match="control:body">

        <xsl:copy>

            <!-- FIXME: should we copy nodes that have a namespace of error??? -->

            <xsl:apply-templates select="@*|node()"/>

        </xsl:copy>

    </xsl:template>

</xsl:stylesheet>

