<?xml version="1.0"?> 

<!--

$Id: rss-1.0.xsl,v 1.35 2001/09/24 23:17:56 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

This stylesheet is designed to render RSS 1.0 content.

http://groups.yahoo.com/group/rss-dev/files/namespace.html

http://groups.yahoo.com/group/rss-dev/files/specification.html

-->


<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
                xmlns:dc="http://purl.org/dc/elements/1.1/" 
                xmlns:rss="http://purl.org/rss/1.0/"
                xmlns:im="http://purl.org/rss/1.0/item-images/" 
                xmlns:record="http://records.sourceforge.net/schemas/rss-meta-module/"
                xmlns:xhtml="http://www.w3.org/1999/xhtml" 
                xmlns:control="http://schemas.openprivacy.org/reptile/control"
                xmlns:logo-producer="http://schemas.openprivacy.org/reptile/logo-producer"
                xmlns:link-producer="http://schemas.openprivacy.org/reptile/link-producer"
                xmlns:reputation="xalan://org.openprivacy.reptile.ReputationUtil"
                xmlns:elp="xalan://org.openprivacy.reptile.extensions.LinkProducer"
                xmlns:marks="xalan://org.openprivacy.reptile.extensions.Marks"
                xmlns:shown-count="xalan://org.openprivacy.reptile.extensions.ShownCount"
                xmlns:valid-item="xalan://org.openprivacy.reptile.extensions.ValidItem"
                xmlns:image="xalan://org.openprivacy.reptile.extensions.Image"
                xmlns:weblog="xalan://org.openprivacy.reptile.extensions.Weblog"
                extension-element-prefixes="marks shown-count valid-item image reputation elp weblog"
                exclude-result-prefixes="rdf dc rss im record xhtml"
                version="1.0">

    <xsl:output indent="yes" 
                 omit-xml-declaration="yes"/>                

    <xsl:param name="reptile.content.location" select="''"/>

    <xsl:template match="/rdf:RDF">

        <control:content>

            <control:link><xsl:value-of select="./rss:channel/rss:link"/></control:link>
    
            <dc:title><xsl:value-of select="./rss:channel/rss:title"/></dc:title>
    
            <dc:description><xsl:value-of select="./rss:channel/rss:description"/></dc:description>
    
            <control:body>

            <xsl:apply-templates select="./rss:channel/rss:image"/>
            <xsl:apply-templates select="./rss:item"/>
            <xsl:apply-templates select="./rss:textinput"/>

            </control:body>
    
            <control:shownCount><xsl:value-of select="shown-count:get()"/></control:shownCount>


            <!-- only allow the user to mark a channel read if it is not one
            of their personal weblogs -->
            <xsl:if test="weblog:isWeblog( $reptile.content.location ) = false">
    
                <control:feature name="urn:reptile/channel/feature/read-marks"/>

            </xsl:if>

            <control:option name="urn:reptile/channel/rss/options/publish"/>

            <control:option name="urn:view-source"/>

        </control:content>

    </xsl:template>

    <xsl:template match="/rdf:RDF/rss:channel/rss:image">

        <a href="{./@rdf:about}" alt="{./rss:title}" target="_new">

        <img src="{image:link( ./rss:url )}" align="right" border="0" hspace="10" vspace="10">

        <!-- FIXME: use image width and height if specified -->        

        <!-- A lot of companies (CNN) don't give correct values for image height
        and width.   -->

<!--              <xsl:if test="rss:width != 0"> -->

<!--                  <xsl:attribute name="width"> -->

<!--                      <xsl:value-of select="rss:width"/> -->

<!--                  </xsl:attribute> -->

<!--              </xsl:if> -->

<!--              <xsl:if test="rss:height != 0"> -->

<!--                  <xsl:attribute name="height"> -->

<!--                      <xsl:value-of select="rss:height"/> -->

<!--                  </xsl:attribute> -->

<!--              </xsl:if> -->
        
        </img>

        </a>

    </xsl:template>

    <xsl:template match="/rdf:RDF/rss:item/im:image">

        <img src="{.}" align="right" hspace="10" vspace="10"/>
        
    </xsl:template>

    <!-- handle RSS items -->
    <xsl:template match="/rdf:RDF/rss:item">
    
        <xsl:variable name="location">

            <xsl:value-of select="./rss:link"/>

        </xsl:variable>

        <!-- There are three major 'if's here 

           - if the channel is a actually the local users 'mychannel.rss' file.

        -->
        <xsl:if test="weblog:isWeblog( $reptile.content.location ) or marks:isRead( $location ) = false and valid-item:isValid( ./rss:link, ./rss:title )">

            <shown-count:increment/>

            <table cellspacing="0" cellpadding="0">

                <td valign="middle">

                    <input type="radio" 
                           class="reptileRSSItem" 
                           name="reptile_link"
                           value="{rss:link}"
                           reptile_link_title="{rss:title}"
                           reptile_link_description="{rss:description}"/>

                </td>            

                <td valign="middle">

                    <b>
                    <a href="{rss:link}" target="_new">
                        <xsl:value-of select="./rss:title"/>
                    </a>
                    </b>

                </td>

                <!-- get the reputation for this item -->
                <xsl:call-template name="get-reputation">

                    <xsl:with-param name="identifier">

                         <xsl:value-of select="./rss:link"/>

                    </xsl:with-param>
                
                </xsl:call-template>

                <xsl:apply-templates select="dc:date"/>

            </table>

            <xsl:apply-templates select="dc:subject"/>
    
            <!--
            <small>From the <xsl:value-of select="./record:subject"/> department:</small>
            -->    

            <xsl:choose>

                <xsl:when test="string-length( ./rss:description ) > 0">

                    <p class="reptileRSSParagraph">
        
                    <xsl:value-of select="./rss:description"/>
                    
                    </p>
        
                </xsl:when>

                <xsl:otherwise>

                    <br/>

                </xsl:otherwise>

            </xsl:choose>

            <xsl:apply-templates select="rss:comment"/>

        </xsl:if>

    </xsl:template>

    <xsl:template match="rss:comment">

        <p class="reptileRSSComment">

            <xsl:value-of select="."/>
        
        </p>

    </xsl:template>

    <xsl:template match="/rdf:RDF/rss:item/dc:date">

        <tr>

        <td/>

        <td class="reptileRSS_timestamp">
        
            <xsl:value-of select="."/>
            
        </td>
    
        </tr>

    </xsl:template>    

    <xsl:template match="/rdf:RDF/rss:item/dc:subject">

        <b>Subject: </b> <xsl:value-of select="."/>
        <br/>

    </xsl:template>    

    <!-- RSS forms -->
    <xsl:template match="rss:textinput">

        <div align="center">
    
        <form action="{./rss:link}" method="get">

        <b>
        <xsl:value-of select="./rss:description"/>
        </b>        

        <table>

        <td>

        <input type="text" name="{./rss:name}"/>

        </td>

        <td>

        <input type="submit" name="Search"/>

        </td>

        </table>
        
        </form>

        </div>

    </xsl:template>    

    <xsl:template name="get-reputation">

        <xsl:param name="identifier"/>

        <elp:newLink/>
                  
        <elp:value name="reptile.sequence.name" value="urn:reputation-management"/>

        <elp:value name="identifier" value="{$identifier}"/>

        <tr>

            <td align="center" valign="middle">

                <img src="/reptile/images/reputation.png" border="0"/>

            </td>            

            <td nowrap="true" valign="middle">

                <a href="{elp:getLink()}">Reputation: </a>

                <xsl:value-of select="reputation:getReputation( string( $identifier ) )"/>

            </td>

        </tr>

    </xsl:template>

    <xsl:template match="/rdf:RDF/rss:channel"/>
    <xsl:template match="/rdf:RDF/rss:item/rss:title"/>

</xsl:stylesheet>
