<?xml version="1.0"?> 

<!--

$Id: rss-0.91-uplevel.xsl,v 1.3 2001/08/09 23:59:34 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

This stylesheet is designed to render RSS 0.91 content into an RSS 1.0 format.

-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
                xmlns:dc="http://purl.org/dc/elements/1.1/"
                xmlns:uplevel="http://purl.org/rss/1.0/"
                version="1.0">

    <xsl:template match="/rss">

        <rdf:RDF>

            <xsl:apply-templates select="channel"/>
            <xsl:apply-templates select="channel/item"/>
            <xsl:apply-templates select="channel/textinput"/>

        </rdf:RDF>

    </xsl:template>

    <xsl:template match="channel">

        <uplevel:channel>

            <uplevel:title><xsl:value-of select="title"/></uplevel:title>
    
            <uplevel:link><xsl:value-of select="link"/></uplevel:link>
    
            <uplevel:description><xsl:value-of select="description"/></uplevel:description>

            <xsl:apply-templates select="image"/>

        </uplevel:channel>

    </xsl:template>

    <xsl:template match="image">

        <uplevel:image rdf:about="{link}">

            <uplevel:title><xsl:value-of select="title"/></uplevel:title>

            <uplevel:link><xsl:value-of select="link"/></uplevel:link>
    
            <uplevel:url><xsl:value-of select="url"/></uplevel:url>

            <xsl:if test="width != 0">

                <uplevel:width><xsl:value-of select="width"/></uplevel:width>

            </xsl:if>

            <xsl:if test="height != 0">

                <uplevel:height><xsl:value-of select="height"/></uplevel:height>

            </xsl:if>

            <xsl:apply-templates/>

        </uplevel:image>

    </xsl:template>

    <xsl:template match="item">

        <uplevel:item>

            <uplevel:title><xsl:value-of select="title"/></uplevel:title>
    
            <uplevel:link><xsl:value-of select="link"/></uplevel:link>
    
            <uplevel:description><xsl:value-of select="description"/></uplevel:description>

            <xsl:apply-templates/>

        </uplevel:item>

    </xsl:template>

    <xsl:template match="textinput">

        <uplevel:textinput rdf:about="{link}">

            <uplevel:title><xsl:value-of select="title"/></uplevel:title>

            <uplevel:link><xsl:value-of select="link"/></uplevel:link>

            <uplevel:name><xsl:value-of select="name"/></uplevel:name>

            <uplevel:description><xsl:value-of select="description"/></uplevel:description>

            <xsl:apply-templates/>

        </uplevel:textinput>

    </xsl:template>    

    <!-- Now we need to perform identity transformations on all additional nodes -->

    <xsl:template match="@*|node()">

        <xsl:copy>

            <xsl:apply-templates select="@*|node()"/>

        </xsl:copy>

    </xsl:template>

</xsl:stylesheet>
