<?xml version="1.0"?> 

<!--

$Id: update.xsl,v 1.6 2001/09/24 08:52:27 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

Handles updating subscriptions.

- (DONE) If we need to create a new layer and it isn't already present, add it

- (DONE) if the given channel and info isn't already present add it

- If the channel *is* present, update it. 

See http://reptile.openprivacy.org for more information

TODO:

- need to add the new content.

-->

<xsl:stylesheet xmlns:layout="http://schemas.openprivacy.org/reptile/layout"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                version="1.0">

    <!-- by default, copy all matching templates -->
    <xsl:include href="resource:/xsl/misc/copy.xsl"/>

    <xsl:output indent="yes" 
                omit-xml-declaration="yes"/>                

    <xsl:param name="reptile.home.location" select="''"/>

    <!-- The following params are given in order to modify this subscription
    markup -->
    <xsl:param name="reptile.channel-management.edit.layer" select="''"/>

    <xsl:param name="reptile.channel-management.edit.column" select="''"/>

    <xsl:param name="reptile.channel-management.edit.numcolumns" select="'2'"/>
    
    <!-- this should be the contentType and location of the channel that you
    need to update -->

    <xsl:param name="reptile.channel-management.location" select="''"/>

    <xsl:param name="reptile.channel-management.contentType" select="''"/>

    <xsl:template match="/layout:layout">

        <!-- Make sure we have required params -->
        <xsl:if test=" $reptile.channel-management.location = '' or 
                       $reptile.channel-management.contentType = '' or 
                       $reptile.channel-management.edit.column = '' or
                       $reptile.channel-management.edit.layer = '' ">

            <xsl:message terminate="yes">Required params were not specified</xsl:message>

        </xsl:if>
        
        <layout:layout>

        <xsl:apply-templates/>

        <!-- FIXME need to add new content here but only if it doesn't already exist. -->

        <xsl:if test="count( ./layout:content[@location = $reptile.channel-management.location] ) = 0">

        <xsl:message>adding channel</xsl:message>

        <layout:content location="{$reptile.channel-management.location}" 
                        contentType="{$reptile.channel-management.contentType}">

            <layout:position column="{$reptile.channel-management.edit.column}" layer="{$reptile.channel-management.edit.layer}"/>            

        </layout:content>

        </xsl:if>

        </layout:layout>

    </xsl:template>

    <xsl:template match="layout:layer-index">

        <layout:layer-index default="{@default}">

        <!-- add the new layer if necessary... don't do anythign if we already
        have a layer of the same name.... that lead to duplicate layers.

        -->
        <xsl:if test="count( ./layout:layer[@name = $reptile.channel-management.edit.layer] ) = 0">

            <layout:layer name="{$reptile.channel-management.edit.layer}" 
                          numColumns="{$reptile.channel-management.edit.numcolumns}"/>

        </xsl:if>

        <xsl:apply-templates/>
        
        </layout:layer-index>

    </xsl:template>

    <!-- match content and update if necessary -->
    <xsl:template match="layout:content">
    
        <xsl:choose>

        <xsl:when test="@location = $reptile.channel-management.location">

            <xsl:message> updating channel </xsl:message>

            <!-- use the given values... -->
            <layout:content location="{$reptile.channel-management.location}" 
                            contentType="{$reptile.channel-management.contentType}">
                            
                <layout:position column="{$reptile.channel-management.edit.column}" 
                                 layer="{$reptile.channel-management.edit.layer}"/>            
                
            </layout:content>

        </xsl:when>

        <xsl:otherwise>
        
            <!-- otherwise just copy this... -->

            <layout:content location="{@location}" 
                            contentType="{@contentType}">
                            
                <layout:position column="{./layout:position/@column}" layer="{./layout:position/@layer}"/>            
                
            </layout:content>
        
        </xsl:otherwise>

        </xsl:choose>

    </xsl:template>

</xsl:stylesheet>

