<?xml version="1.0"?> 

<!--

$Id: structure.xsl,v 1.5 2001/08/04 10:10:52 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

Handles building the structure for this reputation-management session.

See http://reptile.openprivacy.org for more information

-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:cm="http://schemas.openprivacy.org/reptile/channel-management"
                xmlns:layout="http://schemas.openprivacy.org/reptile/layout"
                xmlns:functions="xalan://org.openprivacy.reptile.extensions.Functions"
                extension-element-prefixes="functions"
                version="1.0">

    <xsl:output indent="yes" 
                omit-xml-declaration="yes"/>                

    <!-- declare all parameters and provide default values -->
    <xsl:param name="reptile.channel-management.location" select="''"/>
    <xsl:param name="reptile.channel-management.contentType" select="''"/>

    <xsl:template match="/cm:channel-management">

        <layout:layout>

            <layout:layer-index default="Channel Management">
        
                <layout:layer name="Channel Management" numColumns="2"/>
    
            </layout:layer-index>
    
    
            <layout:content contentType="{$reptile.channel-management.contentType}">
    
                <xsl:attribute name="location">
    
                    <xsl:value-of select="functions:decode( $reptile.channel-management.location )"/>
    
                </xsl:attribute>
    
                <layout:position column="left" layer="Channel Management"/>
    
            </layout:content>
    
            <layout:content location="urn:channel-management/edit" 
                            contentType="http://schemas.openprivacy.org/reptile/stylesheet-sequence">
    
                <layout:position column="right" layer="Channel Management"/>
    
            </layout:content>


            <layout:content contentType="http://schemas.openprivacy.org/reptile/stylesheet-sequence" 
                            location="urn:quick-channel/channel-list">
        
                <layout:position layer="Channel Management" column="right"/>
        
            </layout:content>




        </layout:layout>

    </xsl:template>

</xsl:stylesheet>





